/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.fsx.model.WindowsAccessAuditLogLevel;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WindowsAuditLogConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WindowsAuditLogConfiguration> {
    private static final SdkField<String> FILE_ACCESS_AUDIT_LOG_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FileAccessAuditLogLevel").getter(WindowsAuditLogConfiguration.getter(WindowsAuditLogConfiguration::fileAccessAuditLogLevelAsString)).setter(WindowsAuditLogConfiguration.setter(Builder::fileAccessAuditLogLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileAccessAuditLogLevel").build()}).build();
    private static final SdkField<String> FILE_SHARE_ACCESS_AUDIT_LOG_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FileShareAccessAuditLogLevel").getter(WindowsAuditLogConfiguration.getter(WindowsAuditLogConfiguration::fileShareAccessAuditLogLevelAsString)).setter(WindowsAuditLogConfiguration.setter(Builder::fileShareAccessAuditLogLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileShareAccessAuditLogLevel").build()}).build();
    private static final SdkField<String> AUDIT_LOG_DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AuditLogDestination").getter(WindowsAuditLogConfiguration.getter(WindowsAuditLogConfiguration::auditLogDestination)).setter(WindowsAuditLogConfiguration.setter(Builder::auditLogDestination)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuditLogDestination").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_ACCESS_AUDIT_LOG_LEVEL_FIELD, FILE_SHARE_ACCESS_AUDIT_LOG_LEVEL_FIELD, AUDIT_LOG_DESTINATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String fileAccessAuditLogLevel;
    private final String fileShareAccessAuditLogLevel;
    private final String auditLogDestination;

    private WindowsAuditLogConfiguration(BuilderImpl builder) {
        this.fileAccessAuditLogLevel = builder.fileAccessAuditLogLevel;
        this.fileShareAccessAuditLogLevel = builder.fileShareAccessAuditLogLevel;
        this.auditLogDestination = builder.auditLogDestination;
    }

    public final WindowsAccessAuditLogLevel fileAccessAuditLogLevel() {
        return WindowsAccessAuditLogLevel.fromValue(this.fileAccessAuditLogLevel);
    }

    public final String fileAccessAuditLogLevelAsString() {
        return this.fileAccessAuditLogLevel;
    }

    public final WindowsAccessAuditLogLevel fileShareAccessAuditLogLevel() {
        return WindowsAccessAuditLogLevel.fromValue(this.fileShareAccessAuditLogLevel);
    }

    public final String fileShareAccessAuditLogLevelAsString() {
        return this.fileShareAccessAuditLogLevel;
    }

    public final String auditLogDestination() {
        return this.auditLogDestination;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fileAccessAuditLogLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileShareAccessAuditLogLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.auditLogDestination());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WindowsAuditLogConfiguration)) {
            return false;
        }
        WindowsAuditLogConfiguration other = (WindowsAuditLogConfiguration)obj;
        return Objects.equals(this.fileAccessAuditLogLevelAsString(), other.fileAccessAuditLogLevelAsString()) && Objects.equals(this.fileShareAccessAuditLogLevelAsString(), other.fileShareAccessAuditLogLevelAsString()) && Objects.equals(this.auditLogDestination(), other.auditLogDestination());
    }

    public final String toString() {
        return ToString.builder((String)"WindowsAuditLogConfiguration").add("FileAccessAuditLogLevel", (Object)this.fileAccessAuditLogLevelAsString()).add("FileShareAccessAuditLogLevel", (Object)this.fileShareAccessAuditLogLevelAsString()).add("AuditLogDestination", (Object)this.auditLogDestination()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FileAccessAuditLogLevel": {
                return Optional.ofNullable(clazz.cast(this.fileAccessAuditLogLevelAsString()));
            }
            case "FileShareAccessAuditLogLevel": {
                return Optional.ofNullable(clazz.cast(this.fileShareAccessAuditLogLevelAsString()));
            }
            case "AuditLogDestination": {
                return Optional.ofNullable(clazz.cast(this.auditLogDestination()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WindowsAuditLogConfiguration, T> g) {
        return obj -> g.apply((WindowsAuditLogConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String fileAccessAuditLogLevel;
        private String fileShareAccessAuditLogLevel;
        private String auditLogDestination;

        private BuilderImpl() {
        }

        private BuilderImpl(WindowsAuditLogConfiguration model) {
            this.fileAccessAuditLogLevel(model.fileAccessAuditLogLevel);
            this.fileShareAccessAuditLogLevel(model.fileShareAccessAuditLogLevel);
            this.auditLogDestination(model.auditLogDestination);
        }

        public final String getFileAccessAuditLogLevel() {
            return this.fileAccessAuditLogLevel;
        }

        @Override
        public final Builder fileAccessAuditLogLevel(String fileAccessAuditLogLevel) {
            this.fileAccessAuditLogLevel = fileAccessAuditLogLevel;
            return this;
        }

        @Override
        public final Builder fileAccessAuditLogLevel(WindowsAccessAuditLogLevel fileAccessAuditLogLevel) {
            this.fileAccessAuditLogLevel(fileAccessAuditLogLevel == null ? null : fileAccessAuditLogLevel.toString());
            return this;
        }

        public final void setFileAccessAuditLogLevel(String fileAccessAuditLogLevel) {
            this.fileAccessAuditLogLevel = fileAccessAuditLogLevel;
        }

        public final String getFileShareAccessAuditLogLevel() {
            return this.fileShareAccessAuditLogLevel;
        }

        @Override
        public final Builder fileShareAccessAuditLogLevel(String fileShareAccessAuditLogLevel) {
            this.fileShareAccessAuditLogLevel = fileShareAccessAuditLogLevel;
            return this;
        }

        @Override
        public final Builder fileShareAccessAuditLogLevel(WindowsAccessAuditLogLevel fileShareAccessAuditLogLevel) {
            this.fileShareAccessAuditLogLevel(fileShareAccessAuditLogLevel == null ? null : fileShareAccessAuditLogLevel.toString());
            return this;
        }

        public final void setFileShareAccessAuditLogLevel(String fileShareAccessAuditLogLevel) {
            this.fileShareAccessAuditLogLevel = fileShareAccessAuditLogLevel;
        }

        public final String getAuditLogDestination() {
            return this.auditLogDestination;
        }

        @Override
        public final Builder auditLogDestination(String auditLogDestination) {
            this.auditLogDestination = auditLogDestination;
            return this;
        }

        public final void setAuditLogDestination(String auditLogDestination) {
            this.auditLogDestination = auditLogDestination;
        }

        public WindowsAuditLogConfiguration build() {
            return new WindowsAuditLogConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WindowsAuditLogConfiguration> {
        public Builder fileAccessAuditLogLevel(String var1);

        public Builder fileAccessAuditLogLevel(WindowsAccessAuditLogLevel var1);

        public Builder fileShareAccessAuditLogLevel(String var1);

        public Builder fileShareAccessAuditLogLevel(WindowsAccessAuditLogLevel var1);

        public Builder auditLogDestination(String var1);
    }
}

