/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum DataCompressionType {
    NONE("NONE"),
    LZ4("LZ4"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private DataCompressionType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DataCompressionType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(DataCompressionType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DataCompressionType> knownValues() {
        return Stream.of(DataCompressionType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

