/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fsx.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;

/**
 * <p>
 * Describes the type of administrative action, as follows:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <code>FILE_SYSTEM_UPDATE</code> - A file system update administrative action initiated by the user from the Amazon
 * FSx console, API (UpdateFileSystem), or CLI (update-file-system).
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>STORAGE_OPTIMIZATION</code> - Once the <code>FILE_SYSTEM_UPDATE</code> task to increase a file system's storage
 * capacity completes successfully, a <code>STORAGE_OPTIMIZATION</code> task starts.
 * </p>
 * <ul>
 * <li>
 * <p>
 * For Windows, storage optimization is the process of migrating the file system data to the new, larger disks.
 * </p>
 * </li>
 * <li>
 * <p>
 * For Lustre, storage optimization consists of rebalancing the data across the existing and newly added file servers.
 * </p>
 * </li>
 * </ul>
 * <p>
 * You can track the storage optimization progress using the <code>ProgressPercent</code> property. When
 * <code>STORAGE_OPTIMIZATION</code> completes successfully, the parent <code>FILE_SYSTEM_UPDATE</code> action status
 * changes to <code>COMPLETED</code>. For more information, see <a
 * href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-storage-capacity.html">Managing storage
 * capacity</a> in the <i>Amazon FSx for Windows File Server User Guide</i> and <a
 * href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/managing-storage-capacity.html">Managing storage and
 * throughput capacity</a> in the <i>Amazon FSx for Lustre User Guide</i>.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>FILE_SYSTEM_ALIAS_ASSOCIATION</code> - A file system update to associate a new DNS alias with the file system.
 * For more information, see .
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>FILE_SYSTEM_ALIAS_DISASSOCIATION</code> - A file system update to disassociate a DNS alias from the file
 * system. For more information, see .
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public enum AdministrativeActionType {
    FILE_SYSTEM_UPDATE("FILE_SYSTEM_UPDATE"),

    STORAGE_OPTIMIZATION("STORAGE_OPTIMIZATION"),

    FILE_SYSTEM_ALIAS_ASSOCIATION("FILE_SYSTEM_ALIAS_ASSOCIATION"),

    FILE_SYSTEM_ALIAS_DISASSOCIATION("FILE_SYSTEM_ALIAS_DISASSOCIATION"),

    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private AdministrativeActionType(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return AdministrativeActionType corresponding to the value
     */
    public static AdministrativeActionType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(AdministrativeActionType.values()).filter(e -> e.toString().equals(value)).findFirst()
                .orElse(UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link AdministrativeActionType}s
     */
    public static Set<AdministrativeActionType> knownValues() {
        return Stream.of(values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}
