/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.fsx.model.DataRepositoryConfiguration;
import software.amazon.awssdk.services.fsx.model.LustreDeploymentType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LustreFileSystemConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LustreFileSystemConfiguration> {
    private static final SdkField<String> WEEKLY_MAINTENANCE_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(LustreFileSystemConfiguration.getter(LustreFileSystemConfiguration::weeklyMaintenanceStartTime)).setter(LustreFileSystemConfiguration.setter(Builder::weeklyMaintenanceStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WeeklyMaintenanceStartTime").build()}).build();
    private static final SdkField<DataRepositoryConfiguration> DATA_REPOSITORY_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(LustreFileSystemConfiguration.getter(LustreFileSystemConfiguration::dataRepositoryConfiguration)).setter(LustreFileSystemConfiguration.setter(Builder::dataRepositoryConfiguration)).constructor(DataRepositoryConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataRepositoryConfiguration").build()}).build();
    private static final SdkField<String> DEPLOYMENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(LustreFileSystemConfiguration.getter(LustreFileSystemConfiguration::deploymentTypeAsString)).setter(LustreFileSystemConfiguration.setter(Builder::deploymentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentType").build()}).build();
    private static final SdkField<Integer> PER_UNIT_STORAGE_THROUGHPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(LustreFileSystemConfiguration.getter(LustreFileSystemConfiguration::perUnitStorageThroughput)).setter(LustreFileSystemConfiguration.setter(Builder::perUnitStorageThroughput)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PerUnitStorageThroughput").build()}).build();
    private static final SdkField<String> MOUNT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(LustreFileSystemConfiguration.getter(LustreFileSystemConfiguration::mountName)).setter(LustreFileSystemConfiguration.setter(Builder::mountName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MountName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WEEKLY_MAINTENANCE_START_TIME_FIELD, DATA_REPOSITORY_CONFIGURATION_FIELD, DEPLOYMENT_TYPE_FIELD, PER_UNIT_STORAGE_THROUGHPUT_FIELD, MOUNT_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String weeklyMaintenanceStartTime;
    private final DataRepositoryConfiguration dataRepositoryConfiguration;
    private final String deploymentType;
    private final Integer perUnitStorageThroughput;
    private final String mountName;

    private LustreFileSystemConfiguration(BuilderImpl builder) {
        this.weeklyMaintenanceStartTime = builder.weeklyMaintenanceStartTime;
        this.dataRepositoryConfiguration = builder.dataRepositoryConfiguration;
        this.deploymentType = builder.deploymentType;
        this.perUnitStorageThroughput = builder.perUnitStorageThroughput;
        this.mountName = builder.mountName;
    }

    public String weeklyMaintenanceStartTime() {
        return this.weeklyMaintenanceStartTime;
    }

    public DataRepositoryConfiguration dataRepositoryConfiguration() {
        return this.dataRepositoryConfiguration;
    }

    public LustreDeploymentType deploymentType() {
        return LustreDeploymentType.fromValue(this.deploymentType);
    }

    public String deploymentTypeAsString() {
        return this.deploymentType;
    }

    public Integer perUnitStorageThroughput() {
        return this.perUnitStorageThroughput;
    }

    public String mountName() {
        return this.mountName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.weeklyMaintenanceStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataRepositoryConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.perUnitStorageThroughput());
        hashCode = 31 * hashCode + Objects.hashCode(this.mountName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LustreFileSystemConfiguration)) {
            return false;
        }
        LustreFileSystemConfiguration other = (LustreFileSystemConfiguration)obj;
        return Objects.equals(this.weeklyMaintenanceStartTime(), other.weeklyMaintenanceStartTime()) && Objects.equals(this.dataRepositoryConfiguration(), other.dataRepositoryConfiguration()) && Objects.equals(this.deploymentTypeAsString(), other.deploymentTypeAsString()) && Objects.equals(this.perUnitStorageThroughput(), other.perUnitStorageThroughput()) && Objects.equals(this.mountName(), other.mountName());
    }

    public String toString() {
        return ToString.builder((String)"LustreFileSystemConfiguration").add("WeeklyMaintenanceStartTime", (Object)this.weeklyMaintenanceStartTime()).add("DataRepositoryConfiguration", (Object)this.dataRepositoryConfiguration()).add("DeploymentType", (Object)this.deploymentTypeAsString()).add("PerUnitStorageThroughput", (Object)this.perUnitStorageThroughput()).add("MountName", (Object)this.mountName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WeeklyMaintenanceStartTime": {
                return Optional.ofNullable(clazz.cast(this.weeklyMaintenanceStartTime()));
            }
            case "DataRepositoryConfiguration": {
                return Optional.ofNullable(clazz.cast(this.dataRepositoryConfiguration()));
            }
            case "DeploymentType": {
                return Optional.ofNullable(clazz.cast(this.deploymentTypeAsString()));
            }
            case "PerUnitStorageThroughput": {
                return Optional.ofNullable(clazz.cast(this.perUnitStorageThroughput()));
            }
            case "MountName": {
                return Optional.ofNullable(clazz.cast(this.mountName()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LustreFileSystemConfiguration, T> g) {
        return obj -> g.apply((LustreFileSystemConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String weeklyMaintenanceStartTime;
        private DataRepositoryConfiguration dataRepositoryConfiguration;
        private String deploymentType;
        private Integer perUnitStorageThroughput;
        private String mountName;

        private BuilderImpl() {
        }

        private BuilderImpl(LustreFileSystemConfiguration model) {
            this.weeklyMaintenanceStartTime(model.weeklyMaintenanceStartTime);
            this.dataRepositoryConfiguration(model.dataRepositoryConfiguration);
            this.deploymentType(model.deploymentType);
            this.perUnitStorageThroughput(model.perUnitStorageThroughput);
            this.mountName(model.mountName);
        }

        public final String getWeeklyMaintenanceStartTime() {
            return this.weeklyMaintenanceStartTime;
        }

        @Override
        public final Builder weeklyMaintenanceStartTime(String weeklyMaintenanceStartTime) {
            this.weeklyMaintenanceStartTime = weeklyMaintenanceStartTime;
            return this;
        }

        public final void setWeeklyMaintenanceStartTime(String weeklyMaintenanceStartTime) {
            this.weeklyMaintenanceStartTime = weeklyMaintenanceStartTime;
        }

        public final DataRepositoryConfiguration.Builder getDataRepositoryConfiguration() {
            return this.dataRepositoryConfiguration != null ? this.dataRepositoryConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder dataRepositoryConfiguration(DataRepositoryConfiguration dataRepositoryConfiguration) {
            this.dataRepositoryConfiguration = dataRepositoryConfiguration;
            return this;
        }

        public final void setDataRepositoryConfiguration(DataRepositoryConfiguration.BuilderImpl dataRepositoryConfiguration) {
            this.dataRepositoryConfiguration = dataRepositoryConfiguration != null ? dataRepositoryConfiguration.build() : null;
        }

        public final String getDeploymentTypeAsString() {
            return this.deploymentType;
        }

        @Override
        public final Builder deploymentType(String deploymentType) {
            this.deploymentType = deploymentType;
            return this;
        }

        @Override
        public final Builder deploymentType(LustreDeploymentType deploymentType) {
            this.deploymentType(deploymentType == null ? null : deploymentType.toString());
            return this;
        }

        public final void setDeploymentType(String deploymentType) {
            this.deploymentType = deploymentType;
        }

        public final Integer getPerUnitStorageThroughput() {
            return this.perUnitStorageThroughput;
        }

        @Override
        public final Builder perUnitStorageThroughput(Integer perUnitStorageThroughput) {
            this.perUnitStorageThroughput = perUnitStorageThroughput;
            return this;
        }

        public final void setPerUnitStorageThroughput(Integer perUnitStorageThroughput) {
            this.perUnitStorageThroughput = perUnitStorageThroughput;
        }

        public final String getMountName() {
            return this.mountName;
        }

        @Override
        public final Builder mountName(String mountName) {
            this.mountName = mountName;
            return this;
        }

        public final void setMountName(String mountName) {
            this.mountName = mountName;
        }

        public LustreFileSystemConfiguration build() {
            return new LustreFileSystemConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LustreFileSystemConfiguration> {
        public Builder weeklyMaintenanceStartTime(String var1);

        public Builder dataRepositoryConfiguration(DataRepositoryConfiguration var1);

        default public Builder dataRepositoryConfiguration(Consumer<DataRepositoryConfiguration.Builder> dataRepositoryConfiguration) {
            return this.dataRepositoryConfiguration((DataRepositoryConfiguration)((DataRepositoryConfiguration.Builder)DataRepositoryConfiguration.builder().applyMutation(dataRepositoryConfiguration)).build());
        }

        public Builder deploymentType(String var1);

        public Builder deploymentType(LustreDeploymentType var1);

        public Builder perUnitStorageThroughput(Integer var1);

        public Builder mountName(String var1);
    }
}

