/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.fsx.model.DnsIpsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SelfManagedActiveDirectoryAttributes
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SelfManagedActiveDirectoryAttributes> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SelfManagedActiveDirectoryAttributes.getter(SelfManagedActiveDirectoryAttributes::domainName)).setter(SelfManagedActiveDirectoryAttributes.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()}).build();
    private static final SdkField<String> ORGANIZATIONAL_UNIT_DISTINGUISHED_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SelfManagedActiveDirectoryAttributes.getter(SelfManagedActiveDirectoryAttributes::organizationalUnitDistinguishedName)).setter(SelfManagedActiveDirectoryAttributes.setter(Builder::organizationalUnitDistinguishedName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationalUnitDistinguishedName").build()}).build();
    private static final SdkField<String> FILE_SYSTEM_ADMINISTRATORS_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SelfManagedActiveDirectoryAttributes.getter(SelfManagedActiveDirectoryAttributes::fileSystemAdministratorsGroup)).setter(SelfManagedActiveDirectoryAttributes.setter(Builder::fileSystemAdministratorsGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSystemAdministratorsGroup").build()}).build();
    private static final SdkField<String> USER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SelfManagedActiveDirectoryAttributes.getter(SelfManagedActiveDirectoryAttributes::userName)).setter(SelfManagedActiveDirectoryAttributes.setter(Builder::userName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserName").build()}).build();
    private static final SdkField<List<String>> DNS_IPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(SelfManagedActiveDirectoryAttributes.getter(SelfManagedActiveDirectoryAttributes::dnsIps)).setter(SelfManagedActiveDirectoryAttributes.setter(Builder::dnsIps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DnsIps").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD, ORGANIZATIONAL_UNIT_DISTINGUISHED_NAME_FIELD, FILE_SYSTEM_ADMINISTRATORS_GROUP_FIELD, USER_NAME_FIELD, DNS_IPS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String domainName;
    private final String organizationalUnitDistinguishedName;
    private final String fileSystemAdministratorsGroup;
    private final String userName;
    private final List<String> dnsIps;

    private SelfManagedActiveDirectoryAttributes(BuilderImpl builder) {
        this.domainName = builder.domainName;
        this.organizationalUnitDistinguishedName = builder.organizationalUnitDistinguishedName;
        this.fileSystemAdministratorsGroup = builder.fileSystemAdministratorsGroup;
        this.userName = builder.userName;
        this.dnsIps = builder.dnsIps;
    }

    public String domainName() {
        return this.domainName;
    }

    public String organizationalUnitDistinguishedName() {
        return this.organizationalUnitDistinguishedName;
    }

    public String fileSystemAdministratorsGroup() {
        return this.fileSystemAdministratorsGroup;
    }

    public String userName() {
        return this.userName;
    }

    public List<String> dnsIps() {
        return this.dnsIps;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.organizationalUnitDistinguishedName());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileSystemAdministratorsGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.userName());
        hashCode = 31 * hashCode + Objects.hashCode(this.dnsIps());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SelfManagedActiveDirectoryAttributes)) {
            return false;
        }
        SelfManagedActiveDirectoryAttributes other = (SelfManagedActiveDirectoryAttributes)obj;
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.organizationalUnitDistinguishedName(), other.organizationalUnitDistinguishedName()) && Objects.equals(this.fileSystemAdministratorsGroup(), other.fileSystemAdministratorsGroup()) && Objects.equals(this.userName(), other.userName()) && Objects.equals(this.dnsIps(), other.dnsIps());
    }

    public String toString() {
        return ToString.builder((String)"SelfManagedActiveDirectoryAttributes").add("DomainName", (Object)this.domainName()).add("OrganizationalUnitDistinguishedName", (Object)this.organizationalUnitDistinguishedName()).add("FileSystemAdministratorsGroup", (Object)this.fileSystemAdministratorsGroup()).add("UserName", (Object)this.userName()).add("DnsIps", this.dnsIps()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "OrganizationalUnitDistinguishedName": {
                return Optional.ofNullable(clazz.cast(this.organizationalUnitDistinguishedName()));
            }
            case "FileSystemAdministratorsGroup": {
                return Optional.ofNullable(clazz.cast(this.fileSystemAdministratorsGroup()));
            }
            case "UserName": {
                return Optional.ofNullable(clazz.cast(this.userName()));
            }
            case "DnsIps": {
                return Optional.ofNullable(clazz.cast(this.dnsIps()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SelfManagedActiveDirectoryAttributes, T> g) {
        return obj -> g.apply((SelfManagedActiveDirectoryAttributes)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String domainName;
        private String organizationalUnitDistinguishedName;
        private String fileSystemAdministratorsGroup;
        private String userName;
        private List<String> dnsIps = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SelfManagedActiveDirectoryAttributes model) {
            this.domainName(model.domainName);
            this.organizationalUnitDistinguishedName(model.organizationalUnitDistinguishedName);
            this.fileSystemAdministratorsGroup(model.fileSystemAdministratorsGroup);
            this.userName(model.userName);
            this.dnsIps(model.dnsIps);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final String getOrganizationalUnitDistinguishedName() {
            return this.organizationalUnitDistinguishedName;
        }

        @Override
        public final Builder organizationalUnitDistinguishedName(String organizationalUnitDistinguishedName) {
            this.organizationalUnitDistinguishedName = organizationalUnitDistinguishedName;
            return this;
        }

        public final void setOrganizationalUnitDistinguishedName(String organizationalUnitDistinguishedName) {
            this.organizationalUnitDistinguishedName = organizationalUnitDistinguishedName;
        }

        public final String getFileSystemAdministratorsGroup() {
            return this.fileSystemAdministratorsGroup;
        }

        @Override
        public final Builder fileSystemAdministratorsGroup(String fileSystemAdministratorsGroup) {
            this.fileSystemAdministratorsGroup = fileSystemAdministratorsGroup;
            return this;
        }

        public final void setFileSystemAdministratorsGroup(String fileSystemAdministratorsGroup) {
            this.fileSystemAdministratorsGroup = fileSystemAdministratorsGroup;
        }

        public final String getUserName() {
            return this.userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        public final Collection<String> getDnsIps() {
            return this.dnsIps;
        }

        @Override
        public final Builder dnsIps(Collection<String> dnsIps) {
            this.dnsIps = DnsIpsCopier.copy(dnsIps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dnsIps(String ... dnsIps) {
            this.dnsIps(Arrays.asList(dnsIps));
            return this;
        }

        public final void setDnsIps(Collection<String> dnsIps) {
            this.dnsIps = DnsIpsCopier.copy(dnsIps);
        }

        public SelfManagedActiveDirectoryAttributes build() {
            return new SelfManagedActiveDirectoryAttributes(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SelfManagedActiveDirectoryAttributes> {
        public Builder domainName(String var1);

        public Builder organizationalUnitDistinguishedName(String var1);

        public Builder fileSystemAdministratorsGroup(String var1);

        public Builder userName(String var1);

        public Builder dnsIps(Collection<String> var1);

        public Builder dnsIps(String ... var1);
    }
}

