/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.freetier.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.freetier.model.FreeTierResponse;
import software.amazon.awssdk.services.freetier.model.FreeTierUsage;
import software.amazon.awssdk.services.freetier.model.FreeTierUsagesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetFreeTierUsageResponse
extends FreeTierResponse
implements ToCopyableBuilder<Builder, GetFreeTierUsageResponse> {
    private static final SdkField<List<FreeTierUsage>> FREE_TIER_USAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("freeTierUsages").getter(GetFreeTierUsageResponse.getter(GetFreeTierUsageResponse::freeTierUsages)).setter(GetFreeTierUsageResponse.setter(Builder::freeTierUsages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("freeTierUsages").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FreeTierUsage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(GetFreeTierUsageResponse.getter(GetFreeTierUsageResponse::nextToken)).setter(GetFreeTierUsageResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FREE_TIER_USAGES_FIELD, NEXT_TOKEN_FIELD));
    private final List<FreeTierUsage> freeTierUsages;
    private final String nextToken;

    private GetFreeTierUsageResponse(BuilderImpl builder) {
        super(builder);
        this.freeTierUsages = builder.freeTierUsages;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasFreeTierUsages() {
        return this.freeTierUsages != null && !(this.freeTierUsages instanceof SdkAutoConstructList);
    }

    public final List<FreeTierUsage> freeTierUsages() {
        return this.freeTierUsages;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFreeTierUsages() ? this.freeTierUsages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetFreeTierUsageResponse)) {
            return false;
        }
        GetFreeTierUsageResponse other = (GetFreeTierUsageResponse)((Object)obj);
        return this.hasFreeTierUsages() == other.hasFreeTierUsages() && Objects.equals(this.freeTierUsages(), other.freeTierUsages()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetFreeTierUsageResponse").add("FreeTierUsages", this.hasFreeTierUsages() ? this.freeTierUsages() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "freeTierUsages": {
                return Optional.ofNullable(clazz.cast(this.freeTierUsages()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetFreeTierUsageResponse, T> g) {
        return obj -> g.apply((GetFreeTierUsageResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FreeTierResponse.BuilderImpl
    implements Builder {
        private List<FreeTierUsage> freeTierUsages = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetFreeTierUsageResponse model) {
            super(model);
            this.freeTierUsages(model.freeTierUsages);
            this.nextToken(model.nextToken);
        }

        public final List<FreeTierUsage.Builder> getFreeTierUsages() {
            List<FreeTierUsage.Builder> result = FreeTierUsagesCopier.copyToBuilder(this.freeTierUsages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFreeTierUsages(Collection<FreeTierUsage.BuilderImpl> freeTierUsages) {
            this.freeTierUsages = FreeTierUsagesCopier.copyFromBuilder(freeTierUsages);
        }

        @Override
        public final Builder freeTierUsages(Collection<FreeTierUsage> freeTierUsages) {
            this.freeTierUsages = FreeTierUsagesCopier.copy(freeTierUsages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder freeTierUsages(FreeTierUsage ... freeTierUsages) {
            this.freeTierUsages(Arrays.asList(freeTierUsages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder freeTierUsages(Consumer<FreeTierUsage.Builder> ... freeTierUsages) {
            this.freeTierUsages(Stream.of(freeTierUsages).map(c -> (FreeTierUsage)((FreeTierUsage.Builder)FreeTierUsage.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetFreeTierUsageResponse build() {
            return new GetFreeTierUsageResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends FreeTierResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetFreeTierUsageResponse> {
        public Builder freeTierUsages(Collection<FreeTierUsage> var1);

        public Builder freeTierUsages(FreeTierUsage ... var1);

        public Builder freeTierUsages(Consumer<FreeTierUsage.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

