/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.freetier.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.freetier.FreeTierClient;
import software.amazon.awssdk.services.freetier.internal.UserAgentUtils;
import software.amazon.awssdk.services.freetier.model.FreeTierUsage;
import software.amazon.awssdk.services.freetier.model.GetFreeTierUsageRequest;
import software.amazon.awssdk.services.freetier.model.GetFreeTierUsageResponse;

public class GetFreeTierUsageIterable
implements SdkIterable<GetFreeTierUsageResponse> {
    private final FreeTierClient client;
    private final GetFreeTierUsageRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetFreeTierUsageIterable(FreeTierClient client, GetFreeTierUsageRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetFreeTierUsageResponseFetcher();
    }

    public Iterator<GetFreeTierUsageResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<FreeTierUsage> freeTierUsages() {
        Function<GetFreeTierUsageResponse, Iterator> getIterator = response -> {
            if (response != null && response.freeTierUsages() != null) {
                return response.freeTierUsages().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetFreeTierUsageResponseFetcher
    implements SyncPageFetcher<GetFreeTierUsageResponse> {
        private GetFreeTierUsageResponseFetcher() {
        }

        public boolean hasNextPage(GetFreeTierUsageResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetFreeTierUsageResponse nextPage(GetFreeTierUsageResponse previousPage) {
            if (previousPage == null) {
                return GetFreeTierUsageIterable.this.client.getFreeTierUsage(GetFreeTierUsageIterable.this.firstRequest);
            }
            return GetFreeTierUsageIterable.this.client.getFreeTierUsage((GetFreeTierUsageRequest)((Object)GetFreeTierUsageIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

