/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.frauddetector.model.FraudDetectorRequest;
import software.amazon.awssdk.services.frauddetector.model.Tag;
import software.amazon.awssdk.services.frauddetector.model._tagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateBatchPredictionJobRequest
extends FraudDetectorRequest
implements ToCopyableBuilder<Builder, CreateBatchPredictionJobRequest> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobId").getter(CreateBatchPredictionJobRequest.getter(CreateBatchPredictionJobRequest::jobId)).setter(CreateBatchPredictionJobRequest.setter(Builder::jobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobId").build()}).build();
    private static final SdkField<String> INPUT_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("inputPath").getter(CreateBatchPredictionJobRequest.getter(CreateBatchPredictionJobRequest::inputPath)).setter(CreateBatchPredictionJobRequest.setter(Builder::inputPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputPath").build()}).build();
    private static final SdkField<String> OUTPUT_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("outputPath").getter(CreateBatchPredictionJobRequest.getter(CreateBatchPredictionJobRequest::outputPath)).setter(CreateBatchPredictionJobRequest.setter(Builder::outputPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputPath").build()}).build();
    private static final SdkField<String> EVENT_TYPE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("eventTypeName").getter(CreateBatchPredictionJobRequest.getter(CreateBatchPredictionJobRequest::eventTypeName)).setter(CreateBatchPredictionJobRequest.setter(Builder::eventTypeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventTypeName").build()}).build();
    private static final SdkField<String> DETECTOR_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("detectorName").getter(CreateBatchPredictionJobRequest.getter(CreateBatchPredictionJobRequest::detectorName)).setter(CreateBatchPredictionJobRequest.setter(Builder::detectorName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorName").build()}).build();
    private static final SdkField<String> DETECTOR_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("detectorVersion").getter(CreateBatchPredictionJobRequest.getter(CreateBatchPredictionJobRequest::detectorVersion)).setter(CreateBatchPredictionJobRequest.setter(Builder::detectorVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorVersion").build()}).build();
    private static final SdkField<String> IAM_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("iamRoleArn").getter(CreateBatchPredictionJobRequest.getter(CreateBatchPredictionJobRequest::iamRoleArn)).setter(CreateBatchPredictionJobRequest.setter(Builder::iamRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iamRoleArn").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(CreateBatchPredictionJobRequest.getter(CreateBatchPredictionJobRequest::tags)).setter(CreateBatchPredictionJobRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD, INPUT_PATH_FIELD, OUTPUT_PATH_FIELD, EVENT_TYPE_NAME_FIELD, DETECTOR_NAME_FIELD, DETECTOR_VERSION_FIELD, IAM_ROLE_ARN_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateBatchPredictionJobRequest.memberNameToFieldInitializer();
    private final String jobId;
    private final String inputPath;
    private final String outputPath;
    private final String eventTypeName;
    private final String detectorName;
    private final String detectorVersion;
    private final String iamRoleArn;
    private final List<Tag> tags;

    private CreateBatchPredictionJobRequest(BuilderImpl builder) {
        super(builder);
        this.jobId = builder.jobId;
        this.inputPath = builder.inputPath;
        this.outputPath = builder.outputPath;
        this.eventTypeName = builder.eventTypeName;
        this.detectorName = builder.detectorName;
        this.detectorVersion = builder.detectorVersion;
        this.iamRoleArn = builder.iamRoleArn;
        this.tags = builder.tags;
    }

    public final String jobId() {
        return this.jobId;
    }

    public final String inputPath() {
        return this.inputPath;
    }

    public final String outputPath() {
        return this.outputPath;
    }

    public final String eventTypeName() {
        return this.eventTypeName;
    }

    public final String detectorName() {
        return this.detectorName;
    }

    public final String detectorVersion() {
        return this.detectorVersion;
    }

    public final String iamRoleArn() {
        return this.iamRoleArn;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.jobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventTypeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.detectorName());
        hashCode = 31 * hashCode + Objects.hashCode(this.detectorVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateBatchPredictionJobRequest)) {
            return false;
        }
        CreateBatchPredictionJobRequest other = (CreateBatchPredictionJobRequest)((Object)obj);
        return Objects.equals(this.jobId(), other.jobId()) && Objects.equals(this.inputPath(), other.inputPath()) && Objects.equals(this.outputPath(), other.outputPath()) && Objects.equals(this.eventTypeName(), other.eventTypeName()) && Objects.equals(this.detectorName(), other.detectorName()) && Objects.equals(this.detectorVersion(), other.detectorVersion()) && Objects.equals(this.iamRoleArn(), other.iamRoleArn()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateBatchPredictionJobRequest").add("JobId", (Object)this.jobId()).add("InputPath", (Object)this.inputPath()).add("OutputPath", (Object)this.outputPath()).add("EventTypeName", (Object)this.eventTypeName()).add("DetectorName", (Object)this.detectorName()).add("DetectorVersion", (Object)this.detectorVersion()).add("IamRoleArn", (Object)this.iamRoleArn()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "jobId": {
                return Optional.ofNullable(clazz.cast(this.jobId()));
            }
            case "inputPath": {
                return Optional.ofNullable(clazz.cast(this.inputPath()));
            }
            case "outputPath": {
                return Optional.ofNullable(clazz.cast(this.outputPath()));
            }
            case "eventTypeName": {
                return Optional.ofNullable(clazz.cast(this.eventTypeName()));
            }
            case "detectorName": {
                return Optional.ofNullable(clazz.cast(this.detectorName()));
            }
            case "detectorVersion": {
                return Optional.ofNullable(clazz.cast(this.detectorVersion()));
            }
            case "iamRoleArn": {
                return Optional.ofNullable(clazz.cast(this.iamRoleArn()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("jobId", JOB_ID_FIELD);
        map.put("inputPath", INPUT_PATH_FIELD);
        map.put("outputPath", OUTPUT_PATH_FIELD);
        map.put("eventTypeName", EVENT_TYPE_NAME_FIELD);
        map.put("detectorName", DETECTOR_NAME_FIELD);
        map.put("detectorVersion", DETECTOR_VERSION_FIELD);
        map.put("iamRoleArn", IAM_ROLE_ARN_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateBatchPredictionJobRequest, T> g) {
        return obj -> g.apply((CreateBatchPredictionJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FraudDetectorRequest.BuilderImpl
    implements Builder {
        private String jobId;
        private String inputPath;
        private String outputPath;
        private String eventTypeName;
        private String detectorName;
        private String detectorVersion;
        private String iamRoleArn;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateBatchPredictionJobRequest model) {
            super(model);
            this.jobId(model.jobId);
            this.inputPath(model.inputPath);
            this.outputPath(model.outputPath);
            this.eventTypeName(model.eventTypeName);
            this.detectorName(model.detectorName);
            this.detectorVersion(model.detectorVersion);
            this.iamRoleArn(model.iamRoleArn);
            this.tags(model.tags);
        }

        public final String getJobId() {
            return this.jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final String getInputPath() {
            return this.inputPath;
        }

        public final void setInputPath(String inputPath) {
            this.inputPath = inputPath;
        }

        @Override
        public final Builder inputPath(String inputPath) {
            this.inputPath = inputPath;
            return this;
        }

        public final String getOutputPath() {
            return this.outputPath;
        }

        public final void setOutputPath(String outputPath) {
            this.outputPath = outputPath;
        }

        @Override
        public final Builder outputPath(String outputPath) {
            this.outputPath = outputPath;
            return this;
        }

        public final String getEventTypeName() {
            return this.eventTypeName;
        }

        public final void setEventTypeName(String eventTypeName) {
            this.eventTypeName = eventTypeName;
        }

        @Override
        public final Builder eventTypeName(String eventTypeName) {
            this.eventTypeName = eventTypeName;
            return this;
        }

        public final String getDetectorName() {
            return this.detectorName;
        }

        public final void setDetectorName(String detectorName) {
            this.detectorName = detectorName;
        }

        @Override
        public final Builder detectorName(String detectorName) {
            this.detectorName = detectorName;
            return this;
        }

        public final String getDetectorVersion() {
            return this.detectorVersion;
        }

        public final void setDetectorVersion(String detectorVersion) {
            this.detectorVersion = detectorVersion;
        }

        @Override
        public final Builder detectorVersion(String detectorVersion) {
            this.detectorVersion = detectorVersion;
            return this;
        }

        public final String getIamRoleArn() {
            return this.iamRoleArn;
        }

        public final void setIamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
        }

        @Override
        public final Builder iamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = _tagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = _tagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = _tagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateBatchPredictionJobRequest build() {
            return new CreateBatchPredictionJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends FraudDetectorRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateBatchPredictionJobRequest> {
        public Builder jobId(String var1);

        public Builder inputPath(String var1);

        public Builder outputPath(String var1);

        public Builder eventTypeName(String var1);

        public Builder detectorName(String var1);

        public Builder detectorVersion(String var1);

        public Builder iamRoleArn(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

