/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.frauddetector.FraudDetectorAsyncClient;
import software.amazon.awssdk.services.frauddetector.internal.UserAgentUtils;
import software.amazon.awssdk.services.frauddetector.model.GetBatchImportJobsRequest;
import software.amazon.awssdk.services.frauddetector.model.GetBatchImportJobsResponse;

public class GetBatchImportJobsPublisher
implements SdkPublisher<GetBatchImportJobsResponse> {
    private final FraudDetectorAsyncClient client;
    private final GetBatchImportJobsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetBatchImportJobsPublisher(FraudDetectorAsyncClient client, GetBatchImportJobsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetBatchImportJobsPublisher(FraudDetectorAsyncClient client, GetBatchImportJobsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetBatchImportJobsResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetBatchImportJobsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class GetBatchImportJobsResponseFetcher
    implements AsyncPageFetcher<GetBatchImportJobsResponse> {
        private GetBatchImportJobsResponseFetcher() {
        }

        public boolean hasNextPage(GetBatchImportJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetBatchImportJobsResponse> nextPage(GetBatchImportJobsResponse previousPage) {
            if (previousPage == null) {
                return GetBatchImportJobsPublisher.this.client.getBatchImportJobs(GetBatchImportJobsPublisher.this.firstRequest);
            }
            return GetBatchImportJobsPublisher.this.client.getBatchImportJobs((GetBatchImportJobsRequest)((Object)GetBatchImportJobsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

