/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.frauddetector.model.ListOfStringsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RuleResult
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RuleResult> {
    private static final SdkField<String> RULE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ruleId").getter(RuleResult.getter(RuleResult::ruleId)).setter(RuleResult.setter(Builder::ruleId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ruleId").build()}).build();
    private static final SdkField<List<String>> OUTCOMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("outcomes").getter(RuleResult.getter(RuleResult::outcomes)).setter(RuleResult.setter(Builder::outcomes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outcomes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_ID_FIELD, OUTCOMES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String ruleId;
    private final List<String> outcomes;

    private RuleResult(BuilderImpl builder) {
        this.ruleId = builder.ruleId;
        this.outcomes = builder.outcomes;
    }

    public final String ruleId() {
        return this.ruleId;
    }

    public final boolean hasOutcomes() {
        return this.outcomes != null && !(this.outcomes instanceof SdkAutoConstructList);
    }

    public final List<String> outcomes() {
        return this.outcomes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOutcomes() ? this.outcomes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleResult)) {
            return false;
        }
        RuleResult other = (RuleResult)obj;
        return Objects.equals(this.ruleId(), other.ruleId()) && this.hasOutcomes() == other.hasOutcomes() && Objects.equals(this.outcomes(), other.outcomes());
    }

    public final String toString() {
        return ToString.builder((String)"RuleResult").add("RuleId", (Object)this.ruleId()).add("Outcomes", this.hasOutcomes() ? this.outcomes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ruleId": {
                return Optional.ofNullable(clazz.cast(this.ruleId()));
            }
            case "outcomes": {
                return Optional.ofNullable(clazz.cast(this.outcomes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RuleResult, T> g) {
        return obj -> g.apply((RuleResult)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String ruleId;
        private List<String> outcomes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RuleResult model) {
            this.ruleId(model.ruleId);
            this.outcomes(model.outcomes);
        }

        public final String getRuleId() {
            return this.ruleId;
        }

        public final void setRuleId(String ruleId) {
            this.ruleId = ruleId;
        }

        @Override
        public final Builder ruleId(String ruleId) {
            this.ruleId = ruleId;
            return this;
        }

        public final Collection<String> getOutcomes() {
            if (this.outcomes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.outcomes;
        }

        public final void setOutcomes(Collection<String> outcomes) {
            this.outcomes = ListOfStringsCopier.copy(outcomes);
        }

        @Override
        public final Builder outcomes(Collection<String> outcomes) {
            this.outcomes = ListOfStringsCopier.copy(outcomes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outcomes(String ... outcomes) {
            this.outcomes(Arrays.asList(outcomes));
            return this;
        }

        public RuleResult build() {
            return new RuleResult(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RuleResult> {
        public Builder ruleId(String var1);

        public Builder outcomes(Collection<String> var1);

        public Builder outcomes(String ... var1);
    }
}

