/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.frauddetector.model.ModelSource;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExternalModelSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExternalModelSummary> {
    private static final SdkField<String> MODEL_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("modelEndpoint").getter(ExternalModelSummary.getter(ExternalModelSummary::modelEndpoint)).setter(ExternalModelSummary.setter(Builder::modelEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelEndpoint").build()}).build();
    private static final SdkField<String> MODEL_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("modelSource").getter(ExternalModelSummary.getter(ExternalModelSummary::modelSourceAsString)).setter(ExternalModelSummary.setter(Builder::modelSource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelSource").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_ENDPOINT_FIELD, MODEL_SOURCE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String modelEndpoint;
    private final String modelSource;

    private ExternalModelSummary(BuilderImpl builder) {
        this.modelEndpoint = builder.modelEndpoint;
        this.modelSource = builder.modelSource;
    }

    public final String modelEndpoint() {
        return this.modelEndpoint;
    }

    public final ModelSource modelSource() {
        return ModelSource.fromValue(this.modelSource);
    }

    public final String modelSourceAsString() {
        return this.modelSource;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.modelEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelSourceAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExternalModelSummary)) {
            return false;
        }
        ExternalModelSummary other = (ExternalModelSummary)obj;
        return Objects.equals(this.modelEndpoint(), other.modelEndpoint()) && Objects.equals(this.modelSourceAsString(), other.modelSourceAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ExternalModelSummary").add("ModelEndpoint", (Object)this.modelEndpoint()).add("ModelSource", (Object)this.modelSourceAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "modelEndpoint": {
                return Optional.ofNullable(clazz.cast(this.modelEndpoint()));
            }
            case "modelSource": {
                return Optional.ofNullable(clazz.cast(this.modelSourceAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExternalModelSummary, T> g) {
        return obj -> g.apply((ExternalModelSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String modelEndpoint;
        private String modelSource;

        private BuilderImpl() {
        }

        private BuilderImpl(ExternalModelSummary model) {
            this.modelEndpoint(model.modelEndpoint);
            this.modelSource(model.modelSource);
        }

        public final String getModelEndpoint() {
            return this.modelEndpoint;
        }

        public final void setModelEndpoint(String modelEndpoint) {
            this.modelEndpoint = modelEndpoint;
        }

        @Override
        public final Builder modelEndpoint(String modelEndpoint) {
            this.modelEndpoint = modelEndpoint;
            return this;
        }

        public final String getModelSource() {
            return this.modelSource;
        }

        public final void setModelSource(String modelSource) {
            this.modelSource = modelSource;
        }

        @Override
        public final Builder modelSource(String modelSource) {
            this.modelSource = modelSource;
            return this;
        }

        @Override
        public final Builder modelSource(ModelSource modelSource) {
            this.modelSource(modelSource == null ? null : modelSource.toString());
            return this;
        }

        public ExternalModelSummary build() {
            return new ExternalModelSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExternalModelSummary> {
        public Builder modelEndpoint(String var1);

        public Builder modelSource(String var1);

        public Builder modelSource(ModelSource var1);
    }
}

