/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ModelInputDataFormat {
    TEXT_CSV("TEXT_CSV"),
    APPLICATION_JSON("APPLICATION_JSON"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ModelInputDataFormat(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ModelInputDataFormat fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ModelInputDataFormat.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ModelInputDataFormat> knownValues() {
        return Stream.of(ModelInputDataFormat.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

