/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.frauddetector.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A rule.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Rule implements SdkPojo, Serializable, ToCopyableBuilder<Rule.Builder, Rule> {
    private static final SdkField<String> DETECTOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("detectorId").getter(getter(Rule::detectorId)).setter(setter(Builder::detectorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorId").build()).build();

    private static final SdkField<String> RULE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("ruleId")
            .getter(getter(Rule::ruleId)).setter(setter(Builder::ruleId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ruleId").build()).build();

    private static final SdkField<String> RULE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ruleVersion").getter(getter(Rule::ruleVersion)).setter(setter(Builder::ruleVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ruleVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETECTOR_ID_FIELD,
            RULE_ID_FIELD, RULE_VERSION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String detectorId;

    private final String ruleId;

    private final String ruleVersion;

    private Rule(BuilderImpl builder) {
        this.detectorId = builder.detectorId;
        this.ruleId = builder.ruleId;
        this.ruleVersion = builder.ruleVersion;
    }

    /**
     * <p>
     * The detector for which the rule is associated.
     * </p>
     * 
     * @return The detector for which the rule is associated.
     */
    public final String detectorId() {
        return detectorId;
    }

    /**
     * <p>
     * The rule ID.
     * </p>
     * 
     * @return The rule ID.
     */
    public final String ruleId() {
        return ruleId;
    }

    /**
     * <p>
     * The rule version.
     * </p>
     * 
     * @return The rule version.
     */
    public final String ruleVersion() {
        return ruleVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(detectorId());
        hashCode = 31 * hashCode + Objects.hashCode(ruleId());
        hashCode = 31 * hashCode + Objects.hashCode(ruleVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Rule)) {
            return false;
        }
        Rule other = (Rule) obj;
        return Objects.equals(detectorId(), other.detectorId()) && Objects.equals(ruleId(), other.ruleId())
                && Objects.equals(ruleVersion(), other.ruleVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Rule").add("DetectorId", detectorId()).add("RuleId", ruleId()).add("RuleVersion", ruleVersion())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "detectorId":
            return Optional.ofNullable(clazz.cast(detectorId()));
        case "ruleId":
            return Optional.ofNullable(clazz.cast(ruleId()));
        case "ruleVersion":
            return Optional.ofNullable(clazz.cast(ruleVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Rule, T> g) {
        return obj -> g.apply((Rule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Rule> {
        /**
         * <p>
         * The detector for which the rule is associated.
         * </p>
         * 
         * @param detectorId
         *        The detector for which the rule is associated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectorId(String detectorId);

        /**
         * <p>
         * The rule ID.
         * </p>
         * 
         * @param ruleId
         *        The rule ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleId(String ruleId);

        /**
         * <p>
         * The rule version.
         * </p>
         * 
         * @param ruleVersion
         *        The rule version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleVersion(String ruleVersion);
    }

    static final class BuilderImpl implements Builder {
        private String detectorId;

        private String ruleId;

        private String ruleVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(Rule model) {
            detectorId(model.detectorId);
            ruleId(model.ruleId);
            ruleVersion(model.ruleVersion);
        }

        public final String getDetectorId() {
            return detectorId;
        }

        @Override
        public final Builder detectorId(String detectorId) {
            this.detectorId = detectorId;
            return this;
        }

        public final void setDetectorId(String detectorId) {
            this.detectorId = detectorId;
        }

        public final String getRuleId() {
            return ruleId;
        }

        @Override
        public final Builder ruleId(String ruleId) {
            this.ruleId = ruleId;
            return this;
        }

        public final void setRuleId(String ruleId) {
            this.ruleId = ruleId;
        }

        public final String getRuleVersion() {
            return ruleVersion;
        }

        @Override
        public final Builder ruleVersion(String ruleVersion) {
            this.ruleVersion = ruleVersion;
            return this;
        }

        public final void setRuleVersion(String ruleVersion) {
            this.ruleVersion = ruleVersion;
        }

        @Override
        public Rule build() {
            return new Rule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
