/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.frauddetector.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The label schema.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LabelSchema implements SdkPojo, Serializable, ToCopyableBuilder<LabelSchema.Builder, LabelSchema> {
    private static final SdkField<Map<String, List<String>>> LABEL_MAPPER_FIELD = SdkField
            .<Map<String, List<String>>> builder(MarshallingType.MAP)
            .memberName("labelMapper")
            .getter(getter(LabelSchema::labelMapper))
            .setter(setter(Builder::labelMapper))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("labelMapper").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<List<String>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LABEL_MAPPER_FIELD));

    private static final long serialVersionUID = 1L;

    private final Map<String, List<String>> labelMapper;

    private LabelSchema(BuilderImpl builder) {
        this.labelMapper = builder.labelMapper;
    }

    /**
     * Returns true if the LabelMapper property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasLabelMapper() {
        return labelMapper != null && !(labelMapper instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The label mapper maps the Amazon Fraud Detector supported model classification labels (<code>FRAUD</code>,
     * <code>LEGIT</code>) to the appropriate event type labels. For example, if "<code>FRAUD</code>" and "
     * <code>LEGIT</code>" are Amazon Fraud Detector supported labels, this mapper could be:
     * <code>{"FRAUD" =&gt; ["0"]</code>, <code>"LEGIT" =&gt; ["1"]}</code> or <code>{"FRAUD" =&gt; ["false"]</code>,
     * <code>"LEGIT" =&gt; ["true"]}</code> or <code>{"FRAUD" =&gt; ["fraud", "abuse"]</code>,
     * <code>"LEGIT" =&gt; ["legit", "safe"]}</code>. The value part of the mapper is a list, because you may have
     * multiple label variants from your event type for a single Amazon Fraud Detector label.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasLabelMapper()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The label mapper maps the Amazon Fraud Detector supported model classification labels (<code>FRAUD</code>
     *         , <code>LEGIT</code>) to the appropriate event type labels. For example, if "<code>FRAUD</code>" and "
     *         <code>LEGIT</code>" are Amazon Fraud Detector supported labels, this mapper could be:
     *         <code>{"FRAUD" =&gt; ["0"]</code>, <code>"LEGIT" =&gt; ["1"]}</code> or
     *         <code>{"FRAUD" =&gt; ["false"]</code>, <code>"LEGIT" =&gt; ["true"]}</code> or
     *         <code>{"FRAUD" =&gt; ["fraud", "abuse"]</code>, <code>"LEGIT" =&gt; ["legit", "safe"]}</code>. The value
     *         part of the mapper is a list, because you may have multiple label variants from your event type for a
     *         single Amazon Fraud Detector label.
     */
    public final Map<String, List<String>> labelMapper() {
        return labelMapper;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasLabelMapper() ? labelMapper() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LabelSchema)) {
            return false;
        }
        LabelSchema other = (LabelSchema) obj;
        return hasLabelMapper() == other.hasLabelMapper() && Objects.equals(labelMapper(), other.labelMapper());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LabelSchema").add("LabelMapper", hasLabelMapper() ? labelMapper() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "labelMapper":
            return Optional.ofNullable(clazz.cast(labelMapper()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LabelSchema, T> g) {
        return obj -> g.apply((LabelSchema) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LabelSchema> {
        /**
         * <p>
         * The label mapper maps the Amazon Fraud Detector supported model classification labels (<code>FRAUD</code>,
         * <code>LEGIT</code>) to the appropriate event type labels. For example, if "<code>FRAUD</code>" and "
         * <code>LEGIT</code>" are Amazon Fraud Detector supported labels, this mapper could be:
         * <code>{"FRAUD" =&gt; ["0"]</code>, <code>"LEGIT" =&gt; ["1"]}</code> or <code>{"FRAUD" =&gt; ["false"]</code>, <code>"LEGIT" =&gt; ["true"]}</code> or <code>{"FRAUD" =&gt; ["fraud", "abuse"]</code>,
         * <code>"LEGIT" =&gt; ["legit", "safe"]}</code>. The value part of the mapper is a list, because you may have
         * multiple label variants from your event type for a single Amazon Fraud Detector label.
         * </p>
         * 
         * @param labelMapper
         *        The label mapper maps the Amazon Fraud Detector supported model classification labels (
         *        <code>FRAUD</code>, <code>LEGIT</code>) to the appropriate event type labels. For example, if "
         *        <code>FRAUD</code>" and "<code>LEGIT</code>" are Amazon Fraud Detector supported labels, this mapper
         *        could be: <code>{"FRAUD" =&gt; ["0"]</code>, <code>"LEGIT" =&gt; ["1"]}</code> or
         *        <code>{"FRAUD" =&gt; ["false"]</code>, <code>"LEGIT" =&gt; ["true"]}</code> or
         *        <code>{"FRAUD" =&gt; ["fraud", "abuse"]</code>, <code>"LEGIT" =&gt; ["legit", "safe"]}</code>. The
         *        value part of the mapper is a list, because you may have multiple label variants from your event type
         *        for a single Amazon Fraud Detector label.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labelMapper(Map<String, ? extends Collection<String>> labelMapper);
    }

    static final class BuilderImpl implements Builder {
        private Map<String, List<String>> labelMapper = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LabelSchema model) {
            labelMapper(model.labelMapper);
        }

        public final Map<String, ? extends Collection<String>> getLabelMapper() {
            if (labelMapper instanceof SdkAutoConstructMap) {
                return null;
            }
            return labelMapper;
        }

        @Override
        public final Builder labelMapper(Map<String, ? extends Collection<String>> labelMapper) {
            this.labelMapper = _labelMapperCopier.copy(labelMapper);
            return this;
        }

        public final void setLabelMapper(Map<String, ? extends Collection<String>> labelMapper) {
            this.labelMapper = _labelMapperCopier.copy(labelMapper);
        }

        @Override
        public LabelSchema build() {
            return new LabelSchema(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
