/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.frauddetector.model.ExternalEventsDetail;
import software.amazon.awssdk.services.frauddetector.model.FraudDetectorResponse;
import software.amazon.awssdk.services.frauddetector.model.ModelTypeEnum;
import software.amazon.awssdk.services.frauddetector.model.TrainingDataSchema;
import software.amazon.awssdk.services.frauddetector.model.TrainingDataSourceEnum;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetModelVersionResponse
extends FraudDetectorResponse
implements ToCopyableBuilder<Builder, GetModelVersionResponse> {
    private static final SdkField<String> MODEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetModelVersionResponse.getter(GetModelVersionResponse::modelId)).setter(GetModelVersionResponse.setter(Builder::modelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelId").build()}).build();
    private static final SdkField<String> MODEL_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetModelVersionResponse.getter(GetModelVersionResponse::modelTypeAsString)).setter(GetModelVersionResponse.setter(Builder::modelType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelType").build()}).build();
    private static final SdkField<String> MODEL_VERSION_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetModelVersionResponse.getter(GetModelVersionResponse::modelVersionNumber)).setter(GetModelVersionResponse.setter(Builder::modelVersionNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelVersionNumber").build()}).build();
    private static final SdkField<String> TRAINING_DATA_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetModelVersionResponse.getter(GetModelVersionResponse::trainingDataSourceAsString)).setter(GetModelVersionResponse.setter(Builder::trainingDataSource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trainingDataSource").build()}).build();
    private static final SdkField<TrainingDataSchema> TRAINING_DATA_SCHEMA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(GetModelVersionResponse.getter(GetModelVersionResponse::trainingDataSchema)).setter(GetModelVersionResponse.setter(Builder::trainingDataSchema)).constructor(TrainingDataSchema::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trainingDataSchema").build()}).build();
    private static final SdkField<ExternalEventsDetail> EXTERNAL_EVENTS_DETAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(GetModelVersionResponse.getter(GetModelVersionResponse::externalEventsDetail)).setter(GetModelVersionResponse.setter(Builder::externalEventsDetail)).constructor(ExternalEventsDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalEventsDetail").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetModelVersionResponse.getter(GetModelVersionResponse::status)).setter(GetModelVersionResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetModelVersionResponse.getter(GetModelVersionResponse::arn)).setter(GetModelVersionResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_ID_FIELD, MODEL_TYPE_FIELD, MODEL_VERSION_NUMBER_FIELD, TRAINING_DATA_SOURCE_FIELD, TRAINING_DATA_SCHEMA_FIELD, EXTERNAL_EVENTS_DETAIL_FIELD, STATUS_FIELD, ARN_FIELD));
    private final String modelId;
    private final String modelType;
    private final String modelVersionNumber;
    private final String trainingDataSource;
    private final TrainingDataSchema trainingDataSchema;
    private final ExternalEventsDetail externalEventsDetail;
    private final String status;
    private final String arn;

    private GetModelVersionResponse(BuilderImpl builder) {
        super(builder);
        this.modelId = builder.modelId;
        this.modelType = builder.modelType;
        this.modelVersionNumber = builder.modelVersionNumber;
        this.trainingDataSource = builder.trainingDataSource;
        this.trainingDataSchema = builder.trainingDataSchema;
        this.externalEventsDetail = builder.externalEventsDetail;
        this.status = builder.status;
        this.arn = builder.arn;
    }

    public String modelId() {
        return this.modelId;
    }

    public ModelTypeEnum modelType() {
        return ModelTypeEnum.fromValue(this.modelType);
    }

    public String modelTypeAsString() {
        return this.modelType;
    }

    public String modelVersionNumber() {
        return this.modelVersionNumber;
    }

    public TrainingDataSourceEnum trainingDataSource() {
        return TrainingDataSourceEnum.fromValue(this.trainingDataSource);
    }

    public String trainingDataSourceAsString() {
        return this.trainingDataSource;
    }

    public TrainingDataSchema trainingDataSchema() {
        return this.trainingDataSchema;
    }

    public ExternalEventsDetail externalEventsDetail() {
        return this.externalEventsDetail;
    }

    public String status() {
        return this.status;
    }

    public String arn() {
        return this.arn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.modelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelVersionNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingDataSourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingDataSchema());
        hashCode = 31 * hashCode + Objects.hashCode(this.externalEventsDetail());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetModelVersionResponse)) {
            return false;
        }
        GetModelVersionResponse other = (GetModelVersionResponse)((Object)obj);
        return Objects.equals(this.modelId(), other.modelId()) && Objects.equals(this.modelTypeAsString(), other.modelTypeAsString()) && Objects.equals(this.modelVersionNumber(), other.modelVersionNumber()) && Objects.equals(this.trainingDataSourceAsString(), other.trainingDataSourceAsString()) && Objects.equals(this.trainingDataSchema(), other.trainingDataSchema()) && Objects.equals(this.externalEventsDetail(), other.externalEventsDetail()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.arn(), other.arn());
    }

    public String toString() {
        return ToString.builder((String)"GetModelVersionResponse").add("ModelId", (Object)this.modelId()).add("ModelType", (Object)this.modelTypeAsString()).add("ModelVersionNumber", (Object)this.modelVersionNumber()).add("TrainingDataSource", (Object)this.trainingDataSourceAsString()).add("TrainingDataSchema", (Object)this.trainingDataSchema()).add("ExternalEventsDetail", (Object)this.externalEventsDetail()).add("Status", (Object)this.status()).add("Arn", (Object)this.arn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "modelId": {
                return Optional.ofNullable(clazz.cast(this.modelId()));
            }
            case "modelType": {
                return Optional.ofNullable(clazz.cast(this.modelTypeAsString()));
            }
            case "modelVersionNumber": {
                return Optional.ofNullable(clazz.cast(this.modelVersionNumber()));
            }
            case "trainingDataSource": {
                return Optional.ofNullable(clazz.cast(this.trainingDataSourceAsString()));
            }
            case "trainingDataSchema": {
                return Optional.ofNullable(clazz.cast(this.trainingDataSchema()));
            }
            case "externalEventsDetail": {
                return Optional.ofNullable(clazz.cast(this.externalEventsDetail()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetModelVersionResponse, T> g) {
        return obj -> g.apply((GetModelVersionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FraudDetectorResponse.BuilderImpl
    implements Builder {
        private String modelId;
        private String modelType;
        private String modelVersionNumber;
        private String trainingDataSource;
        private TrainingDataSchema trainingDataSchema;
        private ExternalEventsDetail externalEventsDetail;
        private String status;
        private String arn;

        private BuilderImpl() {
        }

        private BuilderImpl(GetModelVersionResponse model) {
            super(model);
            this.modelId(model.modelId);
            this.modelType(model.modelType);
            this.modelVersionNumber(model.modelVersionNumber);
            this.trainingDataSource(model.trainingDataSource);
            this.trainingDataSchema(model.trainingDataSchema);
            this.externalEventsDetail(model.externalEventsDetail);
            this.status(model.status);
            this.arn(model.arn);
        }

        public final String getModelId() {
            return this.modelId;
        }

        @Override
        public final Builder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        public final void setModelId(String modelId) {
            this.modelId = modelId;
        }

        public final String getModelType() {
            return this.modelType;
        }

        @Override
        public final Builder modelType(String modelType) {
            this.modelType = modelType;
            return this;
        }

        @Override
        public final Builder modelType(ModelTypeEnum modelType) {
            this.modelType(modelType == null ? null : modelType.toString());
            return this;
        }

        public final void setModelType(String modelType) {
            this.modelType = modelType;
        }

        public final String getModelVersionNumber() {
            return this.modelVersionNumber;
        }

        @Override
        public final Builder modelVersionNumber(String modelVersionNumber) {
            this.modelVersionNumber = modelVersionNumber;
            return this;
        }

        public final void setModelVersionNumber(String modelVersionNumber) {
            this.modelVersionNumber = modelVersionNumber;
        }

        public final String getTrainingDataSource() {
            return this.trainingDataSource;
        }

        @Override
        public final Builder trainingDataSource(String trainingDataSource) {
            this.trainingDataSource = trainingDataSource;
            return this;
        }

        @Override
        public final Builder trainingDataSource(TrainingDataSourceEnum trainingDataSource) {
            this.trainingDataSource(trainingDataSource == null ? null : trainingDataSource.toString());
            return this;
        }

        public final void setTrainingDataSource(String trainingDataSource) {
            this.trainingDataSource = trainingDataSource;
        }

        public final TrainingDataSchema.Builder getTrainingDataSchema() {
            return this.trainingDataSchema != null ? this.trainingDataSchema.toBuilder() : null;
        }

        @Override
        public final Builder trainingDataSchema(TrainingDataSchema trainingDataSchema) {
            this.trainingDataSchema = trainingDataSchema;
            return this;
        }

        public final void setTrainingDataSchema(TrainingDataSchema.BuilderImpl trainingDataSchema) {
            this.trainingDataSchema = trainingDataSchema != null ? trainingDataSchema.build() : null;
        }

        public final ExternalEventsDetail.Builder getExternalEventsDetail() {
            return this.externalEventsDetail != null ? this.externalEventsDetail.toBuilder() : null;
        }

        @Override
        public final Builder externalEventsDetail(ExternalEventsDetail externalEventsDetail) {
            this.externalEventsDetail = externalEventsDetail;
            return this;
        }

        public final void setExternalEventsDetail(ExternalEventsDetail.BuilderImpl externalEventsDetail) {
            this.externalEventsDetail = externalEventsDetail != null ? externalEventsDetail.build() : null;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public GetModelVersionResponse build() {
            return new GetModelVersionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends FraudDetectorResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetModelVersionResponse> {
        public Builder modelId(String var1);

        public Builder modelType(String var1);

        public Builder modelType(ModelTypeEnum var1);

        public Builder modelVersionNumber(String var1);

        public Builder trainingDataSource(String var1);

        public Builder trainingDataSource(TrainingDataSourceEnum var1);

        public Builder trainingDataSchema(TrainingDataSchema var1);

        default public Builder trainingDataSchema(Consumer<TrainingDataSchema.Builder> trainingDataSchema) {
            return this.trainingDataSchema((TrainingDataSchema)((TrainingDataSchema.Builder)TrainingDataSchema.builder().applyMutation(trainingDataSchema)).build());
        }

        public Builder externalEventsDetail(ExternalEventsDetail var1);

        default public Builder externalEventsDetail(Consumer<ExternalEventsDetail.Builder> externalEventsDetail) {
            return this.externalEventsDetail((ExternalEventsDetail)((ExternalEventsDetail.Builder)ExternalEventsDetail.builder().applyMutation(externalEventsDetail)).build());
        }

        public Builder status(String var1);

        public Builder arn(String var1);
    }
}

