/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.forecastquery.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class QueryForecastRequest extends ForecastqueryRequest implements
        ToCopyableBuilder<QueryForecastRequest.Builder, QueryForecastRequest> {
    private static final SdkField<String> FORECAST_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(QueryForecastRequest::forecastArn)).setter(setter(Builder::forecastArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForecastArn").build()).build();

    private static final SdkField<String> START_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(QueryForecastRequest::startDate)).setter(setter(Builder::startDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartDate").build()).build();

    private static final SdkField<String> END_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(QueryForecastRequest::endDate)).setter(setter(Builder::endDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndDate").build()).build();

    private static final SdkField<Map<String, String>> FILTERS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(QueryForecastRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(QueryForecastRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FORECAST_ARN_FIELD,
            START_DATE_FIELD, END_DATE_FIELD, FILTERS_FIELD, NEXT_TOKEN_FIELD));

    private final String forecastArn;

    private final String startDate;

    private final String endDate;

    private final Map<String, String> filters;

    private final String nextToken;

    private QueryForecastRequest(BuilderImpl builder) {
        super(builder);
        this.forecastArn = builder.forecastArn;
        this.startDate = builder.startDate;
        this.endDate = builder.endDate;
        this.filters = builder.filters;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the forecast to query.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the forecast to query.
     */
    public String forecastArn() {
        return forecastArn;
    }

    /**
     * <p>
     * The start date for the forecast. Specify the date using this format: yyyy-MM-dd'T'HH:mm:ss (ISO 8601 format). For
     * example, 2015-01-01T08:00:00.
     * </p>
     * 
     * @return The start date for the forecast. Specify the date using this format: yyyy-MM-dd'T'HH:mm:ss (ISO 8601
     *         format). For example, 2015-01-01T08:00:00.
     */
    public String startDate() {
        return startDate;
    }

    /**
     * <p>
     * The end date for the forecast. Specify the date using this format: yyyy-MM-dd'T'HH:mm:ss (ISO 8601 format). For
     * example, 2015-01-01T20:00:00.
     * </p>
     * 
     * @return The end date for the forecast. Specify the date using this format: yyyy-MM-dd'T'HH:mm:ss (ISO 8601
     *         format). For example, 2015-01-01T20:00:00.
     */
    public String endDate() {
        return endDate;
    }

    /**
     * Returns true if the Filters property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The filtering criteria to apply when retrieving the forecast. For example, to get the forecast for
     * <code>client_21</code> in the electricity usage dataset, specify the following:
     * </p>
     * <p>
     * <code>{"item_id" : "client_21"}</code>
     * </p>
     * <p>
     * To get the full forecast, use the <a
     * href="https://docs.aws.amazon.com/en_us/forecast/latest/dg/API_CreateForecastExportJob.html"
     * >CreateForecastExportJob</a> operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFilters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The filtering criteria to apply when retrieving the forecast. For example, to get the forecast for
     *         <code>client_21</code> in the electricity usage dataset, specify the following:</p>
     *         <p>
     *         <code>{"item_id" : "client_21"}</code>
     *         </p>
     *         <p>
     *         To get the full forecast, use the <a
     *         href="https://docs.aws.amazon.com/en_us/forecast/latest/dg/API_CreateForecastExportJob.html"
     *         >CreateForecastExportJob</a> operation.
     */
    public Map<String, String> filters() {
        return filters;
    }

    /**
     * <p>
     * If the result of the previous request was truncated, the response includes a <code>NextToken</code>. To retrieve
     * the next set of results, use the token in the next request. Tokens expire after 24 hours.
     * </p>
     * 
     * @return If the result of the previous request was truncated, the response includes a <code>NextToken</code>. To
     *         retrieve the next set of results, use the token in the next request. Tokens expire after 24 hours.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(forecastArn());
        hashCode = 31 * hashCode + Objects.hashCode(startDate());
        hashCode = 31 * hashCode + Objects.hashCode(endDate());
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryForecastRequest)) {
            return false;
        }
        QueryForecastRequest other = (QueryForecastRequest) obj;
        return Objects.equals(forecastArn(), other.forecastArn()) && Objects.equals(startDate(), other.startDate())
                && Objects.equals(endDate(), other.endDate()) && Objects.equals(filters(), other.filters())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("QueryForecastRequest").add("ForecastArn", forecastArn()).add("StartDate", startDate())
                .add("EndDate", endDate()).add("Filters", filters()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ForecastArn":
            return Optional.ofNullable(clazz.cast(forecastArn()));
        case "StartDate":
            return Optional.ofNullable(clazz.cast(startDate()));
        case "EndDate":
            return Optional.ofNullable(clazz.cast(endDate()));
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<QueryForecastRequest, T> g) {
        return obj -> g.apply((QueryForecastRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ForecastqueryRequest.Builder, SdkPojo, CopyableBuilder<Builder, QueryForecastRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the forecast to query.
         * </p>
         * 
         * @param forecastArn
         *        The Amazon Resource Name (ARN) of the forecast to query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forecastArn(String forecastArn);

        /**
         * <p>
         * The start date for the forecast. Specify the date using this format: yyyy-MM-dd'T'HH:mm:ss (ISO 8601 format).
         * For example, 2015-01-01T08:00:00.
         * </p>
         * 
         * @param startDate
         *        The start date for the forecast. Specify the date using this format: yyyy-MM-dd'T'HH:mm:ss (ISO 8601
         *        format). For example, 2015-01-01T08:00:00.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startDate(String startDate);

        /**
         * <p>
         * The end date for the forecast. Specify the date using this format: yyyy-MM-dd'T'HH:mm:ss (ISO 8601 format).
         * For example, 2015-01-01T20:00:00.
         * </p>
         * 
         * @param endDate
         *        The end date for the forecast. Specify the date using this format: yyyy-MM-dd'T'HH:mm:ss (ISO 8601
         *        format). For example, 2015-01-01T20:00:00.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endDate(String endDate);

        /**
         * <p>
         * The filtering criteria to apply when retrieving the forecast. For example, to get the forecast for
         * <code>client_21</code> in the electricity usage dataset, specify the following:
         * </p>
         * <p>
         * <code>{"item_id" : "client_21"}</code>
         * </p>
         * <p>
         * To get the full forecast, use the <a
         * href="https://docs.aws.amazon.com/en_us/forecast/latest/dg/API_CreateForecastExportJob.html"
         * >CreateForecastExportJob</a> operation.
         * </p>
         * 
         * @param filters
         *        The filtering criteria to apply when retrieving the forecast. For example, to get the forecast for
         *        <code>client_21</code> in the electricity usage dataset, specify the following:</p>
         *        <p>
         *        <code>{"item_id" : "client_21"}</code>
         *        </p>
         *        <p>
         *        To get the full forecast, use the <a
         *        href="https://docs.aws.amazon.com/en_us/forecast/latest/dg/API_CreateForecastExportJob.html"
         *        >CreateForecastExportJob</a> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Map<String, String> filters);

        /**
         * <p>
         * If the result of the previous request was truncated, the response includes a <code>NextToken</code>. To
         * retrieve the next set of results, use the token in the next request. Tokens expire after 24 hours.
         * </p>
         * 
         * @param nextToken
         *        If the result of the previous request was truncated, the response includes a <code>NextToken</code>.
         *        To retrieve the next set of results, use the token in the next request. Tokens expire after 24 hours.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ForecastqueryRequest.BuilderImpl implements Builder {
        private String forecastArn;

        private String startDate;

        private String endDate;

        private Map<String, String> filters = DefaultSdkAutoConstructMap.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(QueryForecastRequest model) {
            super(model);
            forecastArn(model.forecastArn);
            startDate(model.startDate);
            endDate(model.endDate);
            filters(model.filters);
            nextToken(model.nextToken);
        }

        public final String getForecastArn() {
            return forecastArn;
        }

        @Override
        public final Builder forecastArn(String forecastArn) {
            this.forecastArn = forecastArn;
            return this;
        }

        public final void setForecastArn(String forecastArn) {
            this.forecastArn = forecastArn;
        }

        public final String getStartDate() {
            return startDate;
        }

        @Override
        public final Builder startDate(String startDate) {
            this.startDate = startDate;
            return this;
        }

        public final void setStartDate(String startDate) {
            this.startDate = startDate;
        }

        public final String getEndDate() {
            return endDate;
        }

        @Override
        public final Builder endDate(String endDate) {
            this.endDate = endDate;
            return this;
        }

        public final void setEndDate(String endDate) {
            this.endDate = endDate;
        }

        public final Map<String, String> getFilters() {
            return filters;
        }

        @Override
        public final Builder filters(Map<String, String> filters) {
            this.filters = FiltersCopier.copy(filters);
            return this;
        }

        public final void setFilters(Map<String, String> filters) {
            this.filters = FiltersCopier.copy(filters);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public QueryForecastRequest build() {
            return new QueryForecastRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
