/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.forecast.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeWhatIfAnalysisResponse extends ForecastResponse implements
        ToCopyableBuilder<DescribeWhatIfAnalysisResponse.Builder, DescribeWhatIfAnalysisResponse> {
    private static final SdkField<String> WHAT_IF_ANALYSIS_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WhatIfAnalysisName").getter(getter(DescribeWhatIfAnalysisResponse::whatIfAnalysisName))
            .setter(setter(Builder::whatIfAnalysisName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WhatIfAnalysisName").build())
            .build();

    private static final SdkField<String> WHAT_IF_ANALYSIS_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WhatIfAnalysisArn").getter(getter(DescribeWhatIfAnalysisResponse::whatIfAnalysisArn))
            .setter(setter(Builder::whatIfAnalysisArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WhatIfAnalysisArn").build()).build();

    private static final SdkField<String> FORECAST_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ForecastArn").getter(getter(DescribeWhatIfAnalysisResponse::forecastArn))
            .setter(setter(Builder::forecastArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForecastArn").build()).build();

    private static final SdkField<Long> ESTIMATED_TIME_REMAINING_IN_MINUTES_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("EstimatedTimeRemainingInMinutes")
            .getter(getter(DescribeWhatIfAnalysisResponse::estimatedTimeRemainingInMinutes))
            .setter(setter(Builder::estimatedTimeRemainingInMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedTimeRemainingInMinutes")
                    .build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DescribeWhatIfAnalysisResponse::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Message")
            .getter(getter(DescribeWhatIfAnalysisResponse::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(DescribeWhatIfAnalysisResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFICATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModificationTime").getter(getter(DescribeWhatIfAnalysisResponse::lastModificationTime))
            .setter(setter(Builder::lastModificationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModificationTime").build())
            .build();

    private static final SdkField<TimeSeriesSelector> TIME_SERIES_SELECTOR_FIELD = SdkField
            .<TimeSeriesSelector> builder(MarshallingType.SDK_POJO).memberName("TimeSeriesSelector")
            .getter(getter(DescribeWhatIfAnalysisResponse::timeSeriesSelector)).setter(setter(Builder::timeSeriesSelector))
            .constructor(TimeSeriesSelector::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeSeriesSelector").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WHAT_IF_ANALYSIS_NAME_FIELD,
            WHAT_IF_ANALYSIS_ARN_FIELD, FORECAST_ARN_FIELD, ESTIMATED_TIME_REMAINING_IN_MINUTES_FIELD, STATUS_FIELD,
            MESSAGE_FIELD, CREATION_TIME_FIELD, LAST_MODIFICATION_TIME_FIELD, TIME_SERIES_SELECTOR_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String whatIfAnalysisName;

    private final String whatIfAnalysisArn;

    private final String forecastArn;

    private final Long estimatedTimeRemainingInMinutes;

    private final String status;

    private final String message;

    private final Instant creationTime;

    private final Instant lastModificationTime;

    private final TimeSeriesSelector timeSeriesSelector;

    private DescribeWhatIfAnalysisResponse(BuilderImpl builder) {
        super(builder);
        this.whatIfAnalysisName = builder.whatIfAnalysisName;
        this.whatIfAnalysisArn = builder.whatIfAnalysisArn;
        this.forecastArn = builder.forecastArn;
        this.estimatedTimeRemainingInMinutes = builder.estimatedTimeRemainingInMinutes;
        this.status = builder.status;
        this.message = builder.message;
        this.creationTime = builder.creationTime;
        this.lastModificationTime = builder.lastModificationTime;
        this.timeSeriesSelector = builder.timeSeriesSelector;
    }

    /**
     * <p>
     * The name of the what-if analysis.
     * </p>
     * 
     * @return The name of the what-if analysis.
     */
    public final String whatIfAnalysisName() {
        return whatIfAnalysisName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the what-if analysis.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the what-if analysis.
     */
    public final String whatIfAnalysisArn() {
        return whatIfAnalysisArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the what-if forecast.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the what-if forecast.
     */
    public final String forecastArn() {
        return forecastArn;
    }

    /**
     * <p>
     * The approximate time remaining to complete the what-if analysis, in minutes.
     * </p>
     * 
     * @return The approximate time remaining to complete the what-if analysis, in minutes.
     */
    public final Long estimatedTimeRemainingInMinutes() {
        return estimatedTimeRemainingInMinutes;
    }

    /**
     * <p>
     * The status of the what-if analysis. States include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ACTIVE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_STOPPING</code>, <code>CREATE_STOPPED</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code>
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * The <code>Status</code> of the what-if analysis must be <code>ACTIVE</code> before you can access the analysis.
     * </p>
     * </note>
     * 
     * @return The status of the what-if analysis. States include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE_STOPPING</code>, <code>CREATE_STOPPED</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         The <code>Status</code> of the what-if analysis must be <code>ACTIVE</code> before you can access the
     *         analysis.
     *         </p>
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * If an error occurred, an informational message about the error.
     * </p>
     * 
     * @return If an error occurred, an informational message about the error.
     */
    public final String message() {
        return message;
    }

    /**
     * <p>
     * When the what-if analysis was created.
     * </p>
     * 
     * @return When the what-if analysis was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The last time the resource was modified. The timestamp depends on the status of the job:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATE_PENDING</code> - The <code>CreationTime</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_IN_PROGRESS</code> - The current timestamp.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_STOPPING</code> - The current timestamp.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_STOPPED</code> - When the job stopped.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the job finished or failed.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The last time the resource was modified. The timestamp depends on the status of the job:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CREATE_PENDING</code> - The <code>CreationTime</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE_IN_PROGRESS</code> - The current timestamp.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE_STOPPING</code> - The current timestamp.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE_STOPPED</code> - When the job stopped.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the job finished or failed.
     *         </p>
     *         </li>
     */
    public final Instant lastModificationTime() {
        return lastModificationTime;
    }

    /**
     * Returns the value of the TimeSeriesSelector property for this object.
     * 
     * @return The value of the TimeSeriesSelector property for this object.
     */
    public final TimeSeriesSelector timeSeriesSelector() {
        return timeSeriesSelector;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(whatIfAnalysisName());
        hashCode = 31 * hashCode + Objects.hashCode(whatIfAnalysisArn());
        hashCode = 31 * hashCode + Objects.hashCode(forecastArn());
        hashCode = 31 * hashCode + Objects.hashCode(estimatedTimeRemainingInMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModificationTime());
        hashCode = 31 * hashCode + Objects.hashCode(timeSeriesSelector());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeWhatIfAnalysisResponse)) {
            return false;
        }
        DescribeWhatIfAnalysisResponse other = (DescribeWhatIfAnalysisResponse) obj;
        return Objects.equals(whatIfAnalysisName(), other.whatIfAnalysisName())
                && Objects.equals(whatIfAnalysisArn(), other.whatIfAnalysisArn())
                && Objects.equals(forecastArn(), other.forecastArn())
                && Objects.equals(estimatedTimeRemainingInMinutes(), other.estimatedTimeRemainingInMinutes())
                && Objects.equals(status(), other.status()) && Objects.equals(message(), other.message())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastModificationTime(), other.lastModificationTime())
                && Objects.equals(timeSeriesSelector(), other.timeSeriesSelector());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeWhatIfAnalysisResponse").add("WhatIfAnalysisName", whatIfAnalysisName())
                .add("WhatIfAnalysisArn", whatIfAnalysisArn()).add("ForecastArn", forecastArn())
                .add("EstimatedTimeRemainingInMinutes", estimatedTimeRemainingInMinutes()).add("Status", status())
                .add("Message", message()).add("CreationTime", creationTime())
                .add("LastModificationTime", lastModificationTime()).add("TimeSeriesSelector", timeSeriesSelector()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WhatIfAnalysisName":
            return Optional.ofNullable(clazz.cast(whatIfAnalysisName()));
        case "WhatIfAnalysisArn":
            return Optional.ofNullable(clazz.cast(whatIfAnalysisArn()));
        case "ForecastArn":
            return Optional.ofNullable(clazz.cast(forecastArn()));
        case "EstimatedTimeRemainingInMinutes":
            return Optional.ofNullable(clazz.cast(estimatedTimeRemainingInMinutes()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "Message":
            return Optional.ofNullable(clazz.cast(message()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "LastModificationTime":
            return Optional.ofNullable(clazz.cast(lastModificationTime()));
        case "TimeSeriesSelector":
            return Optional.ofNullable(clazz.cast(timeSeriesSelector()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("WhatIfAnalysisName", WHAT_IF_ANALYSIS_NAME_FIELD);
        map.put("WhatIfAnalysisArn", WHAT_IF_ANALYSIS_ARN_FIELD);
        map.put("ForecastArn", FORECAST_ARN_FIELD);
        map.put("EstimatedTimeRemainingInMinutes", ESTIMATED_TIME_REMAINING_IN_MINUTES_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Message", MESSAGE_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("LastModificationTime", LAST_MODIFICATION_TIME_FIELD);
        map.put("TimeSeriesSelector", TIME_SERIES_SELECTOR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeWhatIfAnalysisResponse, T> g) {
        return obj -> g.apply((DescribeWhatIfAnalysisResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ForecastResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeWhatIfAnalysisResponse> {
        /**
         * <p>
         * The name of the what-if analysis.
         * </p>
         * 
         * @param whatIfAnalysisName
         *        The name of the what-if analysis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder whatIfAnalysisName(String whatIfAnalysisName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the what-if analysis.
         * </p>
         * 
         * @param whatIfAnalysisArn
         *        The Amazon Resource Name (ARN) of the what-if analysis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder whatIfAnalysisArn(String whatIfAnalysisArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the what-if forecast.
         * </p>
         * 
         * @param forecastArn
         *        The Amazon Resource Name (ARN) of the what-if forecast.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forecastArn(String forecastArn);

        /**
         * <p>
         * The approximate time remaining to complete the what-if analysis, in minutes.
         * </p>
         * 
         * @param estimatedTimeRemainingInMinutes
         *        The approximate time remaining to complete the what-if analysis, in minutes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedTimeRemainingInMinutes(Long estimatedTimeRemainingInMinutes);

        /**
         * <p>
         * The status of the what-if analysis. States include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ACTIVE</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATE_STOPPING</code>, <code>CREATE_STOPPED</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code>
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * The <code>Status</code> of the what-if analysis must be <code>ACTIVE</code> before you can access the
         * analysis.
         * </p>
         * </note>
         * 
         * @param status
         *        The status of the what-if analysis. States include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATE_STOPPING</code>, <code>CREATE_STOPPED</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        The <code>Status</code> of the what-if analysis must be <code>ACTIVE</code> before you can access the
         *        analysis.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * If an error occurred, an informational message about the error.
         * </p>
         * 
         * @param message
         *        If an error occurred, an informational message about the error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * When the what-if analysis was created.
         * </p>
         * 
         * @param creationTime
         *        When the what-if analysis was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The last time the resource was modified. The timestamp depends on the status of the job:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CREATE_PENDING</code> - The <code>CreationTime</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATE_IN_PROGRESS</code> - The current timestamp.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATE_STOPPING</code> - The current timestamp.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATE_STOPPED</code> - When the job stopped.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the job finished or failed.
         * </p>
         * </li>
         * </ul>
         * 
         * @param lastModificationTime
         *        The last time the resource was modified. The timestamp depends on the status of the job:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CREATE_PENDING</code> - The <code>CreationTime</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATE_IN_PROGRESS</code> - The current timestamp.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATE_STOPPING</code> - The current timestamp.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATE_STOPPED</code> - When the job stopped.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the job finished or failed.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModificationTime(Instant lastModificationTime);

        /**
         * Sets the value of the TimeSeriesSelector property for this object.
         *
         * @param timeSeriesSelector
         *        The new value for the TimeSeriesSelector property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeSeriesSelector(TimeSeriesSelector timeSeriesSelector);

        /**
         * Sets the value of the TimeSeriesSelector property for this object.
         *
         * This is a convenience method that creates an instance of the {@link TimeSeriesSelector.Builder} avoiding the
         * need to create one manually via {@link TimeSeriesSelector#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TimeSeriesSelector.Builder#build()} is called immediately and its
         * result is passed to {@link #timeSeriesSelector(TimeSeriesSelector)}.
         * 
         * @param timeSeriesSelector
         *        a consumer that will call methods on {@link TimeSeriesSelector.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timeSeriesSelector(TimeSeriesSelector)
         */
        default Builder timeSeriesSelector(Consumer<TimeSeriesSelector.Builder> timeSeriesSelector) {
            return timeSeriesSelector(TimeSeriesSelector.builder().applyMutation(timeSeriesSelector).build());
        }
    }

    static final class BuilderImpl extends ForecastResponse.BuilderImpl implements Builder {
        private String whatIfAnalysisName;

        private String whatIfAnalysisArn;

        private String forecastArn;

        private Long estimatedTimeRemainingInMinutes;

        private String status;

        private String message;

        private Instant creationTime;

        private Instant lastModificationTime;

        private TimeSeriesSelector timeSeriesSelector;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeWhatIfAnalysisResponse model) {
            super(model);
            whatIfAnalysisName(model.whatIfAnalysisName);
            whatIfAnalysisArn(model.whatIfAnalysisArn);
            forecastArn(model.forecastArn);
            estimatedTimeRemainingInMinutes(model.estimatedTimeRemainingInMinutes);
            status(model.status);
            message(model.message);
            creationTime(model.creationTime);
            lastModificationTime(model.lastModificationTime);
            timeSeriesSelector(model.timeSeriesSelector);
        }

        public final String getWhatIfAnalysisName() {
            return whatIfAnalysisName;
        }

        public final void setWhatIfAnalysisName(String whatIfAnalysisName) {
            this.whatIfAnalysisName = whatIfAnalysisName;
        }

        @Override
        public final Builder whatIfAnalysisName(String whatIfAnalysisName) {
            this.whatIfAnalysisName = whatIfAnalysisName;
            return this;
        }

        public final String getWhatIfAnalysisArn() {
            return whatIfAnalysisArn;
        }

        public final void setWhatIfAnalysisArn(String whatIfAnalysisArn) {
            this.whatIfAnalysisArn = whatIfAnalysisArn;
        }

        @Override
        public final Builder whatIfAnalysisArn(String whatIfAnalysisArn) {
            this.whatIfAnalysisArn = whatIfAnalysisArn;
            return this;
        }

        public final String getForecastArn() {
            return forecastArn;
        }

        public final void setForecastArn(String forecastArn) {
            this.forecastArn = forecastArn;
        }

        @Override
        public final Builder forecastArn(String forecastArn) {
            this.forecastArn = forecastArn;
            return this;
        }

        public final Long getEstimatedTimeRemainingInMinutes() {
            return estimatedTimeRemainingInMinutes;
        }

        public final void setEstimatedTimeRemainingInMinutes(Long estimatedTimeRemainingInMinutes) {
            this.estimatedTimeRemainingInMinutes = estimatedTimeRemainingInMinutes;
        }

        @Override
        public final Builder estimatedTimeRemainingInMinutes(Long estimatedTimeRemainingInMinutes) {
            this.estimatedTimeRemainingInMinutes = estimatedTimeRemainingInMinutes;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModificationTime() {
            return lastModificationTime;
        }

        public final void setLastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
        }

        @Override
        public final Builder lastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
            return this;
        }

        public final TimeSeriesSelector.Builder getTimeSeriesSelector() {
            return timeSeriesSelector != null ? timeSeriesSelector.toBuilder() : null;
        }

        public final void setTimeSeriesSelector(TimeSeriesSelector.BuilderImpl timeSeriesSelector) {
            this.timeSeriesSelector = timeSeriesSelector != null ? timeSeriesSelector.build() : null;
        }

        @Override
        public final Builder timeSeriesSelector(TimeSeriesSelector timeSeriesSelector) {
            this.timeSeriesSelector = timeSeriesSelector;
            return this;
        }

        @Override
        public DescribeWhatIfAnalysisResponse build() {
            return new DescribeWhatIfAnalysisResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
