/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.forecast.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateWhatIfAnalysisRequest extends ForecastRequest implements
        ToCopyableBuilder<CreateWhatIfAnalysisRequest.Builder, CreateWhatIfAnalysisRequest> {
    private static final SdkField<String> WHAT_IF_ANALYSIS_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WhatIfAnalysisName").getter(getter(CreateWhatIfAnalysisRequest::whatIfAnalysisName))
            .setter(setter(Builder::whatIfAnalysisName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WhatIfAnalysisName").build())
            .build();

    private static final SdkField<String> FORECAST_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ForecastArn").getter(getter(CreateWhatIfAnalysisRequest::forecastArn))
            .setter(setter(Builder::forecastArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForecastArn").build()).build();

    private static final SdkField<TimeSeriesSelector> TIME_SERIES_SELECTOR_FIELD = SdkField
            .<TimeSeriesSelector> builder(MarshallingType.SDK_POJO).memberName("TimeSeriesSelector")
            .getter(getter(CreateWhatIfAnalysisRequest::timeSeriesSelector)).setter(setter(Builder::timeSeriesSelector))
            .constructor(TimeSeriesSelector::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeSeriesSelector").build())
            .build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateWhatIfAnalysisRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WHAT_IF_ANALYSIS_NAME_FIELD,
            FORECAST_ARN_FIELD, TIME_SERIES_SELECTOR_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String whatIfAnalysisName;

    private final String forecastArn;

    private final TimeSeriesSelector timeSeriesSelector;

    private final List<Tag> tags;

    private CreateWhatIfAnalysisRequest(BuilderImpl builder) {
        super(builder);
        this.whatIfAnalysisName = builder.whatIfAnalysisName;
        this.forecastArn = builder.forecastArn;
        this.timeSeriesSelector = builder.timeSeriesSelector;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the what-if analysis. Each name must be unique.
     * </p>
     * 
     * @return The name of the what-if analysis. Each name must be unique.
     */
    public final String whatIfAnalysisName() {
        return whatIfAnalysisName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the baseline forecast.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the baseline forecast.
     */
    public final String forecastArn() {
        return forecastArn;
    }

    /**
     * <p>
     * Defines the set of time series that are used in the what-if analysis with a <code>TimeSeriesIdentifiers</code>
     * object. What-if analyses are performed only for the time series in this object.
     * </p>
     * <p>
     * The <code>TimeSeriesIdentifiers</code> object needs the following information:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>DataSource</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Format</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Schema</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return Defines the set of time series that are used in the what-if analysis with a
     *         <code>TimeSeriesIdentifiers</code> object. What-if analyses are performed only for the time series in
     *         this object.</p>
     *         <p>
     *         The <code>TimeSeriesIdentifiers</code> object needs the following information:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>DataSource</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Format</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Schema</code>
     *         </p>
     *         </li>
     */
    public final TimeSeriesSelector timeSeriesSelector() {
        return timeSeriesSelector;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <a href="https://docs.aws.amazon.com/forecast/latest/dg/tagging-forecast-resources.html">tags</a> to
     * apply to the what if forecast.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of <a
     *         href="https://docs.aws.amazon.com/forecast/latest/dg/tagging-forecast-resources.html">tags</a> to apply
     *         to the what if forecast.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(whatIfAnalysisName());
        hashCode = 31 * hashCode + Objects.hashCode(forecastArn());
        hashCode = 31 * hashCode + Objects.hashCode(timeSeriesSelector());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateWhatIfAnalysisRequest)) {
            return false;
        }
        CreateWhatIfAnalysisRequest other = (CreateWhatIfAnalysisRequest) obj;
        return Objects.equals(whatIfAnalysisName(), other.whatIfAnalysisName())
                && Objects.equals(forecastArn(), other.forecastArn())
                && Objects.equals(timeSeriesSelector(), other.timeSeriesSelector()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateWhatIfAnalysisRequest").add("WhatIfAnalysisName", whatIfAnalysisName())
                .add("ForecastArn", forecastArn()).add("TimeSeriesSelector", timeSeriesSelector())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WhatIfAnalysisName":
            return Optional.ofNullable(clazz.cast(whatIfAnalysisName()));
        case "ForecastArn":
            return Optional.ofNullable(clazz.cast(forecastArn()));
        case "TimeSeriesSelector":
            return Optional.ofNullable(clazz.cast(timeSeriesSelector()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("WhatIfAnalysisName", WHAT_IF_ANALYSIS_NAME_FIELD);
        map.put("ForecastArn", FORECAST_ARN_FIELD);
        map.put("TimeSeriesSelector", TIME_SERIES_SELECTOR_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateWhatIfAnalysisRequest, T> g) {
        return obj -> g.apply((CreateWhatIfAnalysisRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ForecastRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateWhatIfAnalysisRequest> {
        /**
         * <p>
         * The name of the what-if analysis. Each name must be unique.
         * </p>
         * 
         * @param whatIfAnalysisName
         *        The name of the what-if analysis. Each name must be unique.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder whatIfAnalysisName(String whatIfAnalysisName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the baseline forecast.
         * </p>
         * 
         * @param forecastArn
         *        The Amazon Resource Name (ARN) of the baseline forecast.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forecastArn(String forecastArn);

        /**
         * <p>
         * Defines the set of time series that are used in the what-if analysis with a
         * <code>TimeSeriesIdentifiers</code> object. What-if analyses are performed only for the time series in this
         * object.
         * </p>
         * <p>
         * The <code>TimeSeriesIdentifiers</code> object needs the following information:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>DataSource</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Format</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Schema</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param timeSeriesSelector
         *        Defines the set of time series that are used in the what-if analysis with a
         *        <code>TimeSeriesIdentifiers</code> object. What-if analyses are performed only for the time series in
         *        this object.</p>
         *        <p>
         *        The <code>TimeSeriesIdentifiers</code> object needs the following information:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>DataSource</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Format</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Schema</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeSeriesSelector(TimeSeriesSelector timeSeriesSelector);

        /**
         * <p>
         * Defines the set of time series that are used in the what-if analysis with a
         * <code>TimeSeriesIdentifiers</code> object. What-if analyses are performed only for the time series in this
         * object.
         * </p>
         * <p>
         * The <code>TimeSeriesIdentifiers</code> object needs the following information:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>DataSource</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Format</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Schema</code>
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the {@link TimeSeriesSelector.Builder} avoiding the
         * need to create one manually via {@link TimeSeriesSelector#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TimeSeriesSelector.Builder#build()} is called immediately and its
         * result is passed to {@link #timeSeriesSelector(TimeSeriesSelector)}.
         * 
         * @param timeSeriesSelector
         *        a consumer that will call methods on {@link TimeSeriesSelector.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timeSeriesSelector(TimeSeriesSelector)
         */
        default Builder timeSeriesSelector(Consumer<TimeSeriesSelector.Builder> timeSeriesSelector) {
            return timeSeriesSelector(TimeSeriesSelector.builder().applyMutation(timeSeriesSelector).build());
        }

        /**
         * <p>
         * A list of <a href="https://docs.aws.amazon.com/forecast/latest/dg/tagging-forecast-resources.html">tags</a>
         * to apply to the what if forecast.
         * </p>
         * 
         * @param tags
         *        A list of <a
         *        href="https://docs.aws.amazon.com/forecast/latest/dg/tagging-forecast-resources.html">tags</a> to
         *        apply to the what if forecast.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of <a href="https://docs.aws.amazon.com/forecast/latest/dg/tagging-forecast-resources.html">tags</a>
         * to apply to the what if forecast.
         * </p>
         * 
         * @param tags
         *        A list of <a
         *        href="https://docs.aws.amazon.com/forecast/latest/dg/tagging-forecast-resources.html">tags</a> to
         *        apply to the what if forecast.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of <a href="https://docs.aws.amazon.com/forecast/latest/dg/tagging-forecast-resources.html">tags</a>
         * to apply to the what if forecast.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.forecast.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.forecast.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.forecast.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.forecast.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ForecastRequest.BuilderImpl implements Builder {
        private String whatIfAnalysisName;

        private String forecastArn;

        private TimeSeriesSelector timeSeriesSelector;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateWhatIfAnalysisRequest model) {
            super(model);
            whatIfAnalysisName(model.whatIfAnalysisName);
            forecastArn(model.forecastArn);
            timeSeriesSelector(model.timeSeriesSelector);
            tags(model.tags);
        }

        public final String getWhatIfAnalysisName() {
            return whatIfAnalysisName;
        }

        public final void setWhatIfAnalysisName(String whatIfAnalysisName) {
            this.whatIfAnalysisName = whatIfAnalysisName;
        }

        @Override
        public final Builder whatIfAnalysisName(String whatIfAnalysisName) {
            this.whatIfAnalysisName = whatIfAnalysisName;
            return this;
        }

        public final String getForecastArn() {
            return forecastArn;
        }

        public final void setForecastArn(String forecastArn) {
            this.forecastArn = forecastArn;
        }

        @Override
        public final Builder forecastArn(String forecastArn) {
            this.forecastArn = forecastArn;
            return this;
        }

        public final TimeSeriesSelector.Builder getTimeSeriesSelector() {
            return timeSeriesSelector != null ? timeSeriesSelector.toBuilder() : null;
        }

        public final void setTimeSeriesSelector(TimeSeriesSelector.BuilderImpl timeSeriesSelector) {
            this.timeSeriesSelector = timeSeriesSelector != null ? timeSeriesSelector.build() : null;
        }

        @Override
        public final Builder timeSeriesSelector(TimeSeriesSelector timeSeriesSelector) {
            this.timeSeriesSelector = timeSeriesSelector;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateWhatIfAnalysisRequest build() {
            return new CreateWhatIfAnalysisRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
