/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.forecast.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.forecast.model.ScalingType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ContinuousParameterRange
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ContinuousParameterRange> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(ContinuousParameterRange.getter(ContinuousParameterRange::name)).setter(ContinuousParameterRange.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<Double> MAX_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("MaxValue").getter(ContinuousParameterRange.getter(ContinuousParameterRange::maxValue)).setter(ContinuousParameterRange.setter(Builder::maxValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxValue").build()}).build();
    private static final SdkField<Double> MIN_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("MinValue").getter(ContinuousParameterRange.getter(ContinuousParameterRange::minValue)).setter(ContinuousParameterRange.setter(Builder::minValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinValue").build()}).build();
    private static final SdkField<String> SCALING_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScalingType").getter(ContinuousParameterRange.getter(ContinuousParameterRange::scalingTypeAsString)).setter(ContinuousParameterRange.setter(Builder::scalingType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalingType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, MAX_VALUE_FIELD, MIN_VALUE_FIELD, SCALING_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ContinuousParameterRange.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final Double maxValue;
    private final Double minValue;
    private final String scalingType;

    private ContinuousParameterRange(BuilderImpl builder) {
        this.name = builder.name;
        this.maxValue = builder.maxValue;
        this.minValue = builder.minValue;
        this.scalingType = builder.scalingType;
    }

    public final String name() {
        return this.name;
    }

    public final Double maxValue() {
        return this.maxValue;
    }

    public final Double minValue() {
        return this.minValue;
    }

    public final ScalingType scalingType() {
        return ScalingType.fromValue(this.scalingType);
    }

    public final String scalingTypeAsString() {
        return this.scalingType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.minValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.scalingTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContinuousParameterRange)) {
            return false;
        }
        ContinuousParameterRange other = (ContinuousParameterRange)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.maxValue(), other.maxValue()) && Objects.equals(this.minValue(), other.minValue()) && Objects.equals(this.scalingTypeAsString(), other.scalingTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ContinuousParameterRange").add("Name", (Object)this.name()).add("MaxValue", (Object)this.maxValue()).add("MinValue", (Object)this.minValue()).add("ScalingType", (Object)this.scalingTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "MaxValue": {
                return Optional.ofNullable(clazz.cast(this.maxValue()));
            }
            case "MinValue": {
                return Optional.ofNullable(clazz.cast(this.minValue()));
            }
            case "ScalingType": {
                return Optional.ofNullable(clazz.cast(this.scalingTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("MaxValue", MAX_VALUE_FIELD);
        map.put("MinValue", MIN_VALUE_FIELD);
        map.put("ScalingType", SCALING_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ContinuousParameterRange, T> g) {
        return obj -> g.apply((ContinuousParameterRange)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private Double maxValue;
        private Double minValue;
        private String scalingType;

        private BuilderImpl() {
        }

        private BuilderImpl(ContinuousParameterRange model) {
            this.name(model.name);
            this.maxValue(model.maxValue);
            this.minValue(model.minValue);
            this.scalingType(model.scalingType);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Double getMaxValue() {
            return this.maxValue;
        }

        public final void setMaxValue(Double maxValue) {
            this.maxValue = maxValue;
        }

        @Override
        public final Builder maxValue(Double maxValue) {
            this.maxValue = maxValue;
            return this;
        }

        public final Double getMinValue() {
            return this.minValue;
        }

        public final void setMinValue(Double minValue) {
            this.minValue = minValue;
        }

        @Override
        public final Builder minValue(Double minValue) {
            this.minValue = minValue;
            return this;
        }

        public final String getScalingType() {
            return this.scalingType;
        }

        public final void setScalingType(String scalingType) {
            this.scalingType = scalingType;
        }

        @Override
        public final Builder scalingType(String scalingType) {
            this.scalingType = scalingType;
            return this;
        }

        @Override
        public final Builder scalingType(ScalingType scalingType) {
            this.scalingType(scalingType == null ? null : scalingType.toString());
            return this;
        }

        public ContinuousParameterRange build() {
            return new ContinuousParameterRange(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ContinuousParameterRange> {
        public Builder name(String var1);

        public Builder maxValue(Double var1);

        public Builder minValue(Double var1);

        public Builder scalingType(String var1);

        public Builder scalingType(ScalingType var1);
    }
}

