/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.forecast.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.forecast.ForecastClient;
import software.amazon.awssdk.services.forecast.internal.UserAgentUtils;
import software.amazon.awssdk.services.forecast.model.ExplainabilityExportSummary;
import software.amazon.awssdk.services.forecast.model.ListExplainabilityExportsRequest;
import software.amazon.awssdk.services.forecast.model.ListExplainabilityExportsResponse;

public class ListExplainabilityExportsIterable
implements SdkIterable<ListExplainabilityExportsResponse> {
    private final ForecastClient client;
    private final ListExplainabilityExportsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListExplainabilityExportsIterable(ForecastClient client, ListExplainabilityExportsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListExplainabilityExportsResponseFetcher();
    }

    public Iterator<ListExplainabilityExportsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ExplainabilityExportSummary> explainabilityExports() {
        Function<ListExplainabilityExportsResponse, Iterator> getIterator = response -> {
            if (response != null && response.explainabilityExports() != null) {
                return response.explainabilityExports().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListExplainabilityExportsResponseFetcher
    implements SyncPageFetcher<ListExplainabilityExportsResponse> {
        private ListExplainabilityExportsResponseFetcher() {
        }

        public boolean hasNextPage(ListExplainabilityExportsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListExplainabilityExportsResponse nextPage(ListExplainabilityExportsResponse previousPage) {
            if (previousPage == null) {
                return ListExplainabilityExportsIterable.this.client.listExplainabilityExports(ListExplainabilityExportsIterable.this.firstRequest);
            }
            return ListExplainabilityExportsIterable.this.client.listExplainabilityExports((ListExplainabilityExportsRequest)((Object)ListExplainabilityExportsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

