/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.forecast.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.forecast.model.DataSource;
import software.amazon.awssdk.services.forecast.model.ExplainabilityConfig;
import software.amazon.awssdk.services.forecast.model.ForecastResponse;
import software.amazon.awssdk.services.forecast.model.Schema;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeExplainabilityResponse
extends ForecastResponse
implements ToCopyableBuilder<Builder, DescribeExplainabilityResponse> {
    private static final SdkField<String> EXPLAINABILITY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExplainabilityArn").getter(DescribeExplainabilityResponse.getter(DescribeExplainabilityResponse::explainabilityArn)).setter(DescribeExplainabilityResponse.setter(Builder::explainabilityArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExplainabilityArn").build()}).build();
    private static final SdkField<String> EXPLAINABILITY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExplainabilityName").getter(DescribeExplainabilityResponse.getter(DescribeExplainabilityResponse::explainabilityName)).setter(DescribeExplainabilityResponse.setter(Builder::explainabilityName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExplainabilityName").build()}).build();
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceArn").getter(DescribeExplainabilityResponse.getter(DescribeExplainabilityResponse::resourceArn)).setter(DescribeExplainabilityResponse.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()}).build();
    private static final SdkField<ExplainabilityConfig> EXPLAINABILITY_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ExplainabilityConfig").getter(DescribeExplainabilityResponse.getter(DescribeExplainabilityResponse::explainabilityConfig)).setter(DescribeExplainabilityResponse.setter(Builder::explainabilityConfig)).constructor(ExplainabilityConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExplainabilityConfig").build()}).build();
    private static final SdkField<Boolean> ENABLE_VISUALIZATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnableVisualization").getter(DescribeExplainabilityResponse.getter(DescribeExplainabilityResponse::enableVisualization)).setter(DescribeExplainabilityResponse.setter(Builder::enableVisualization)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableVisualization").build()}).build();
    private static final SdkField<DataSource> DATA_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataSource").getter(DescribeExplainabilityResponse.getter(DescribeExplainabilityResponse::dataSource)).setter(DescribeExplainabilityResponse.setter(Builder::dataSource)).constructor(DataSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSource").build()}).build();
    private static final SdkField<Schema> SCHEMA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Schema").getter(DescribeExplainabilityResponse.getter(DescribeExplainabilityResponse::schema)).setter(DescribeExplainabilityResponse.setter(Builder::schema)).constructor(Schema::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schema").build()}).build();
    private static final SdkField<String> START_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StartDateTime").getter(DescribeExplainabilityResponse.getter(DescribeExplainabilityResponse::startDateTime)).setter(DescribeExplainabilityResponse.setter(Builder::startDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartDateTime").build()}).build();
    private static final SdkField<String> END_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndDateTime").getter(DescribeExplainabilityResponse.getter(DescribeExplainabilityResponse::endDateTime)).setter(DescribeExplainabilityResponse.setter(Builder::endDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndDateTime").build()}).build();
    private static final SdkField<Long> ESTIMATED_TIME_REMAINING_IN_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("EstimatedTimeRemainingInMinutes").getter(DescribeExplainabilityResponse.getter(DescribeExplainabilityResponse::estimatedTimeRemainingInMinutes)).setter(DescribeExplainabilityResponse.setter(Builder::estimatedTimeRemainingInMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedTimeRemainingInMinutes").build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Message").getter(DescribeExplainabilityResponse.getter(DescribeExplainabilityResponse::message)).setter(DescribeExplainabilityResponse.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DescribeExplainabilityResponse.getter(DescribeExplainabilityResponse::status)).setter(DescribeExplainabilityResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(DescribeExplainabilityResponse.getter(DescribeExplainabilityResponse::creationTime)).setter(DescribeExplainabilityResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> LAST_MODIFICATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModificationTime").getter(DescribeExplainabilityResponse.getter(DescribeExplainabilityResponse::lastModificationTime)).setter(DescribeExplainabilityResponse.setter(Builder::lastModificationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModificationTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPLAINABILITY_ARN_FIELD, EXPLAINABILITY_NAME_FIELD, RESOURCE_ARN_FIELD, EXPLAINABILITY_CONFIG_FIELD, ENABLE_VISUALIZATION_FIELD, DATA_SOURCE_FIELD, SCHEMA_FIELD, START_DATE_TIME_FIELD, END_DATE_TIME_FIELD, ESTIMATED_TIME_REMAINING_IN_MINUTES_FIELD, MESSAGE_FIELD, STATUS_FIELD, CREATION_TIME_FIELD, LAST_MODIFICATION_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ExplainabilityArn", EXPLAINABILITY_ARN_FIELD);
            this.put("ExplainabilityName", EXPLAINABILITY_NAME_FIELD);
            this.put("ResourceArn", RESOURCE_ARN_FIELD);
            this.put("ExplainabilityConfig", EXPLAINABILITY_CONFIG_FIELD);
            this.put("EnableVisualization", ENABLE_VISUALIZATION_FIELD);
            this.put("DataSource", DATA_SOURCE_FIELD);
            this.put("Schema", SCHEMA_FIELD);
            this.put("StartDateTime", START_DATE_TIME_FIELD);
            this.put("EndDateTime", END_DATE_TIME_FIELD);
            this.put("EstimatedTimeRemainingInMinutes", ESTIMATED_TIME_REMAINING_IN_MINUTES_FIELD);
            this.put("Message", MESSAGE_FIELD);
            this.put("Status", STATUS_FIELD);
            this.put("CreationTime", CREATION_TIME_FIELD);
            this.put("LastModificationTime", LAST_MODIFICATION_TIME_FIELD);
        }
    });
    private final String explainabilityArn;
    private final String explainabilityName;
    private final String resourceArn;
    private final ExplainabilityConfig explainabilityConfig;
    private final Boolean enableVisualization;
    private final DataSource dataSource;
    private final Schema schema;
    private final String startDateTime;
    private final String endDateTime;
    private final Long estimatedTimeRemainingInMinutes;
    private final String message;
    private final String status;
    private final Instant creationTime;
    private final Instant lastModificationTime;

    private DescribeExplainabilityResponse(BuilderImpl builder) {
        super(builder);
        this.explainabilityArn = builder.explainabilityArn;
        this.explainabilityName = builder.explainabilityName;
        this.resourceArn = builder.resourceArn;
        this.explainabilityConfig = builder.explainabilityConfig;
        this.enableVisualization = builder.enableVisualization;
        this.dataSource = builder.dataSource;
        this.schema = builder.schema;
        this.startDateTime = builder.startDateTime;
        this.endDateTime = builder.endDateTime;
        this.estimatedTimeRemainingInMinutes = builder.estimatedTimeRemainingInMinutes;
        this.message = builder.message;
        this.status = builder.status;
        this.creationTime = builder.creationTime;
        this.lastModificationTime = builder.lastModificationTime;
    }

    public final String explainabilityArn() {
        return this.explainabilityArn;
    }

    public final String explainabilityName() {
        return this.explainabilityName;
    }

    public final String resourceArn() {
        return this.resourceArn;
    }

    public final ExplainabilityConfig explainabilityConfig() {
        return this.explainabilityConfig;
    }

    public final Boolean enableVisualization() {
        return this.enableVisualization;
    }

    public final DataSource dataSource() {
        return this.dataSource;
    }

    public final Schema schema() {
        return this.schema;
    }

    public final String startDateTime() {
        return this.startDateTime;
    }

    public final String endDateTime() {
        return this.endDateTime;
    }

    public final Long estimatedTimeRemainingInMinutes() {
        return this.estimatedTimeRemainingInMinutes;
    }

    public final String message() {
        return this.message;
    }

    public final String status() {
        return this.status;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant lastModificationTime() {
        return this.lastModificationTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.explainabilityArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.explainabilityName());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.explainabilityConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableVisualization());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.schema());
        hashCode = 31 * hashCode + Objects.hashCode(this.startDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.estimatedTimeRemainingInMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModificationTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeExplainabilityResponse)) {
            return false;
        }
        DescribeExplainabilityResponse other = (DescribeExplainabilityResponse)((Object)obj);
        return Objects.equals(this.explainabilityArn(), other.explainabilityArn()) && Objects.equals(this.explainabilityName(), other.explainabilityName()) && Objects.equals(this.resourceArn(), other.resourceArn()) && Objects.equals(this.explainabilityConfig(), other.explainabilityConfig()) && Objects.equals(this.enableVisualization(), other.enableVisualization()) && Objects.equals(this.dataSource(), other.dataSource()) && Objects.equals(this.schema(), other.schema()) && Objects.equals(this.startDateTime(), other.startDateTime()) && Objects.equals(this.endDateTime(), other.endDateTime()) && Objects.equals(this.estimatedTimeRemainingInMinutes(), other.estimatedTimeRemainingInMinutes()) && Objects.equals(this.message(), other.message()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastModificationTime(), other.lastModificationTime());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeExplainabilityResponse").add("ExplainabilityArn", (Object)this.explainabilityArn()).add("ExplainabilityName", (Object)this.explainabilityName()).add("ResourceArn", (Object)this.resourceArn()).add("ExplainabilityConfig", (Object)this.explainabilityConfig()).add("EnableVisualization", (Object)this.enableVisualization()).add("DataSource", (Object)this.dataSource()).add("Schema", (Object)this.schema()).add("StartDateTime", (Object)this.startDateTime()).add("EndDateTime", (Object)this.endDateTime()).add("EstimatedTimeRemainingInMinutes", (Object)this.estimatedTimeRemainingInMinutes()).add("Message", (Object)this.message()).add("Status", (Object)this.status()).add("CreationTime", (Object)this.creationTime()).add("LastModificationTime", (Object)this.lastModificationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ExplainabilityArn": {
                return Optional.ofNullable(clazz.cast(this.explainabilityArn()));
            }
            case "ExplainabilityName": {
                return Optional.ofNullable(clazz.cast(this.explainabilityName()));
            }
            case "ResourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
            case "ExplainabilityConfig": {
                return Optional.ofNullable(clazz.cast(this.explainabilityConfig()));
            }
            case "EnableVisualization": {
                return Optional.ofNullable(clazz.cast(this.enableVisualization()));
            }
            case "DataSource": {
                return Optional.ofNullable(clazz.cast(this.dataSource()));
            }
            case "Schema": {
                return Optional.ofNullable(clazz.cast(this.schema()));
            }
            case "StartDateTime": {
                return Optional.ofNullable(clazz.cast(this.startDateTime()));
            }
            case "EndDateTime": {
                return Optional.ofNullable(clazz.cast(this.endDateTime()));
            }
            case "EstimatedTimeRemainingInMinutes": {
                return Optional.ofNullable(clazz.cast(this.estimatedTimeRemainingInMinutes()));
            }
            case "Message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "LastModificationTime": {
                return Optional.ofNullable(clazz.cast(this.lastModificationTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeExplainabilityResponse, T> g) {
        return obj -> g.apply((DescribeExplainabilityResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ForecastResponse.BuilderImpl
    implements Builder {
        private String explainabilityArn;
        private String explainabilityName;
        private String resourceArn;
        private ExplainabilityConfig explainabilityConfig;
        private Boolean enableVisualization;
        private DataSource dataSource;
        private Schema schema;
        private String startDateTime;
        private String endDateTime;
        private Long estimatedTimeRemainingInMinutes;
        private String message;
        private String status;
        private Instant creationTime;
        private Instant lastModificationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeExplainabilityResponse model) {
            super(model);
            this.explainabilityArn(model.explainabilityArn);
            this.explainabilityName(model.explainabilityName);
            this.resourceArn(model.resourceArn);
            this.explainabilityConfig(model.explainabilityConfig);
            this.enableVisualization(model.enableVisualization);
            this.dataSource(model.dataSource);
            this.schema(model.schema);
            this.startDateTime(model.startDateTime);
            this.endDateTime(model.endDateTime);
            this.estimatedTimeRemainingInMinutes(model.estimatedTimeRemainingInMinutes);
            this.message(model.message);
            this.status(model.status);
            this.creationTime(model.creationTime);
            this.lastModificationTime(model.lastModificationTime);
        }

        public final String getExplainabilityArn() {
            return this.explainabilityArn;
        }

        public final void setExplainabilityArn(String explainabilityArn) {
            this.explainabilityArn = explainabilityArn;
        }

        @Override
        public final Builder explainabilityArn(String explainabilityArn) {
            this.explainabilityArn = explainabilityArn;
            return this;
        }

        public final String getExplainabilityName() {
            return this.explainabilityName;
        }

        public final void setExplainabilityName(String explainabilityName) {
            this.explainabilityName = explainabilityName;
        }

        @Override
        public final Builder explainabilityName(String explainabilityName) {
            this.explainabilityName = explainabilityName;
            return this;
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final ExplainabilityConfig.Builder getExplainabilityConfig() {
            return this.explainabilityConfig != null ? this.explainabilityConfig.toBuilder() : null;
        }

        public final void setExplainabilityConfig(ExplainabilityConfig.BuilderImpl explainabilityConfig) {
            this.explainabilityConfig = explainabilityConfig != null ? explainabilityConfig.build() : null;
        }

        @Override
        public final Builder explainabilityConfig(ExplainabilityConfig explainabilityConfig) {
            this.explainabilityConfig = explainabilityConfig;
            return this;
        }

        public final Boolean getEnableVisualization() {
            return this.enableVisualization;
        }

        public final void setEnableVisualization(Boolean enableVisualization) {
            this.enableVisualization = enableVisualization;
        }

        @Override
        public final Builder enableVisualization(Boolean enableVisualization) {
            this.enableVisualization = enableVisualization;
            return this;
        }

        public final DataSource.Builder getDataSource() {
            return this.dataSource != null ? this.dataSource.toBuilder() : null;
        }

        public final void setDataSource(DataSource.BuilderImpl dataSource) {
            this.dataSource = dataSource != null ? dataSource.build() : null;
        }

        @Override
        public final Builder dataSource(DataSource dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public final Schema.Builder getSchema() {
            return this.schema != null ? this.schema.toBuilder() : null;
        }

        public final void setSchema(Schema.BuilderImpl schema) {
            this.schema = schema != null ? schema.build() : null;
        }

        @Override
        public final Builder schema(Schema schema) {
            this.schema = schema;
            return this;
        }

        public final String getStartDateTime() {
            return this.startDateTime;
        }

        public final void setStartDateTime(String startDateTime) {
            this.startDateTime = startDateTime;
        }

        @Override
        public final Builder startDateTime(String startDateTime) {
            this.startDateTime = startDateTime;
            return this;
        }

        public final String getEndDateTime() {
            return this.endDateTime;
        }

        public final void setEndDateTime(String endDateTime) {
            this.endDateTime = endDateTime;
        }

        @Override
        public final Builder endDateTime(String endDateTime) {
            this.endDateTime = endDateTime;
            return this;
        }

        public final Long getEstimatedTimeRemainingInMinutes() {
            return this.estimatedTimeRemainingInMinutes;
        }

        public final void setEstimatedTimeRemainingInMinutes(Long estimatedTimeRemainingInMinutes) {
            this.estimatedTimeRemainingInMinutes = estimatedTimeRemainingInMinutes;
        }

        @Override
        public final Builder estimatedTimeRemainingInMinutes(Long estimatedTimeRemainingInMinutes) {
            this.estimatedTimeRemainingInMinutes = estimatedTimeRemainingInMinutes;
            return this;
        }

        public final String getMessage() {
            return this.message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModificationTime() {
            return this.lastModificationTime;
        }

        public final void setLastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
        }

        @Override
        public final Builder lastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
            return this;
        }

        @Override
        public DescribeExplainabilityResponse build() {
            return new DescribeExplainabilityResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ForecastResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeExplainabilityResponse> {
        public Builder explainabilityArn(String var1);

        public Builder explainabilityName(String var1);

        public Builder resourceArn(String var1);

        public Builder explainabilityConfig(ExplainabilityConfig var1);

        default public Builder explainabilityConfig(Consumer<ExplainabilityConfig.Builder> explainabilityConfig) {
            return this.explainabilityConfig((ExplainabilityConfig)((ExplainabilityConfig.Builder)ExplainabilityConfig.builder().applyMutation(explainabilityConfig)).build());
        }

        public Builder enableVisualization(Boolean var1);

        public Builder dataSource(DataSource var1);

        default public Builder dataSource(Consumer<DataSource.Builder> dataSource) {
            return this.dataSource((DataSource)((DataSource.Builder)DataSource.builder().applyMutation(dataSource)).build());
        }

        public Builder schema(Schema var1);

        default public Builder schema(Consumer<Schema.Builder> schema) {
            return this.schema((Schema)((Schema.Builder)Schema.builder().applyMutation(schema)).build());
        }

        public Builder startDateTime(String var1);

        public Builder endDateTime(String var1);

        public Builder estimatedTimeRemainingInMinutes(Long var1);

        public Builder message(String var1);

        public Builder status(String var1);

        public Builder creationTime(Instant var1);

        public Builder lastModificationTime(Instant var1);
    }
}

