/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.forecast.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.forecast.model.Baseline;
import software.amazon.awssdk.services.forecast.model.ForecastResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeMonitorResponse
extends ForecastResponse
implements ToCopyableBuilder<Builder, DescribeMonitorResponse> {
    private static final SdkField<String> MONITOR_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MonitorName").getter(DescribeMonitorResponse.getter(DescribeMonitorResponse::monitorName)).setter(DescribeMonitorResponse.setter(Builder::monitorName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitorName").build()}).build();
    private static final SdkField<String> MONITOR_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MonitorArn").getter(DescribeMonitorResponse.getter(DescribeMonitorResponse::monitorArn)).setter(DescribeMonitorResponse.setter(Builder::monitorArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitorArn").build()}).build();
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceArn").getter(DescribeMonitorResponse.getter(DescribeMonitorResponse::resourceArn)).setter(DescribeMonitorResponse.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DescribeMonitorResponse.getter(DescribeMonitorResponse::status)).setter(DescribeMonitorResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> LAST_EVALUATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastEvaluationTime").getter(DescribeMonitorResponse.getter(DescribeMonitorResponse::lastEvaluationTime)).setter(DescribeMonitorResponse.setter(Builder::lastEvaluationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastEvaluationTime").build()}).build();
    private static final SdkField<String> LAST_EVALUATION_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastEvaluationState").getter(DescribeMonitorResponse.getter(DescribeMonitorResponse::lastEvaluationState)).setter(DescribeMonitorResponse.setter(Builder::lastEvaluationState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastEvaluationState").build()}).build();
    private static final SdkField<Baseline> BASELINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Baseline").getter(DescribeMonitorResponse.getter(DescribeMonitorResponse::baseline)).setter(DescribeMonitorResponse.setter(Builder::baseline)).constructor(Baseline::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Baseline").build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Message").getter(DescribeMonitorResponse.getter(DescribeMonitorResponse::message)).setter(DescribeMonitorResponse.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(DescribeMonitorResponse.getter(DescribeMonitorResponse::creationTime)).setter(DescribeMonitorResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> LAST_MODIFICATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModificationTime").getter(DescribeMonitorResponse.getter(DescribeMonitorResponse::lastModificationTime)).setter(DescribeMonitorResponse.setter(Builder::lastModificationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModificationTime").build()}).build();
    private static final SdkField<Long> ESTIMATED_EVALUATION_TIME_REMAINING_IN_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("EstimatedEvaluationTimeRemainingInMinutes").getter(DescribeMonitorResponse.getter(DescribeMonitorResponse::estimatedEvaluationTimeRemainingInMinutes)).setter(DescribeMonitorResponse.setter(Builder::estimatedEvaluationTimeRemainingInMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedEvaluationTimeRemainingInMinutes").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MONITOR_NAME_FIELD, MONITOR_ARN_FIELD, RESOURCE_ARN_FIELD, STATUS_FIELD, LAST_EVALUATION_TIME_FIELD, LAST_EVALUATION_STATE_FIELD, BASELINE_FIELD, MESSAGE_FIELD, CREATION_TIME_FIELD, LAST_MODIFICATION_TIME_FIELD, ESTIMATED_EVALUATION_TIME_REMAINING_IN_MINUTES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("MonitorName", MONITOR_NAME_FIELD);
            this.put("MonitorArn", MONITOR_ARN_FIELD);
            this.put("ResourceArn", RESOURCE_ARN_FIELD);
            this.put("Status", STATUS_FIELD);
            this.put("LastEvaluationTime", LAST_EVALUATION_TIME_FIELD);
            this.put("LastEvaluationState", LAST_EVALUATION_STATE_FIELD);
            this.put("Baseline", BASELINE_FIELD);
            this.put("Message", MESSAGE_FIELD);
            this.put("CreationTime", CREATION_TIME_FIELD);
            this.put("LastModificationTime", LAST_MODIFICATION_TIME_FIELD);
            this.put("EstimatedEvaluationTimeRemainingInMinutes", ESTIMATED_EVALUATION_TIME_REMAINING_IN_MINUTES_FIELD);
        }
    });
    private final String monitorName;
    private final String monitorArn;
    private final String resourceArn;
    private final String status;
    private final Instant lastEvaluationTime;
    private final String lastEvaluationState;
    private final Baseline baseline;
    private final String message;
    private final Instant creationTime;
    private final Instant lastModificationTime;
    private final Long estimatedEvaluationTimeRemainingInMinutes;

    private DescribeMonitorResponse(BuilderImpl builder) {
        super(builder);
        this.monitorName = builder.monitorName;
        this.monitorArn = builder.monitorArn;
        this.resourceArn = builder.resourceArn;
        this.status = builder.status;
        this.lastEvaluationTime = builder.lastEvaluationTime;
        this.lastEvaluationState = builder.lastEvaluationState;
        this.baseline = builder.baseline;
        this.message = builder.message;
        this.creationTime = builder.creationTime;
        this.lastModificationTime = builder.lastModificationTime;
        this.estimatedEvaluationTimeRemainingInMinutes = builder.estimatedEvaluationTimeRemainingInMinutes;
    }

    public final String monitorName() {
        return this.monitorName;
    }

    public final String monitorArn() {
        return this.monitorArn;
    }

    public final String resourceArn() {
        return this.resourceArn;
    }

    public final String status() {
        return this.status;
    }

    public final Instant lastEvaluationTime() {
        return this.lastEvaluationTime;
    }

    public final String lastEvaluationState() {
        return this.lastEvaluationState;
    }

    public final Baseline baseline() {
        return this.baseline;
    }

    public final String message() {
        return this.message;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant lastModificationTime() {
        return this.lastModificationTime;
    }

    public final Long estimatedEvaluationTimeRemainingInMinutes() {
        return this.estimatedEvaluationTimeRemainingInMinutes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.monitorName());
        hashCode = 31 * hashCode + Objects.hashCode(this.monitorArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastEvaluationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastEvaluationState());
        hashCode = 31 * hashCode + Objects.hashCode(this.baseline());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModificationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.estimatedEvaluationTimeRemainingInMinutes());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMonitorResponse)) {
            return false;
        }
        DescribeMonitorResponse other = (DescribeMonitorResponse)((Object)obj);
        return Objects.equals(this.monitorName(), other.monitorName()) && Objects.equals(this.monitorArn(), other.monitorArn()) && Objects.equals(this.resourceArn(), other.resourceArn()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.lastEvaluationTime(), other.lastEvaluationTime()) && Objects.equals(this.lastEvaluationState(), other.lastEvaluationState()) && Objects.equals(this.baseline(), other.baseline()) && Objects.equals(this.message(), other.message()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastModificationTime(), other.lastModificationTime()) && Objects.equals(this.estimatedEvaluationTimeRemainingInMinutes(), other.estimatedEvaluationTimeRemainingInMinutes());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeMonitorResponse").add("MonitorName", (Object)this.monitorName()).add("MonitorArn", (Object)this.monitorArn()).add("ResourceArn", (Object)this.resourceArn()).add("Status", (Object)this.status()).add("LastEvaluationTime", (Object)this.lastEvaluationTime()).add("LastEvaluationState", (Object)this.lastEvaluationState()).add("Baseline", (Object)this.baseline()).add("Message", (Object)this.message()).add("CreationTime", (Object)this.creationTime()).add("LastModificationTime", (Object)this.lastModificationTime()).add("EstimatedEvaluationTimeRemainingInMinutes", (Object)this.estimatedEvaluationTimeRemainingInMinutes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MonitorName": {
                return Optional.ofNullable(clazz.cast(this.monitorName()));
            }
            case "MonitorArn": {
                return Optional.ofNullable(clazz.cast(this.monitorArn()));
            }
            case "ResourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "LastEvaluationTime": {
                return Optional.ofNullable(clazz.cast(this.lastEvaluationTime()));
            }
            case "LastEvaluationState": {
                return Optional.ofNullable(clazz.cast(this.lastEvaluationState()));
            }
            case "Baseline": {
                return Optional.ofNullable(clazz.cast(this.baseline()));
            }
            case "Message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "LastModificationTime": {
                return Optional.ofNullable(clazz.cast(this.lastModificationTime()));
            }
            case "EstimatedEvaluationTimeRemainingInMinutes": {
                return Optional.ofNullable(clazz.cast(this.estimatedEvaluationTimeRemainingInMinutes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeMonitorResponse, T> g) {
        return obj -> g.apply((DescribeMonitorResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ForecastResponse.BuilderImpl
    implements Builder {
        private String monitorName;
        private String monitorArn;
        private String resourceArn;
        private String status;
        private Instant lastEvaluationTime;
        private String lastEvaluationState;
        private Baseline baseline;
        private String message;
        private Instant creationTime;
        private Instant lastModificationTime;
        private Long estimatedEvaluationTimeRemainingInMinutes;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMonitorResponse model) {
            super(model);
            this.monitorName(model.monitorName);
            this.monitorArn(model.monitorArn);
            this.resourceArn(model.resourceArn);
            this.status(model.status);
            this.lastEvaluationTime(model.lastEvaluationTime);
            this.lastEvaluationState(model.lastEvaluationState);
            this.baseline(model.baseline);
            this.message(model.message);
            this.creationTime(model.creationTime);
            this.lastModificationTime(model.lastModificationTime);
            this.estimatedEvaluationTimeRemainingInMinutes(model.estimatedEvaluationTimeRemainingInMinutes);
        }

        public final String getMonitorName() {
            return this.monitorName;
        }

        public final void setMonitorName(String monitorName) {
            this.monitorName = monitorName;
        }

        @Override
        public final Builder monitorName(String monitorName) {
            this.monitorName = monitorName;
            return this;
        }

        public final String getMonitorArn() {
            return this.monitorArn;
        }

        public final void setMonitorArn(String monitorArn) {
            this.monitorArn = monitorArn;
        }

        @Override
        public final Builder monitorArn(String monitorArn) {
            this.monitorArn = monitorArn;
            return this;
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final Instant getLastEvaluationTime() {
            return this.lastEvaluationTime;
        }

        public final void setLastEvaluationTime(Instant lastEvaluationTime) {
            this.lastEvaluationTime = lastEvaluationTime;
        }

        @Override
        public final Builder lastEvaluationTime(Instant lastEvaluationTime) {
            this.lastEvaluationTime = lastEvaluationTime;
            return this;
        }

        public final String getLastEvaluationState() {
            return this.lastEvaluationState;
        }

        public final void setLastEvaluationState(String lastEvaluationState) {
            this.lastEvaluationState = lastEvaluationState;
        }

        @Override
        public final Builder lastEvaluationState(String lastEvaluationState) {
            this.lastEvaluationState = lastEvaluationState;
            return this;
        }

        public final Baseline.Builder getBaseline() {
            return this.baseline != null ? this.baseline.toBuilder() : null;
        }

        public final void setBaseline(Baseline.BuilderImpl baseline) {
            this.baseline = baseline != null ? baseline.build() : null;
        }

        @Override
        public final Builder baseline(Baseline baseline) {
            this.baseline = baseline;
            return this;
        }

        public final String getMessage() {
            return this.message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModificationTime() {
            return this.lastModificationTime;
        }

        public final void setLastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
        }

        @Override
        public final Builder lastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
            return this;
        }

        public final Long getEstimatedEvaluationTimeRemainingInMinutes() {
            return this.estimatedEvaluationTimeRemainingInMinutes;
        }

        public final void setEstimatedEvaluationTimeRemainingInMinutes(Long estimatedEvaluationTimeRemainingInMinutes) {
            this.estimatedEvaluationTimeRemainingInMinutes = estimatedEvaluationTimeRemainingInMinutes;
        }

        @Override
        public final Builder estimatedEvaluationTimeRemainingInMinutes(Long estimatedEvaluationTimeRemainingInMinutes) {
            this.estimatedEvaluationTimeRemainingInMinutes = estimatedEvaluationTimeRemainingInMinutes;
            return this;
        }

        @Override
        public DescribeMonitorResponse build() {
            return new DescribeMonitorResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ForecastResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeMonitorResponse> {
        public Builder monitorName(String var1);

        public Builder monitorArn(String var1);

        public Builder resourceArn(String var1);

        public Builder status(String var1);

        public Builder lastEvaluationTime(Instant var1);

        public Builder lastEvaluationState(String var1);

        public Builder baseline(Baseline var1);

        default public Builder baseline(Consumer<Baseline.Builder> baseline) {
            return this.baseline((Baseline)((Baseline.Builder)Baseline.builder().applyMutation(baseline)).build());
        }

        public Builder message(String var1);

        public Builder creationTime(Instant var1);

        public Builder lastModificationTime(Instant var1);

        public Builder estimatedEvaluationTimeRemainingInMinutes(Long var1);
    }
}

