/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.forecast.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.forecast.model.ForecastResponse;
import software.amazon.awssdk.services.forecast.model.ForecastTypesCopier;
import software.amazon.awssdk.services.forecast.model.TimeSeriesSelector;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeForecastResponse
extends ForecastResponse
implements ToCopyableBuilder<Builder, DescribeForecastResponse> {
    private static final SdkField<String> FORECAST_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ForecastArn").getter(DescribeForecastResponse.getter(DescribeForecastResponse::forecastArn)).setter(DescribeForecastResponse.setter(Builder::forecastArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForecastArn").build()}).build();
    private static final SdkField<String> FORECAST_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ForecastName").getter(DescribeForecastResponse.getter(DescribeForecastResponse::forecastName)).setter(DescribeForecastResponse.setter(Builder::forecastName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForecastName").build()}).build();
    private static final SdkField<List<String>> FORECAST_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ForecastTypes").getter(DescribeForecastResponse.getter(DescribeForecastResponse::forecastTypes)).setter(DescribeForecastResponse.setter(Builder::forecastTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForecastTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PREDICTOR_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PredictorArn").getter(DescribeForecastResponse.getter(DescribeForecastResponse::predictorArn)).setter(DescribeForecastResponse.setter(Builder::predictorArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PredictorArn").build()}).build();
    private static final SdkField<String> DATASET_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatasetGroupArn").getter(DescribeForecastResponse.getter(DescribeForecastResponse::datasetGroupArn)).setter(DescribeForecastResponse.setter(Builder::datasetGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetGroupArn").build()}).build();
    private static final SdkField<Long> ESTIMATED_TIME_REMAINING_IN_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("EstimatedTimeRemainingInMinutes").getter(DescribeForecastResponse.getter(DescribeForecastResponse::estimatedTimeRemainingInMinutes)).setter(DescribeForecastResponse.setter(Builder::estimatedTimeRemainingInMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedTimeRemainingInMinutes").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DescribeForecastResponse.getter(DescribeForecastResponse::status)).setter(DescribeForecastResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Message").getter(DescribeForecastResponse.getter(DescribeForecastResponse::message)).setter(DescribeForecastResponse.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(DescribeForecastResponse.getter(DescribeForecastResponse::creationTime)).setter(DescribeForecastResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> LAST_MODIFICATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModificationTime").getter(DescribeForecastResponse.getter(DescribeForecastResponse::lastModificationTime)).setter(DescribeForecastResponse.setter(Builder::lastModificationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModificationTime").build()}).build();
    private static final SdkField<TimeSeriesSelector> TIME_SERIES_SELECTOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TimeSeriesSelector").getter(DescribeForecastResponse.getter(DescribeForecastResponse::timeSeriesSelector)).setter(DescribeForecastResponse.setter(Builder::timeSeriesSelector)).constructor(TimeSeriesSelector::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeSeriesSelector").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FORECAST_ARN_FIELD, FORECAST_NAME_FIELD, FORECAST_TYPES_FIELD, PREDICTOR_ARN_FIELD, DATASET_GROUP_ARN_FIELD, ESTIMATED_TIME_REMAINING_IN_MINUTES_FIELD, STATUS_FIELD, MESSAGE_FIELD, CREATION_TIME_FIELD, LAST_MODIFICATION_TIME_FIELD, TIME_SERIES_SELECTOR_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeForecastResponse.memberNameToFieldInitializer();
    private final String forecastArn;
    private final String forecastName;
    private final List<String> forecastTypes;
    private final String predictorArn;
    private final String datasetGroupArn;
    private final Long estimatedTimeRemainingInMinutes;
    private final String status;
    private final String message;
    private final Instant creationTime;
    private final Instant lastModificationTime;
    private final TimeSeriesSelector timeSeriesSelector;

    private DescribeForecastResponse(BuilderImpl builder) {
        super(builder);
        this.forecastArn = builder.forecastArn;
        this.forecastName = builder.forecastName;
        this.forecastTypes = builder.forecastTypes;
        this.predictorArn = builder.predictorArn;
        this.datasetGroupArn = builder.datasetGroupArn;
        this.estimatedTimeRemainingInMinutes = builder.estimatedTimeRemainingInMinutes;
        this.status = builder.status;
        this.message = builder.message;
        this.creationTime = builder.creationTime;
        this.lastModificationTime = builder.lastModificationTime;
        this.timeSeriesSelector = builder.timeSeriesSelector;
    }

    public final String forecastArn() {
        return this.forecastArn;
    }

    public final String forecastName() {
        return this.forecastName;
    }

    public final boolean hasForecastTypes() {
        return this.forecastTypes != null && !(this.forecastTypes instanceof SdkAutoConstructList);
    }

    public final List<String> forecastTypes() {
        return this.forecastTypes;
    }

    public final String predictorArn() {
        return this.predictorArn;
    }

    public final String datasetGroupArn() {
        return this.datasetGroupArn;
    }

    public final Long estimatedTimeRemainingInMinutes() {
        return this.estimatedTimeRemainingInMinutes;
    }

    public final String status() {
        return this.status;
    }

    public final String message() {
        return this.message;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant lastModificationTime() {
        return this.lastModificationTime;
    }

    public final TimeSeriesSelector timeSeriesSelector() {
        return this.timeSeriesSelector;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.forecastArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.forecastName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasForecastTypes() ? this.forecastTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.predictorArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.estimatedTimeRemainingInMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModificationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeSeriesSelector());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeForecastResponse)) {
            return false;
        }
        DescribeForecastResponse other = (DescribeForecastResponse)((Object)obj);
        return Objects.equals(this.forecastArn(), other.forecastArn()) && Objects.equals(this.forecastName(), other.forecastName()) && this.hasForecastTypes() == other.hasForecastTypes() && Objects.equals(this.forecastTypes(), other.forecastTypes()) && Objects.equals(this.predictorArn(), other.predictorArn()) && Objects.equals(this.datasetGroupArn(), other.datasetGroupArn()) && Objects.equals(this.estimatedTimeRemainingInMinutes(), other.estimatedTimeRemainingInMinutes()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.message(), other.message()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastModificationTime(), other.lastModificationTime()) && Objects.equals(this.timeSeriesSelector(), other.timeSeriesSelector());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeForecastResponse").add("ForecastArn", (Object)this.forecastArn()).add("ForecastName", (Object)this.forecastName()).add("ForecastTypes", this.hasForecastTypes() ? this.forecastTypes() : null).add("PredictorArn", (Object)this.predictorArn()).add("DatasetGroupArn", (Object)this.datasetGroupArn()).add("EstimatedTimeRemainingInMinutes", (Object)this.estimatedTimeRemainingInMinutes()).add("Status", (Object)this.status()).add("Message", (Object)this.message()).add("CreationTime", (Object)this.creationTime()).add("LastModificationTime", (Object)this.lastModificationTime()).add("TimeSeriesSelector", (Object)this.timeSeriesSelector()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ForecastArn": {
                return Optional.ofNullable(clazz.cast(this.forecastArn()));
            }
            case "ForecastName": {
                return Optional.ofNullable(clazz.cast(this.forecastName()));
            }
            case "ForecastTypes": {
                return Optional.ofNullable(clazz.cast(this.forecastTypes()));
            }
            case "PredictorArn": {
                return Optional.ofNullable(clazz.cast(this.predictorArn()));
            }
            case "DatasetGroupArn": {
                return Optional.ofNullable(clazz.cast(this.datasetGroupArn()));
            }
            case "EstimatedTimeRemainingInMinutes": {
                return Optional.ofNullable(clazz.cast(this.estimatedTimeRemainingInMinutes()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "Message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "LastModificationTime": {
                return Optional.ofNullable(clazz.cast(this.lastModificationTime()));
            }
            case "TimeSeriesSelector": {
                return Optional.ofNullable(clazz.cast(this.timeSeriesSelector()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ForecastArn", FORECAST_ARN_FIELD);
        map.put("ForecastName", FORECAST_NAME_FIELD);
        map.put("ForecastTypes", FORECAST_TYPES_FIELD);
        map.put("PredictorArn", PREDICTOR_ARN_FIELD);
        map.put("DatasetGroupArn", DATASET_GROUP_ARN_FIELD);
        map.put("EstimatedTimeRemainingInMinutes", ESTIMATED_TIME_REMAINING_IN_MINUTES_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Message", MESSAGE_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("LastModificationTime", LAST_MODIFICATION_TIME_FIELD);
        map.put("TimeSeriesSelector", TIME_SERIES_SELECTOR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeForecastResponse, T> g) {
        return obj -> g.apply((DescribeForecastResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ForecastResponse.BuilderImpl
    implements Builder {
        private String forecastArn;
        private String forecastName;
        private List<String> forecastTypes = DefaultSdkAutoConstructList.getInstance();
        private String predictorArn;
        private String datasetGroupArn;
        private Long estimatedTimeRemainingInMinutes;
        private String status;
        private String message;
        private Instant creationTime;
        private Instant lastModificationTime;
        private TimeSeriesSelector timeSeriesSelector;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeForecastResponse model) {
            super(model);
            this.forecastArn(model.forecastArn);
            this.forecastName(model.forecastName);
            this.forecastTypes(model.forecastTypes);
            this.predictorArn(model.predictorArn);
            this.datasetGroupArn(model.datasetGroupArn);
            this.estimatedTimeRemainingInMinutes(model.estimatedTimeRemainingInMinutes);
            this.status(model.status);
            this.message(model.message);
            this.creationTime(model.creationTime);
            this.lastModificationTime(model.lastModificationTime);
            this.timeSeriesSelector(model.timeSeriesSelector);
        }

        public final String getForecastArn() {
            return this.forecastArn;
        }

        public final void setForecastArn(String forecastArn) {
            this.forecastArn = forecastArn;
        }

        @Override
        public final Builder forecastArn(String forecastArn) {
            this.forecastArn = forecastArn;
            return this;
        }

        public final String getForecastName() {
            return this.forecastName;
        }

        public final void setForecastName(String forecastName) {
            this.forecastName = forecastName;
        }

        @Override
        public final Builder forecastName(String forecastName) {
            this.forecastName = forecastName;
            return this;
        }

        public final Collection<String> getForecastTypes() {
            if (this.forecastTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.forecastTypes;
        }

        public final void setForecastTypes(Collection<String> forecastTypes) {
            this.forecastTypes = ForecastTypesCopier.copy(forecastTypes);
        }

        @Override
        public final Builder forecastTypes(Collection<String> forecastTypes) {
            this.forecastTypes = ForecastTypesCopier.copy(forecastTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder forecastTypes(String ... forecastTypes) {
            this.forecastTypes(Arrays.asList(forecastTypes));
            return this;
        }

        public final String getPredictorArn() {
            return this.predictorArn;
        }

        public final void setPredictorArn(String predictorArn) {
            this.predictorArn = predictorArn;
        }

        @Override
        public final Builder predictorArn(String predictorArn) {
            this.predictorArn = predictorArn;
            return this;
        }

        public final String getDatasetGroupArn() {
            return this.datasetGroupArn;
        }

        public final void setDatasetGroupArn(String datasetGroupArn) {
            this.datasetGroupArn = datasetGroupArn;
        }

        @Override
        public final Builder datasetGroupArn(String datasetGroupArn) {
            this.datasetGroupArn = datasetGroupArn;
            return this;
        }

        public final Long getEstimatedTimeRemainingInMinutes() {
            return this.estimatedTimeRemainingInMinutes;
        }

        public final void setEstimatedTimeRemainingInMinutes(Long estimatedTimeRemainingInMinutes) {
            this.estimatedTimeRemainingInMinutes = estimatedTimeRemainingInMinutes;
        }

        @Override
        public final Builder estimatedTimeRemainingInMinutes(Long estimatedTimeRemainingInMinutes) {
            this.estimatedTimeRemainingInMinutes = estimatedTimeRemainingInMinutes;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getMessage() {
            return this.message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModificationTime() {
            return this.lastModificationTime;
        }

        public final void setLastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
        }

        @Override
        public final Builder lastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
            return this;
        }

        public final TimeSeriesSelector.Builder getTimeSeriesSelector() {
            return this.timeSeriesSelector != null ? this.timeSeriesSelector.toBuilder() : null;
        }

        public final void setTimeSeriesSelector(TimeSeriesSelector.BuilderImpl timeSeriesSelector) {
            this.timeSeriesSelector = timeSeriesSelector != null ? timeSeriesSelector.build() : null;
        }

        @Override
        public final Builder timeSeriesSelector(TimeSeriesSelector timeSeriesSelector) {
            this.timeSeriesSelector = timeSeriesSelector;
            return this;
        }

        @Override
        public DescribeForecastResponse build() {
            return new DescribeForecastResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ForecastResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeForecastResponse> {
        public Builder forecastArn(String var1);

        public Builder forecastName(String var1);

        public Builder forecastTypes(Collection<String> var1);

        public Builder forecastTypes(String ... var1);

        public Builder predictorArn(String var1);

        public Builder datasetGroupArn(String var1);

        public Builder estimatedTimeRemainingInMinutes(Long var1);

        public Builder status(String var1);

        public Builder message(String var1);

        public Builder creationTime(Instant var1);

        public Builder lastModificationTime(Instant var1);

        public Builder timeSeriesSelector(TimeSeriesSelector var1);

        default public Builder timeSeriesSelector(Consumer<TimeSeriesSelector.Builder> timeSeriesSelector) {
            return this.timeSeriesSelector((TimeSeriesSelector)((TimeSeriesSelector.Builder)TimeSeriesSelector.builder().applyMutation(timeSeriesSelector)).build());
        }
    }
}

