/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.forecast.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.forecast.model.ForecastResponse;
import software.amazon.awssdk.services.forecast.model.PredictorMonitorEvaluation;
import software.amazon.awssdk.services.forecast.model.PredictorMonitorEvaluationsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListMonitorEvaluationsResponse
extends ForecastResponse
implements ToCopyableBuilder<Builder, ListMonitorEvaluationsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListMonitorEvaluationsResponse.getter(ListMonitorEvaluationsResponse::nextToken)).setter(ListMonitorEvaluationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<PredictorMonitorEvaluation>> PREDICTOR_MONITOR_EVALUATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PredictorMonitorEvaluations").getter(ListMonitorEvaluationsResponse.getter(ListMonitorEvaluationsResponse::predictorMonitorEvaluations)).setter(ListMonitorEvaluationsResponse.setter(Builder::predictorMonitorEvaluations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PredictorMonitorEvaluations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PredictorMonitorEvaluation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, PREDICTOR_MONITOR_EVALUATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("NextToken", NEXT_TOKEN_FIELD);
            this.put("PredictorMonitorEvaluations", PREDICTOR_MONITOR_EVALUATIONS_FIELD);
        }
    });
    private final String nextToken;
    private final List<PredictorMonitorEvaluation> predictorMonitorEvaluations;

    private ListMonitorEvaluationsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.predictorMonitorEvaluations = builder.predictorMonitorEvaluations;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasPredictorMonitorEvaluations() {
        return this.predictorMonitorEvaluations != null && !(this.predictorMonitorEvaluations instanceof SdkAutoConstructList);
    }

    public final List<PredictorMonitorEvaluation> predictorMonitorEvaluations() {
        return this.predictorMonitorEvaluations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPredictorMonitorEvaluations() ? this.predictorMonitorEvaluations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMonitorEvaluationsResponse)) {
            return false;
        }
        ListMonitorEvaluationsResponse other = (ListMonitorEvaluationsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasPredictorMonitorEvaluations() == other.hasPredictorMonitorEvaluations() && Objects.equals(this.predictorMonitorEvaluations(), other.predictorMonitorEvaluations());
    }

    public final String toString() {
        return ToString.builder((String)"ListMonitorEvaluationsResponse").add("NextToken", (Object)this.nextToken()).add("PredictorMonitorEvaluations", this.hasPredictorMonitorEvaluations() ? this.predictorMonitorEvaluations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "PredictorMonitorEvaluations": {
                return Optional.ofNullable(clazz.cast(this.predictorMonitorEvaluations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListMonitorEvaluationsResponse, T> g) {
        return obj -> g.apply((ListMonitorEvaluationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ForecastResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<PredictorMonitorEvaluation> predictorMonitorEvaluations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListMonitorEvaluationsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.predictorMonitorEvaluations(model.predictorMonitorEvaluations);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<PredictorMonitorEvaluation.Builder> getPredictorMonitorEvaluations() {
            List<PredictorMonitorEvaluation.Builder> result = PredictorMonitorEvaluationsCopier.copyToBuilder(this.predictorMonitorEvaluations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPredictorMonitorEvaluations(Collection<PredictorMonitorEvaluation.BuilderImpl> predictorMonitorEvaluations) {
            this.predictorMonitorEvaluations = PredictorMonitorEvaluationsCopier.copyFromBuilder(predictorMonitorEvaluations);
        }

        @Override
        public final Builder predictorMonitorEvaluations(Collection<PredictorMonitorEvaluation> predictorMonitorEvaluations) {
            this.predictorMonitorEvaluations = PredictorMonitorEvaluationsCopier.copy(predictorMonitorEvaluations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder predictorMonitorEvaluations(PredictorMonitorEvaluation ... predictorMonitorEvaluations) {
            this.predictorMonitorEvaluations(Arrays.asList(predictorMonitorEvaluations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder predictorMonitorEvaluations(Consumer<PredictorMonitorEvaluation.Builder> ... predictorMonitorEvaluations) {
            this.predictorMonitorEvaluations(Stream.of(predictorMonitorEvaluations).map(c -> (PredictorMonitorEvaluation)((PredictorMonitorEvaluation.Builder)PredictorMonitorEvaluation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListMonitorEvaluationsResponse build() {
            return new ListMonitorEvaluationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ForecastResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListMonitorEvaluationsResponse> {
        public Builder nextToken(String var1);

        public Builder predictorMonitorEvaluations(Collection<PredictorMonitorEvaluation> var1);

        public Builder predictorMonitorEvaluations(PredictorMonitorEvaluation ... var1);

        public Builder predictorMonitorEvaluations(Consumer<PredictorMonitorEvaluation.Builder> ... var1);
    }
}

