/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.forecast.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.forecast.model.ArnListCopier;
import software.amazon.awssdk.services.forecast.model.ForecastRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateDatasetGroupRequest
extends ForecastRequest
implements ToCopyableBuilder<Builder, UpdateDatasetGroupRequest> {
    private static final SdkField<String> DATASET_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatasetGroupArn").getter(UpdateDatasetGroupRequest.getter(UpdateDatasetGroupRequest::datasetGroupArn)).setter(UpdateDatasetGroupRequest.setter(Builder::datasetGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetGroupArn").build()}).build();
    private static final SdkField<List<String>> DATASET_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DatasetArns").getter(UpdateDatasetGroupRequest.getter(UpdateDatasetGroupRequest::datasetArns)).setter(UpdateDatasetGroupRequest.setter(Builder::datasetArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASET_GROUP_ARN_FIELD, DATASET_ARNS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DatasetGroupArn", DATASET_GROUP_ARN_FIELD);
            this.put("DatasetArns", DATASET_ARNS_FIELD);
        }
    });
    private final String datasetGroupArn;
    private final List<String> datasetArns;

    private UpdateDatasetGroupRequest(BuilderImpl builder) {
        super(builder);
        this.datasetGroupArn = builder.datasetGroupArn;
        this.datasetArns = builder.datasetArns;
    }

    public final String datasetGroupArn() {
        return this.datasetGroupArn;
    }

    public final boolean hasDatasetArns() {
        return this.datasetArns != null && !(this.datasetArns instanceof SdkAutoConstructList);
    }

    public final List<String> datasetArns() {
        return this.datasetArns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDatasetArns() ? this.datasetArns() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDatasetGroupRequest)) {
            return false;
        }
        UpdateDatasetGroupRequest other = (UpdateDatasetGroupRequest)((Object)obj);
        return Objects.equals(this.datasetGroupArn(), other.datasetGroupArn()) && this.hasDatasetArns() == other.hasDatasetArns() && Objects.equals(this.datasetArns(), other.datasetArns());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateDatasetGroupRequest").add("DatasetGroupArn", (Object)this.datasetGroupArn()).add("DatasetArns", this.hasDatasetArns() ? this.datasetArns() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DatasetGroupArn": {
                return Optional.ofNullable(clazz.cast(this.datasetGroupArn()));
            }
            case "DatasetArns": {
                return Optional.ofNullable(clazz.cast(this.datasetArns()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDatasetGroupRequest, T> g) {
        return obj -> g.apply((UpdateDatasetGroupRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ForecastRequest.BuilderImpl
    implements Builder {
        private String datasetGroupArn;
        private List<String> datasetArns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDatasetGroupRequest model) {
            super(model);
            this.datasetGroupArn(model.datasetGroupArn);
            this.datasetArns(model.datasetArns);
        }

        public final String getDatasetGroupArn() {
            return this.datasetGroupArn;
        }

        public final void setDatasetGroupArn(String datasetGroupArn) {
            this.datasetGroupArn = datasetGroupArn;
        }

        @Override
        public final Builder datasetGroupArn(String datasetGroupArn) {
            this.datasetGroupArn = datasetGroupArn;
            return this;
        }

        public final Collection<String> getDatasetArns() {
            if (this.datasetArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.datasetArns;
        }

        public final void setDatasetArns(Collection<String> datasetArns) {
            this.datasetArns = ArnListCopier.copy(datasetArns);
        }

        @Override
        public final Builder datasetArns(Collection<String> datasetArns) {
            this.datasetArns = ArnListCopier.copy(datasetArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder datasetArns(String ... datasetArns) {
            this.datasetArns(Arrays.asList(datasetArns));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDatasetGroupRequest build() {
            return new UpdateDatasetGroupRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ForecastRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateDatasetGroupRequest> {
        public Builder datasetGroupArn(String var1);

        public Builder datasetArns(Collection<String> var1);

        public Builder datasetArns(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

