/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.forecast.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.forecast.ForecastAsyncClient;
import software.amazon.awssdk.services.forecast.internal.UserAgentUtils;
import software.amazon.awssdk.services.forecast.model.DatasetGroupSummary;
import software.amazon.awssdk.services.forecast.model.ListDatasetGroupsRequest;
import software.amazon.awssdk.services.forecast.model.ListDatasetGroupsResponse;

public class ListDatasetGroupsPublisher
implements SdkPublisher<ListDatasetGroupsResponse> {
    private final ForecastAsyncClient client;
    private final ListDatasetGroupsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDatasetGroupsPublisher(ForecastAsyncClient client, ListDatasetGroupsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDatasetGroupsPublisher(ForecastAsyncClient client, ListDatasetGroupsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDatasetGroupsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDatasetGroupsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DatasetGroupSummary> datasetGroups() {
        Function<ListDatasetGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.datasetGroups() != null) {
                return response.datasetGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListDatasetGroupsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListDatasetGroupsResponseFetcher
    implements AsyncPageFetcher<ListDatasetGroupsResponse> {
        private ListDatasetGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListDatasetGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListDatasetGroupsResponse> nextPage(ListDatasetGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListDatasetGroupsPublisher.this.client.listDatasetGroups(ListDatasetGroupsPublisher.this.firstRequest);
            }
            return ListDatasetGroupsPublisher.this.client.listDatasetGroups((ListDatasetGroupsRequest)((Object)ListDatasetGroupsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

