/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.forecast.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.forecast.model.BaselineMetric;
import software.amazon.awssdk.services.forecast.model.BaselineMetricsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PredictorBaseline
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PredictorBaseline> {
    private static final SdkField<List<BaselineMetric>> BASELINE_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("BaselineMetrics").getter(PredictorBaseline.getter(PredictorBaseline::baselineMetrics)).setter(PredictorBaseline.setter(Builder::baselineMetrics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaselineMetrics").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BaselineMetric::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BASELINE_METRICS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<BaselineMetric> baselineMetrics;

    private PredictorBaseline(BuilderImpl builder) {
        this.baselineMetrics = builder.baselineMetrics;
    }

    public final boolean hasBaselineMetrics() {
        return this.baselineMetrics != null && !(this.baselineMetrics instanceof SdkAutoConstructList);
    }

    public final List<BaselineMetric> baselineMetrics() {
        return this.baselineMetrics;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBaselineMetrics() ? this.baselineMetrics() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PredictorBaseline)) {
            return false;
        }
        PredictorBaseline other = (PredictorBaseline)obj;
        return this.hasBaselineMetrics() == other.hasBaselineMetrics() && Objects.equals(this.baselineMetrics(), other.baselineMetrics());
    }

    public final String toString() {
        return ToString.builder((String)"PredictorBaseline").add("BaselineMetrics", this.hasBaselineMetrics() ? this.baselineMetrics() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BaselineMetrics": {
                return Optional.ofNullable(clazz.cast(this.baselineMetrics()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PredictorBaseline, T> g) {
        return obj -> g.apply((PredictorBaseline)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<BaselineMetric> baselineMetrics = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PredictorBaseline model) {
            this.baselineMetrics(model.baselineMetrics);
        }

        public final List<BaselineMetric.Builder> getBaselineMetrics() {
            List<BaselineMetric.Builder> result = BaselineMetricsCopier.copyToBuilder(this.baselineMetrics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBaselineMetrics(Collection<BaselineMetric.BuilderImpl> baselineMetrics) {
            this.baselineMetrics = BaselineMetricsCopier.copyFromBuilder(baselineMetrics);
        }

        @Override
        public final Builder baselineMetrics(Collection<BaselineMetric> baselineMetrics) {
            this.baselineMetrics = BaselineMetricsCopier.copy(baselineMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder baselineMetrics(BaselineMetric ... baselineMetrics) {
            this.baselineMetrics(Arrays.asList(baselineMetrics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder baselineMetrics(Consumer<BaselineMetric.Builder> ... baselineMetrics) {
            this.baselineMetrics(Stream.of(baselineMetrics).map(c -> (BaselineMetric)((BaselineMetric.Builder)BaselineMetric.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public PredictorBaseline build() {
            return new PredictorBaseline(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PredictorBaseline> {
        public Builder baselineMetrics(Collection<BaselineMetric> var1);

        public Builder baselineMetrics(BaselineMetric ... var1);

        public Builder baselineMetrics(Consumer<BaselineMetric.Builder> ... var1);
    }
}

