/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.forecast.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.forecast.ForecastClient;
import software.amazon.awssdk.services.forecast.internal.UserAgentUtils;
import software.amazon.awssdk.services.forecast.model.DatasetGroupSummary;
import software.amazon.awssdk.services.forecast.model.ListDatasetGroupsRequest;
import software.amazon.awssdk.services.forecast.model.ListDatasetGroupsResponse;

public class ListDatasetGroupsIterable
implements SdkIterable<ListDatasetGroupsResponse> {
    private final ForecastClient client;
    private final ListDatasetGroupsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDatasetGroupsIterable(ForecastClient client, ListDatasetGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListDatasetGroupsResponseFetcher();
    }

    public Iterator<ListDatasetGroupsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DatasetGroupSummary> datasetGroups() {
        Function<ListDatasetGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.datasetGroups() != null) {
                return response.datasetGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListDatasetGroupsResponseFetcher
    implements SyncPageFetcher<ListDatasetGroupsResponse> {
        private ListDatasetGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListDatasetGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDatasetGroupsResponse nextPage(ListDatasetGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListDatasetGroupsIterable.this.client.listDatasetGroups(ListDatasetGroupsIterable.this.firstRequest);
            }
            return ListDatasetGroupsIterable.this.client.listDatasetGroups((ListDatasetGroupsRequest)((Object)ListDatasetGroupsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

