/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.forecast.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides detailed error metrics to evaluate the performance of a predictor. This object is part of the <a>Metrics</a>
 * object.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ErrorMetric implements SdkPojo, Serializable, ToCopyableBuilder<ErrorMetric.Builder, ErrorMetric> {
    private static final SdkField<String> FORECAST_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ForecastType").getter(getter(ErrorMetric::forecastType)).setter(setter(Builder::forecastType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForecastType").build()).build();

    private static final SdkField<Double> WAPE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("WAPE")
            .getter(getter(ErrorMetric::wape)).setter(setter(Builder::wape))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WAPE").build()).build();

    private static final SdkField<Double> RMSE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("RMSE")
            .getter(getter(ErrorMetric::rmse)).setter(setter(Builder::rmse))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RMSE").build()).build();

    private static final SdkField<Double> MASE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("MASE")
            .getter(getter(ErrorMetric::mase)).setter(setter(Builder::mase))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MASE").build()).build();

    private static final SdkField<Double> MAPE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("MAPE")
            .getter(getter(ErrorMetric::mape)).setter(setter(Builder::mape))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MAPE").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FORECAST_TYPE_FIELD,
            WAPE_FIELD, RMSE_FIELD, MASE_FIELD, MAPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String forecastType;

    private final Double wape;

    private final Double rmse;

    private final Double mase;

    private final Double mape;

    private ErrorMetric(BuilderImpl builder) {
        this.forecastType = builder.forecastType;
        this.wape = builder.wape;
        this.rmse = builder.rmse;
        this.mase = builder.mase;
        this.mape = builder.mape;
    }

    /**
     * <p>
     * The Forecast type used to compute WAPE, MAPE, MASE, and RMSE.
     * </p>
     * 
     * @return The Forecast type used to compute WAPE, MAPE, MASE, and RMSE.
     */
    public final String forecastType() {
        return forecastType;
    }

    /**
     * <p>
     * The weighted absolute percentage error (WAPE).
     * </p>
     * 
     * @return The weighted absolute percentage error (WAPE).
     */
    public final Double wape() {
        return wape;
    }

    /**
     * <p>
     * The root-mean-square error (RMSE).
     * </p>
     * 
     * @return The root-mean-square error (RMSE).
     */
    public final Double rmse() {
        return rmse;
    }

    /**
     * <p>
     * The Mean Absolute Scaled Error (MASE)
     * </p>
     * 
     * @return The Mean Absolute Scaled Error (MASE)
     */
    public final Double mase() {
        return mase;
    }

    /**
     * <p>
     * The Mean Absolute Percentage Error (MAPE)
     * </p>
     * 
     * @return The Mean Absolute Percentage Error (MAPE)
     */
    public final Double mape() {
        return mape;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(forecastType());
        hashCode = 31 * hashCode + Objects.hashCode(wape());
        hashCode = 31 * hashCode + Objects.hashCode(rmse());
        hashCode = 31 * hashCode + Objects.hashCode(mase());
        hashCode = 31 * hashCode + Objects.hashCode(mape());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ErrorMetric)) {
            return false;
        }
        ErrorMetric other = (ErrorMetric) obj;
        return Objects.equals(forecastType(), other.forecastType()) && Objects.equals(wape(), other.wape())
                && Objects.equals(rmse(), other.rmse()) && Objects.equals(mase(), other.mase())
                && Objects.equals(mape(), other.mape());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ErrorMetric").add("ForecastType", forecastType()).add("WAPE", wape()).add("RMSE", rmse())
                .add("MASE", mase()).add("MAPE", mape()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ForecastType":
            return Optional.ofNullable(clazz.cast(forecastType()));
        case "WAPE":
            return Optional.ofNullable(clazz.cast(wape()));
        case "RMSE":
            return Optional.ofNullable(clazz.cast(rmse()));
        case "MASE":
            return Optional.ofNullable(clazz.cast(mase()));
        case "MAPE":
            return Optional.ofNullable(clazz.cast(mape()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ErrorMetric, T> g) {
        return obj -> g.apply((ErrorMetric) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ErrorMetric> {
        /**
         * <p>
         * The Forecast type used to compute WAPE, MAPE, MASE, and RMSE.
         * </p>
         * 
         * @param forecastType
         *        The Forecast type used to compute WAPE, MAPE, MASE, and RMSE.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forecastType(String forecastType);

        /**
         * <p>
         * The weighted absolute percentage error (WAPE).
         * </p>
         * 
         * @param wape
         *        The weighted absolute percentage error (WAPE).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder wape(Double wape);

        /**
         * <p>
         * The root-mean-square error (RMSE).
         * </p>
         * 
         * @param rmse
         *        The root-mean-square error (RMSE).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rmse(Double rmse);

        /**
         * <p>
         * The Mean Absolute Scaled Error (MASE)
         * </p>
         * 
         * @param mase
         *        The Mean Absolute Scaled Error (MASE)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mase(Double mase);

        /**
         * <p>
         * The Mean Absolute Percentage Error (MAPE)
         * </p>
         * 
         * @param mape
         *        The Mean Absolute Percentage Error (MAPE)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mape(Double mape);
    }

    static final class BuilderImpl implements Builder {
        private String forecastType;

        private Double wape;

        private Double rmse;

        private Double mase;

        private Double mape;

        private BuilderImpl() {
        }

        private BuilderImpl(ErrorMetric model) {
            forecastType(model.forecastType);
            wape(model.wape);
            rmse(model.rmse);
            mase(model.mase);
            mape(model.mape);
        }

        public final String getForecastType() {
            return forecastType;
        }

        public final void setForecastType(String forecastType) {
            this.forecastType = forecastType;
        }

        @Override
        public final Builder forecastType(String forecastType) {
            this.forecastType = forecastType;
            return this;
        }

        public final Double getWape() {
            return wape;
        }

        public final void setWape(Double wape) {
            this.wape = wape;
        }

        @Override
        public final Builder wape(Double wape) {
            this.wape = wape;
            return this;
        }

        public final Double getRmse() {
            return rmse;
        }

        public final void setRmse(Double rmse) {
            this.rmse = rmse;
        }

        @Override
        public final Builder rmse(Double rmse) {
            this.rmse = rmse;
            return this;
        }

        public final Double getMase() {
            return mase;
        }

        public final void setMase(Double mase) {
            this.mase = mase;
        }

        @Override
        public final Builder mase(Double mase) {
            this.mase = mase;
            return this;
        }

        public final Double getMape() {
            return mape;
        }

        public final void setMape(Double mape) {
            this.mape = mape;
        }

        @Override
        public final Builder mape(Double mape) {
            this.mape = mape;
            return this;
        }

        @Override
        public ErrorMetric build() {
            return new ErrorMetric(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
