/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.forecast.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.forecast.model.Action;
import software.amazon.awssdk.services.forecast.model.TimeSeriesCondition;
import software.amazon.awssdk.services.forecast.model.TimeSeriesConditionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TimeSeriesTransformation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TimeSeriesTransformation> {
    private static final SdkField<Action> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Action").getter(TimeSeriesTransformation.getter(TimeSeriesTransformation::action)).setter(TimeSeriesTransformation.setter(Builder::action)).constructor(Action::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()}).build();
    private static final SdkField<List<TimeSeriesCondition>> TIME_SERIES_CONDITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TimeSeriesConditions").getter(TimeSeriesTransformation.getter(TimeSeriesTransformation::timeSeriesConditions)).setter(TimeSeriesTransformation.setter(Builder::timeSeriesConditions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeSeriesConditions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TimeSeriesCondition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD, TIME_SERIES_CONDITIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Action action;
    private final List<TimeSeriesCondition> timeSeriesConditions;

    private TimeSeriesTransformation(BuilderImpl builder) {
        this.action = builder.action;
        this.timeSeriesConditions = builder.timeSeriesConditions;
    }

    public final Action action() {
        return this.action;
    }

    public final boolean hasTimeSeriesConditions() {
        return this.timeSeriesConditions != null && !(this.timeSeriesConditions instanceof SdkAutoConstructList);
    }

    public final List<TimeSeriesCondition> timeSeriesConditions() {
        return this.timeSeriesConditions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.action());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTimeSeriesConditions() ? this.timeSeriesConditions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimeSeriesTransformation)) {
            return false;
        }
        TimeSeriesTransformation other = (TimeSeriesTransformation)obj;
        return Objects.equals(this.action(), other.action()) && this.hasTimeSeriesConditions() == other.hasTimeSeriesConditions() && Objects.equals(this.timeSeriesConditions(), other.timeSeriesConditions());
    }

    public final String toString() {
        return ToString.builder((String)"TimeSeriesTransformation").add("Action", (Object)this.action()).add("TimeSeriesConditions", this.hasTimeSeriesConditions() ? this.timeSeriesConditions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Action": {
                return Optional.ofNullable(clazz.cast(this.action()));
            }
            case "TimeSeriesConditions": {
                return Optional.ofNullable(clazz.cast(this.timeSeriesConditions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TimeSeriesTransformation, T> g) {
        return obj -> g.apply((TimeSeriesTransformation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Action action;
        private List<TimeSeriesCondition> timeSeriesConditions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TimeSeriesTransformation model) {
            this.action(model.action);
            this.timeSeriesConditions(model.timeSeriesConditions);
        }

        public final Action.Builder getAction() {
            return this.action != null ? this.action.toBuilder() : null;
        }

        public final void setAction(Action.BuilderImpl action) {
            this.action = action != null ? action.build() : null;
        }

        @Override
        public final Builder action(Action action) {
            this.action = action;
            return this;
        }

        public final List<TimeSeriesCondition.Builder> getTimeSeriesConditions() {
            List<TimeSeriesCondition.Builder> result = TimeSeriesConditionsCopier.copyToBuilder(this.timeSeriesConditions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTimeSeriesConditions(Collection<TimeSeriesCondition.BuilderImpl> timeSeriesConditions) {
            this.timeSeriesConditions = TimeSeriesConditionsCopier.copyFromBuilder(timeSeriesConditions);
        }

        @Override
        public final Builder timeSeriesConditions(Collection<TimeSeriesCondition> timeSeriesConditions) {
            this.timeSeriesConditions = TimeSeriesConditionsCopier.copy(timeSeriesConditions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder timeSeriesConditions(TimeSeriesCondition ... timeSeriesConditions) {
            this.timeSeriesConditions(Arrays.asList(timeSeriesConditions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder timeSeriesConditions(Consumer<TimeSeriesCondition.Builder> ... timeSeriesConditions) {
            this.timeSeriesConditions(Stream.of(timeSeriesConditions).map(c -> (TimeSeriesCondition)((TimeSeriesCondition.Builder)TimeSeriesCondition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public TimeSeriesTransformation build() {
            return new TimeSeriesTransformation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TimeSeriesTransformation> {
        public Builder action(Action var1);

        default public Builder action(Consumer<Action.Builder> action) {
            return this.action((Action)((Action.Builder)Action.builder().applyMutation(action)).build());
        }

        public Builder timeSeriesConditions(Collection<TimeSeriesCondition> var1);

        public Builder timeSeriesConditions(TimeSeriesCondition ... var1);

        public Builder timeSeriesConditions(Consumer<TimeSeriesCondition.Builder> ... var1);
    }
}

