/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.forecast.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.forecast.model.TimePointGranularity;
import software.amazon.awssdk.services.forecast.model.TimeSeriesGranularity;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExplainabilityConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExplainabilityConfig> {
    private static final SdkField<String> TIME_SERIES_GRANULARITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TimeSeriesGranularity").getter(ExplainabilityConfig.getter(ExplainabilityConfig::timeSeriesGranularityAsString)).setter(ExplainabilityConfig.setter(Builder::timeSeriesGranularity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeSeriesGranularity").build()}).build();
    private static final SdkField<String> TIME_POINT_GRANULARITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TimePointGranularity").getter(ExplainabilityConfig.getter(ExplainabilityConfig::timePointGranularityAsString)).setter(ExplainabilityConfig.setter(Builder::timePointGranularity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimePointGranularity").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIME_SERIES_GRANULARITY_FIELD, TIME_POINT_GRANULARITY_FIELD));
    private static final long serialVersionUID = 1L;
    private final String timeSeriesGranularity;
    private final String timePointGranularity;

    private ExplainabilityConfig(BuilderImpl builder) {
        this.timeSeriesGranularity = builder.timeSeriesGranularity;
        this.timePointGranularity = builder.timePointGranularity;
    }

    public final TimeSeriesGranularity timeSeriesGranularity() {
        return TimeSeriesGranularity.fromValue(this.timeSeriesGranularity);
    }

    public final String timeSeriesGranularityAsString() {
        return this.timeSeriesGranularity;
    }

    public final TimePointGranularity timePointGranularity() {
        return TimePointGranularity.fromValue(this.timePointGranularity);
    }

    public final String timePointGranularityAsString() {
        return this.timePointGranularity;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.timeSeriesGranularityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.timePointGranularityAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExplainabilityConfig)) {
            return false;
        }
        ExplainabilityConfig other = (ExplainabilityConfig)obj;
        return Objects.equals(this.timeSeriesGranularityAsString(), other.timeSeriesGranularityAsString()) && Objects.equals(this.timePointGranularityAsString(), other.timePointGranularityAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ExplainabilityConfig").add("TimeSeriesGranularity", (Object)this.timeSeriesGranularityAsString()).add("TimePointGranularity", (Object)this.timePointGranularityAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TimeSeriesGranularity": {
                return Optional.ofNullable(clazz.cast(this.timeSeriesGranularityAsString()));
            }
            case "TimePointGranularity": {
                return Optional.ofNullable(clazz.cast(this.timePointGranularityAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExplainabilityConfig, T> g) {
        return obj -> g.apply((ExplainabilityConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String timeSeriesGranularity;
        private String timePointGranularity;

        private BuilderImpl() {
        }

        private BuilderImpl(ExplainabilityConfig model) {
            this.timeSeriesGranularity(model.timeSeriesGranularity);
            this.timePointGranularity(model.timePointGranularity);
        }

        public final String getTimeSeriesGranularity() {
            return this.timeSeriesGranularity;
        }

        public final void setTimeSeriesGranularity(String timeSeriesGranularity) {
            this.timeSeriesGranularity = timeSeriesGranularity;
        }

        @Override
        @Transient
        public final Builder timeSeriesGranularity(String timeSeriesGranularity) {
            this.timeSeriesGranularity = timeSeriesGranularity;
            return this;
        }

        @Override
        @Transient
        public final Builder timeSeriesGranularity(TimeSeriesGranularity timeSeriesGranularity) {
            this.timeSeriesGranularity(timeSeriesGranularity == null ? null : timeSeriesGranularity.toString());
            return this;
        }

        public final String getTimePointGranularity() {
            return this.timePointGranularity;
        }

        public final void setTimePointGranularity(String timePointGranularity) {
            this.timePointGranularity = timePointGranularity;
        }

        @Override
        @Transient
        public final Builder timePointGranularity(String timePointGranularity) {
            this.timePointGranularity = timePointGranularity;
            return this;
        }

        @Override
        @Transient
        public final Builder timePointGranularity(TimePointGranularity timePointGranularity) {
            this.timePointGranularity(timePointGranularity == null ? null : timePointGranularity.toString());
            return this;
        }

        public ExplainabilityConfig build() {
            return new ExplainabilityConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExplainabilityConfig> {
        public Builder timeSeriesGranularity(String var1);

        public Builder timeSeriesGranularity(TimeSeriesGranularity var1);

        public Builder timePointGranularity(String var1);

        public Builder timePointGranularity(TimePointGranularity var1);
    }
}

