/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.forecast.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.forecast.model.Featurization;
import software.amazon.awssdk.services.forecast.model.FeaturizationsCopier;
import software.amazon.awssdk.services.forecast.model.ForecastDimensionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FeaturizationConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FeaturizationConfig> {
    private static final SdkField<String> FORECAST_FREQUENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ForecastFrequency").getter(FeaturizationConfig.getter(FeaturizationConfig::forecastFrequency)).setter(FeaturizationConfig.setter(Builder::forecastFrequency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForecastFrequency").build()}).build();
    private static final SdkField<List<String>> FORECAST_DIMENSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ForecastDimensions").getter(FeaturizationConfig.getter(FeaturizationConfig::forecastDimensions)).setter(FeaturizationConfig.setter(Builder::forecastDimensions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForecastDimensions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Featurization>> FEATURIZATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Featurizations").getter(FeaturizationConfig.getter(FeaturizationConfig::featurizations)).setter(FeaturizationConfig.setter(Builder::featurizations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Featurizations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Featurization::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FORECAST_FREQUENCY_FIELD, FORECAST_DIMENSIONS_FIELD, FEATURIZATIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String forecastFrequency;
    private final List<String> forecastDimensions;
    private final List<Featurization> featurizations;

    private FeaturizationConfig(BuilderImpl builder) {
        this.forecastFrequency = builder.forecastFrequency;
        this.forecastDimensions = builder.forecastDimensions;
        this.featurizations = builder.featurizations;
    }

    public String forecastFrequency() {
        return this.forecastFrequency;
    }

    public boolean hasForecastDimensions() {
        return this.forecastDimensions != null && !(this.forecastDimensions instanceof SdkAutoConstructList);
    }

    public List<String> forecastDimensions() {
        return this.forecastDimensions;
    }

    public boolean hasFeaturizations() {
        return this.featurizations != null && !(this.featurizations instanceof SdkAutoConstructList);
    }

    public List<Featurization> featurizations() {
        return this.featurizations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.forecastFrequency());
        hashCode = 31 * hashCode + Objects.hashCode(this.forecastDimensions());
        hashCode = 31 * hashCode + Objects.hashCode(this.featurizations());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FeaturizationConfig)) {
            return false;
        }
        FeaturizationConfig other = (FeaturizationConfig)obj;
        return Objects.equals(this.forecastFrequency(), other.forecastFrequency()) && Objects.equals(this.forecastDimensions(), other.forecastDimensions()) && Objects.equals(this.featurizations(), other.featurizations());
    }

    public String toString() {
        return ToString.builder((String)"FeaturizationConfig").add("ForecastFrequency", (Object)this.forecastFrequency()).add("ForecastDimensions", this.forecastDimensions()).add("Featurizations", this.featurizations()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ForecastFrequency": {
                return Optional.ofNullable(clazz.cast(this.forecastFrequency()));
            }
            case "ForecastDimensions": {
                return Optional.ofNullable(clazz.cast(this.forecastDimensions()));
            }
            case "Featurizations": {
                return Optional.ofNullable(clazz.cast(this.featurizations()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FeaturizationConfig, T> g) {
        return obj -> g.apply((FeaturizationConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String forecastFrequency;
        private List<String> forecastDimensions = DefaultSdkAutoConstructList.getInstance();
        private List<Featurization> featurizations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FeaturizationConfig model) {
            this.forecastFrequency(model.forecastFrequency);
            this.forecastDimensions(model.forecastDimensions);
            this.featurizations(model.featurizations);
        }

        public final String getForecastFrequency() {
            return this.forecastFrequency;
        }

        @Override
        public final Builder forecastFrequency(String forecastFrequency) {
            this.forecastFrequency = forecastFrequency;
            return this;
        }

        public final void setForecastFrequency(String forecastFrequency) {
            this.forecastFrequency = forecastFrequency;
        }

        public final Collection<String> getForecastDimensions() {
            return this.forecastDimensions;
        }

        @Override
        public final Builder forecastDimensions(Collection<String> forecastDimensions) {
            this.forecastDimensions = ForecastDimensionsCopier.copy(forecastDimensions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder forecastDimensions(String ... forecastDimensions) {
            this.forecastDimensions(Arrays.asList(forecastDimensions));
            return this;
        }

        public final void setForecastDimensions(Collection<String> forecastDimensions) {
            this.forecastDimensions = ForecastDimensionsCopier.copy(forecastDimensions);
        }

        public final Collection<Featurization.Builder> getFeaturizations() {
            return this.featurizations != null ? (Collection)this.featurizations.stream().map(Featurization::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder featurizations(Collection<Featurization> featurizations) {
            this.featurizations = FeaturizationsCopier.copy(featurizations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder featurizations(Featurization ... featurizations) {
            this.featurizations(Arrays.asList(featurizations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder featurizations(Consumer<Featurization.Builder> ... featurizations) {
            this.featurizations(Stream.of(featurizations).map(c -> (Featurization)((Featurization.Builder)Featurization.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFeaturizations(Collection<Featurization.BuilderImpl> featurizations) {
            this.featurizations = FeaturizationsCopier.copyFromBuilder(featurizations);
        }

        public FeaturizationConfig build() {
            return new FeaturizationConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FeaturizationConfig> {
        public Builder forecastFrequency(String var1);

        public Builder forecastDimensions(Collection<String> var1);

        public Builder forecastDimensions(String ... var1);

        public Builder featurizations(Collection<Featurization> var1);

        public Builder featurizations(Featurization ... var1);

        public Builder featurizations(Consumer<Featurization.Builder> ... var1);
    }
}

