/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.forecast.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.forecast.model.DataDestination;
import software.amazon.awssdk.services.forecast.model.ForecastResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribePredictorBacktestExportJobResponse
extends ForecastResponse
implements ToCopyableBuilder<Builder, DescribePredictorBacktestExportJobResponse> {
    private static final SdkField<String> PREDICTOR_BACKTEST_EXPORT_JOB_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PredictorBacktestExportJobArn").getter(DescribePredictorBacktestExportJobResponse.getter(DescribePredictorBacktestExportJobResponse::predictorBacktestExportJobArn)).setter(DescribePredictorBacktestExportJobResponse.setter(Builder::predictorBacktestExportJobArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PredictorBacktestExportJobArn").build()}).build();
    private static final SdkField<String> PREDICTOR_BACKTEST_EXPORT_JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PredictorBacktestExportJobName").getter(DescribePredictorBacktestExportJobResponse.getter(DescribePredictorBacktestExportJobResponse::predictorBacktestExportJobName)).setter(DescribePredictorBacktestExportJobResponse.setter(Builder::predictorBacktestExportJobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PredictorBacktestExportJobName").build()}).build();
    private static final SdkField<String> PREDICTOR_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PredictorArn").getter(DescribePredictorBacktestExportJobResponse.getter(DescribePredictorBacktestExportJobResponse::predictorArn)).setter(DescribePredictorBacktestExportJobResponse.setter(Builder::predictorArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PredictorArn").build()}).build();
    private static final SdkField<DataDestination> DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Destination").getter(DescribePredictorBacktestExportJobResponse.getter(DescribePredictorBacktestExportJobResponse::destination)).setter(DescribePredictorBacktestExportJobResponse.setter(Builder::destination)).constructor(DataDestination::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Destination").build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Message").getter(DescribePredictorBacktestExportJobResponse.getter(DescribePredictorBacktestExportJobResponse::message)).setter(DescribePredictorBacktestExportJobResponse.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DescribePredictorBacktestExportJobResponse.getter(DescribePredictorBacktestExportJobResponse::status)).setter(DescribePredictorBacktestExportJobResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(DescribePredictorBacktestExportJobResponse.getter(DescribePredictorBacktestExportJobResponse::creationTime)).setter(DescribePredictorBacktestExportJobResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> LAST_MODIFICATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModificationTime").getter(DescribePredictorBacktestExportJobResponse.getter(DescribePredictorBacktestExportJobResponse::lastModificationTime)).setter(DescribePredictorBacktestExportJobResponse.setter(Builder::lastModificationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModificationTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PREDICTOR_BACKTEST_EXPORT_JOB_ARN_FIELD, PREDICTOR_BACKTEST_EXPORT_JOB_NAME_FIELD, PREDICTOR_ARN_FIELD, DESTINATION_FIELD, MESSAGE_FIELD, STATUS_FIELD, CREATION_TIME_FIELD, LAST_MODIFICATION_TIME_FIELD));
    private final String predictorBacktestExportJobArn;
    private final String predictorBacktestExportJobName;
    private final String predictorArn;
    private final DataDestination destination;
    private final String message;
    private final String status;
    private final Instant creationTime;
    private final Instant lastModificationTime;

    private DescribePredictorBacktestExportJobResponse(BuilderImpl builder) {
        super(builder);
        this.predictorBacktestExportJobArn = builder.predictorBacktestExportJobArn;
        this.predictorBacktestExportJobName = builder.predictorBacktestExportJobName;
        this.predictorArn = builder.predictorArn;
        this.destination = builder.destination;
        this.message = builder.message;
        this.status = builder.status;
        this.creationTime = builder.creationTime;
        this.lastModificationTime = builder.lastModificationTime;
    }

    public String predictorBacktestExportJobArn() {
        return this.predictorBacktestExportJobArn;
    }

    public String predictorBacktestExportJobName() {
        return this.predictorBacktestExportJobName;
    }

    public String predictorArn() {
        return this.predictorArn;
    }

    public DataDestination destination() {
        return this.destination;
    }

    public String message() {
        return this.message;
    }

    public String status() {
        return this.status;
    }

    public Instant creationTime() {
        return this.creationTime;
    }

    public Instant lastModificationTime() {
        return this.lastModificationTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.predictorBacktestExportJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.predictorBacktestExportJobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.predictorArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.destination());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModificationTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePredictorBacktestExportJobResponse)) {
            return false;
        }
        DescribePredictorBacktestExportJobResponse other = (DescribePredictorBacktestExportJobResponse)((Object)obj);
        return Objects.equals(this.predictorBacktestExportJobArn(), other.predictorBacktestExportJobArn()) && Objects.equals(this.predictorBacktestExportJobName(), other.predictorBacktestExportJobName()) && Objects.equals(this.predictorArn(), other.predictorArn()) && Objects.equals(this.destination(), other.destination()) && Objects.equals(this.message(), other.message()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastModificationTime(), other.lastModificationTime());
    }

    public String toString() {
        return ToString.builder((String)"DescribePredictorBacktestExportJobResponse").add("PredictorBacktestExportJobArn", (Object)this.predictorBacktestExportJobArn()).add("PredictorBacktestExportJobName", (Object)this.predictorBacktestExportJobName()).add("PredictorArn", (Object)this.predictorArn()).add("Destination", (Object)this.destination()).add("Message", (Object)this.message()).add("Status", (Object)this.status()).add("CreationTime", (Object)this.creationTime()).add("LastModificationTime", (Object)this.lastModificationTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PredictorBacktestExportJobArn": {
                return Optional.ofNullable(clazz.cast(this.predictorBacktestExportJobArn()));
            }
            case "PredictorBacktestExportJobName": {
                return Optional.ofNullable(clazz.cast(this.predictorBacktestExportJobName()));
            }
            case "PredictorArn": {
                return Optional.ofNullable(clazz.cast(this.predictorArn()));
            }
            case "Destination": {
                return Optional.ofNullable(clazz.cast(this.destination()));
            }
            case "Message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "LastModificationTime": {
                return Optional.ofNullable(clazz.cast(this.lastModificationTime()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribePredictorBacktestExportJobResponse, T> g) {
        return obj -> g.apply((DescribePredictorBacktestExportJobResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ForecastResponse.BuilderImpl
    implements Builder {
        private String predictorBacktestExportJobArn;
        private String predictorBacktestExportJobName;
        private String predictorArn;
        private DataDestination destination;
        private String message;
        private String status;
        private Instant creationTime;
        private Instant lastModificationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePredictorBacktestExportJobResponse model) {
            super(model);
            this.predictorBacktestExportJobArn(model.predictorBacktestExportJobArn);
            this.predictorBacktestExportJobName(model.predictorBacktestExportJobName);
            this.predictorArn(model.predictorArn);
            this.destination(model.destination);
            this.message(model.message);
            this.status(model.status);
            this.creationTime(model.creationTime);
            this.lastModificationTime(model.lastModificationTime);
        }

        public final String getPredictorBacktestExportJobArn() {
            return this.predictorBacktestExportJobArn;
        }

        @Override
        public final Builder predictorBacktestExportJobArn(String predictorBacktestExportJobArn) {
            this.predictorBacktestExportJobArn = predictorBacktestExportJobArn;
            return this;
        }

        public final void setPredictorBacktestExportJobArn(String predictorBacktestExportJobArn) {
            this.predictorBacktestExportJobArn = predictorBacktestExportJobArn;
        }

        public final String getPredictorBacktestExportJobName() {
            return this.predictorBacktestExportJobName;
        }

        @Override
        public final Builder predictorBacktestExportJobName(String predictorBacktestExportJobName) {
            this.predictorBacktestExportJobName = predictorBacktestExportJobName;
            return this;
        }

        public final void setPredictorBacktestExportJobName(String predictorBacktestExportJobName) {
            this.predictorBacktestExportJobName = predictorBacktestExportJobName;
        }

        public final String getPredictorArn() {
            return this.predictorArn;
        }

        @Override
        public final Builder predictorArn(String predictorArn) {
            this.predictorArn = predictorArn;
            return this;
        }

        public final void setPredictorArn(String predictorArn) {
            this.predictorArn = predictorArn;
        }

        public final DataDestination.Builder getDestination() {
            return this.destination != null ? this.destination.toBuilder() : null;
        }

        @Override
        public final Builder destination(DataDestination destination) {
            this.destination = destination;
            return this;
        }

        public final void setDestination(DataDestination.BuilderImpl destination) {
            this.destination = destination != null ? destination.build() : null;
        }

        public final String getMessage() {
            return this.message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getLastModificationTime() {
            return this.lastModificationTime;
        }

        @Override
        public final Builder lastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
            return this;
        }

        public final void setLastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
        }

        @Override
        public DescribePredictorBacktestExportJobResponse build() {
            return new DescribePredictorBacktestExportJobResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ForecastResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribePredictorBacktestExportJobResponse> {
        public Builder predictorBacktestExportJobArn(String var1);

        public Builder predictorBacktestExportJobName(String var1);

        public Builder predictorArn(String var1);

        public Builder destination(DataDestination var1);

        default public Builder destination(Consumer<DataDestination.Builder> destination) {
            return this.destination((DataDestination)((DataDestination.Builder)DataDestination.builder().applyMutation(destination)).build());
        }

        public Builder message(String var1);

        public Builder status(String var1);

        public Builder creationTime(Instant var1);

        public Builder lastModificationTime(Instant var1);
    }
}

