/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.forecast.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.forecast.model.DataDestination;
import software.amazon.awssdk.services.forecast.model.ForecastResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeForecastExportJobResponse
extends ForecastResponse
implements ToCopyableBuilder<Builder, DescribeForecastExportJobResponse> {
    private static final SdkField<String> FORECAST_EXPORT_JOB_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeForecastExportJobResponse.getter(DescribeForecastExportJobResponse::forecastExportJobArn)).setter(DescribeForecastExportJobResponse.setter(Builder::forecastExportJobArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForecastExportJobArn").build()}).build();
    private static final SdkField<String> FORECAST_EXPORT_JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeForecastExportJobResponse.getter(DescribeForecastExportJobResponse::forecastExportJobName)).setter(DescribeForecastExportJobResponse.setter(Builder::forecastExportJobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForecastExportJobName").build()}).build();
    private static final SdkField<String> FORECAST_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeForecastExportJobResponse.getter(DescribeForecastExportJobResponse::forecastArn)).setter(DescribeForecastExportJobResponse.setter(Builder::forecastArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForecastArn").build()}).build();
    private static final SdkField<DataDestination> DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DescribeForecastExportJobResponse.getter(DescribeForecastExportJobResponse::destination)).setter(DescribeForecastExportJobResponse.setter(Builder::destination)).constructor(DataDestination::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Destination").build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeForecastExportJobResponse.getter(DescribeForecastExportJobResponse::message)).setter(DescribeForecastExportJobResponse.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeForecastExportJobResponse.getter(DescribeForecastExportJobResponse::status)).setter(DescribeForecastExportJobResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(DescribeForecastExportJobResponse.getter(DescribeForecastExportJobResponse::creationTime)).setter(DescribeForecastExportJobResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> LAST_MODIFICATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(DescribeForecastExportJobResponse.getter(DescribeForecastExportJobResponse::lastModificationTime)).setter(DescribeForecastExportJobResponse.setter(Builder::lastModificationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModificationTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FORECAST_EXPORT_JOB_ARN_FIELD, FORECAST_EXPORT_JOB_NAME_FIELD, FORECAST_ARN_FIELD, DESTINATION_FIELD, MESSAGE_FIELD, STATUS_FIELD, CREATION_TIME_FIELD, LAST_MODIFICATION_TIME_FIELD));
    private final String forecastExportJobArn;
    private final String forecastExportJobName;
    private final String forecastArn;
    private final DataDestination destination;
    private final String message;
    private final String status;
    private final Instant creationTime;
    private final Instant lastModificationTime;

    private DescribeForecastExportJobResponse(BuilderImpl builder) {
        super(builder);
        this.forecastExportJobArn = builder.forecastExportJobArn;
        this.forecastExportJobName = builder.forecastExportJobName;
        this.forecastArn = builder.forecastArn;
        this.destination = builder.destination;
        this.message = builder.message;
        this.status = builder.status;
        this.creationTime = builder.creationTime;
        this.lastModificationTime = builder.lastModificationTime;
    }

    public String forecastExportJobArn() {
        return this.forecastExportJobArn;
    }

    public String forecastExportJobName() {
        return this.forecastExportJobName;
    }

    public String forecastArn() {
        return this.forecastArn;
    }

    public DataDestination destination() {
        return this.destination;
    }

    public String message() {
        return this.message;
    }

    public String status() {
        return this.status;
    }

    public Instant creationTime() {
        return this.creationTime;
    }

    public Instant lastModificationTime() {
        return this.lastModificationTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.forecastExportJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.forecastExportJobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.forecastArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.destination());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModificationTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeForecastExportJobResponse)) {
            return false;
        }
        DescribeForecastExportJobResponse other = (DescribeForecastExportJobResponse)((Object)obj);
        return Objects.equals(this.forecastExportJobArn(), other.forecastExportJobArn()) && Objects.equals(this.forecastExportJobName(), other.forecastExportJobName()) && Objects.equals(this.forecastArn(), other.forecastArn()) && Objects.equals(this.destination(), other.destination()) && Objects.equals(this.message(), other.message()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastModificationTime(), other.lastModificationTime());
    }

    public String toString() {
        return ToString.builder((String)"DescribeForecastExportJobResponse").add("ForecastExportJobArn", (Object)this.forecastExportJobArn()).add("ForecastExportJobName", (Object)this.forecastExportJobName()).add("ForecastArn", (Object)this.forecastArn()).add("Destination", (Object)this.destination()).add("Message", (Object)this.message()).add("Status", (Object)this.status()).add("CreationTime", (Object)this.creationTime()).add("LastModificationTime", (Object)this.lastModificationTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ForecastExportJobArn": {
                return Optional.ofNullable(clazz.cast(this.forecastExportJobArn()));
            }
            case "ForecastExportJobName": {
                return Optional.ofNullable(clazz.cast(this.forecastExportJobName()));
            }
            case "ForecastArn": {
                return Optional.ofNullable(clazz.cast(this.forecastArn()));
            }
            case "Destination": {
                return Optional.ofNullable(clazz.cast(this.destination()));
            }
            case "Message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "LastModificationTime": {
                return Optional.ofNullable(clazz.cast(this.lastModificationTime()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeForecastExportJobResponse, T> g) {
        return obj -> g.apply((DescribeForecastExportJobResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ForecastResponse.BuilderImpl
    implements Builder {
        private String forecastExportJobArn;
        private String forecastExportJobName;
        private String forecastArn;
        private DataDestination destination;
        private String message;
        private String status;
        private Instant creationTime;
        private Instant lastModificationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeForecastExportJobResponse model) {
            super(model);
            this.forecastExportJobArn(model.forecastExportJobArn);
            this.forecastExportJobName(model.forecastExportJobName);
            this.forecastArn(model.forecastArn);
            this.destination(model.destination);
            this.message(model.message);
            this.status(model.status);
            this.creationTime(model.creationTime);
            this.lastModificationTime(model.lastModificationTime);
        }

        public final String getForecastExportJobArn() {
            return this.forecastExportJobArn;
        }

        @Override
        public final Builder forecastExportJobArn(String forecastExportJobArn) {
            this.forecastExportJobArn = forecastExportJobArn;
            return this;
        }

        public final void setForecastExportJobArn(String forecastExportJobArn) {
            this.forecastExportJobArn = forecastExportJobArn;
        }

        public final String getForecastExportJobName() {
            return this.forecastExportJobName;
        }

        @Override
        public final Builder forecastExportJobName(String forecastExportJobName) {
            this.forecastExportJobName = forecastExportJobName;
            return this;
        }

        public final void setForecastExportJobName(String forecastExportJobName) {
            this.forecastExportJobName = forecastExportJobName;
        }

        public final String getForecastArn() {
            return this.forecastArn;
        }

        @Override
        public final Builder forecastArn(String forecastArn) {
            this.forecastArn = forecastArn;
            return this;
        }

        public final void setForecastArn(String forecastArn) {
            this.forecastArn = forecastArn;
        }

        public final DataDestination.Builder getDestination() {
            return this.destination != null ? this.destination.toBuilder() : null;
        }

        @Override
        public final Builder destination(DataDestination destination) {
            this.destination = destination;
            return this;
        }

        public final void setDestination(DataDestination.BuilderImpl destination) {
            this.destination = destination != null ? destination.build() : null;
        }

        public final String getMessage() {
            return this.message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getLastModificationTime() {
            return this.lastModificationTime;
        }

        @Override
        public final Builder lastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
            return this;
        }

        public final void setLastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
        }

        @Override
        public DescribeForecastExportJobResponse build() {
            return new DescribeForecastExportJobResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ForecastResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeForecastExportJobResponse> {
        public Builder forecastExportJobArn(String var1);

        public Builder forecastExportJobName(String var1);

        public Builder forecastArn(String var1);

        public Builder destination(DataDestination var1);

        default public Builder destination(Consumer<DataDestination.Builder> destination) {
            return this.destination((DataDestination)((DataDestination.Builder)DataDestination.builder().applyMutation(destination)).build());
        }

        public Builder message(String var1);

        public Builder status(String var1);

        public Builder creationTime(Instant var1);

        public Builder lastModificationTime(Instant var1);
    }
}

