/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.forecast.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum DatasetType {
    TARGET_TIME_SERIES("TARGET_TIME_SERIES"),
    RELATED_TIME_SERIES("RELATED_TIME_SERIES"),
    ITEM_METADATA("ITEM_METADATA"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private DatasetType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DatasetType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(DatasetType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DatasetType> knownValues() {
        return Stream.of(DatasetType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

