/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.forecast.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.forecast.ForecastAsyncClient;
import software.amazon.awssdk.services.forecast.model.ListPredictorsRequest;
import software.amazon.awssdk.services.forecast.model.ListPredictorsResponse;
import software.amazon.awssdk.services.forecast.model.PredictorSummary;

public class ListPredictorsPublisher
implements SdkPublisher<ListPredictorsResponse> {
    private final ForecastAsyncClient client;
    private final ListPredictorsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPredictorsPublisher(ForecastAsyncClient client, ListPredictorsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPredictorsPublisher(ForecastAsyncClient client, ListPredictorsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPredictorsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListPredictorsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<PredictorSummary> predictors() {
        Function<ListPredictorsResponse, Iterator> getIterator = response -> {
            if (response != null && response.predictors() != null) {
                return response.predictors().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListPredictorsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListPredictorsResponseFetcher
    implements AsyncPageFetcher<ListPredictorsResponse> {
        private ListPredictorsResponseFetcher() {
        }

        public boolean hasNextPage(ListPredictorsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListPredictorsResponse> nextPage(ListPredictorsResponse previousPage) {
            if (previousPage == null) {
                return ListPredictorsPublisher.this.client.listPredictors(ListPredictorsPublisher.this.firstRequest);
            }
            return ListPredictorsPublisher.this.client.listPredictors((ListPredictorsRequest)((Object)ListPredictorsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

