/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configures the firewall policy deployment model of Network Firewall. For information about Network Firewall
 * deployment models, see <a
 * href="https://docs.aws.amazon.com/network-firewall/latest/developerguide/architectures.html">Network Firewall example
 * architectures with routing</a> in the <i>Network Firewall Developer Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NetworkFirewallPolicy implements SdkPojo, Serializable,
        ToCopyableBuilder<NetworkFirewallPolicy.Builder, NetworkFirewallPolicy> {
    private static final SdkField<String> FIREWALL_DEPLOYMENT_MODEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FirewallDeploymentModel").getter(getter(NetworkFirewallPolicy::firewallDeploymentModelAsString))
            .setter(setter(Builder::firewallDeploymentModel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallDeploymentModel").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(FIREWALL_DEPLOYMENT_MODEL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String firewallDeploymentModel;

    private NetworkFirewallPolicy(BuilderImpl builder) {
        this.firewallDeploymentModel = builder.firewallDeploymentModel;
    }

    /**
     * <p>
     * Defines the deployment model to use for the firewall policy. To use a distributed model, set <a
     * href="https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_PolicyOption.html">PolicyOption</a> to
     * <code>NULL</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #firewallDeploymentModel} will return {@link FirewallDeploymentModel#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #firewallDeploymentModelAsString}.
     * </p>
     * 
     * @return Defines the deployment model to use for the firewall policy. To use a distributed model, set <a
     *         href="https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_PolicyOption.html">PolicyOption</a> to
     *         <code>NULL</code>.
     * @see FirewallDeploymentModel
     */
    public final FirewallDeploymentModel firewallDeploymentModel() {
        return FirewallDeploymentModel.fromValue(firewallDeploymentModel);
    }

    /**
     * <p>
     * Defines the deployment model to use for the firewall policy. To use a distributed model, set <a
     * href="https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_PolicyOption.html">PolicyOption</a> to
     * <code>NULL</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #firewallDeploymentModel} will return {@link FirewallDeploymentModel#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #firewallDeploymentModelAsString}.
     * </p>
     * 
     * @return Defines the deployment model to use for the firewall policy. To use a distributed model, set <a
     *         href="https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_PolicyOption.html">PolicyOption</a> to
     *         <code>NULL</code>.
     * @see FirewallDeploymentModel
     */
    public final String firewallDeploymentModelAsString() {
        return firewallDeploymentModel;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(firewallDeploymentModelAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkFirewallPolicy)) {
            return false;
        }
        NetworkFirewallPolicy other = (NetworkFirewallPolicy) obj;
        return Objects.equals(firewallDeploymentModelAsString(), other.firewallDeploymentModelAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NetworkFirewallPolicy").add("FirewallDeploymentModel", firewallDeploymentModelAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FirewallDeploymentModel":
            return Optional.ofNullable(clazz.cast(firewallDeploymentModelAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FirewallDeploymentModel", FIREWALL_DEPLOYMENT_MODEL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NetworkFirewallPolicy, T> g) {
        return obj -> g.apply((NetworkFirewallPolicy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NetworkFirewallPolicy> {
        /**
         * <p>
         * Defines the deployment model to use for the firewall policy. To use a distributed model, set <a
         * href="https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_PolicyOption.html">PolicyOption</a> to
         * <code>NULL</code>.
         * </p>
         * 
         * @param firewallDeploymentModel
         *        Defines the deployment model to use for the firewall policy. To use a distributed model, set <a
         *        href="https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_PolicyOption.html">PolicyOption</a>
         *        to <code>NULL</code>.
         * @see FirewallDeploymentModel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FirewallDeploymentModel
         */
        Builder firewallDeploymentModel(String firewallDeploymentModel);

        /**
         * <p>
         * Defines the deployment model to use for the firewall policy. To use a distributed model, set <a
         * href="https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_PolicyOption.html">PolicyOption</a> to
         * <code>NULL</code>.
         * </p>
         * 
         * @param firewallDeploymentModel
         *        Defines the deployment model to use for the firewall policy. To use a distributed model, set <a
         *        href="https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_PolicyOption.html">PolicyOption</a>
         *        to <code>NULL</code>.
         * @see FirewallDeploymentModel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FirewallDeploymentModel
         */
        Builder firewallDeploymentModel(FirewallDeploymentModel firewallDeploymentModel);
    }

    static final class BuilderImpl implements Builder {
        private String firewallDeploymentModel;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkFirewallPolicy model) {
            firewallDeploymentModel(model.firewallDeploymentModel);
        }

        public final String getFirewallDeploymentModel() {
            return firewallDeploymentModel;
        }

        public final void setFirewallDeploymentModel(String firewallDeploymentModel) {
            this.firewallDeploymentModel = firewallDeploymentModel;
        }

        @Override
        public final Builder firewallDeploymentModel(String firewallDeploymentModel) {
            this.firewallDeploymentModel = firewallDeploymentModel;
            return this;
        }

        @Override
        public final Builder firewallDeploymentModel(FirewallDeploymentModel firewallDeploymentModel) {
            this.firewallDeploymentModel(firewallDeploymentModel == null ? null : firewallDeploymentModel.toString());
            return this;
        }

        @Override
        public NetworkFirewallPolicy build() {
            return new NetworkFirewallPolicy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
