/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fms.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.fms.model.FmsRequest;
import software.amazon.awssdk.services.fms.model.IdentifierListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchAssociateResourceRequest
extends FmsRequest
implements ToCopyableBuilder<Builder, BatchAssociateResourceRequest> {
    private static final SdkField<String> RESOURCE_SET_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceSetIdentifier").getter(BatchAssociateResourceRequest.getter(BatchAssociateResourceRequest::resourceSetIdentifier)).setter(BatchAssociateResourceRequest.setter(Builder::resourceSetIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceSetIdentifier").build()}).build();
    private static final SdkField<List<String>> ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Items").getter(BatchAssociateResourceRequest.getter(BatchAssociateResourceRequest::items)).setter(BatchAssociateResourceRequest.setter(Builder::items)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Items").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_SET_IDENTIFIER_FIELD, ITEMS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchAssociateResourceRequest.memberNameToFieldInitializer();
    private final String resourceSetIdentifier;
    private final List<String> items;

    private BatchAssociateResourceRequest(BuilderImpl builder) {
        super(builder);
        this.resourceSetIdentifier = builder.resourceSetIdentifier;
        this.items = builder.items;
    }

    public final String resourceSetIdentifier() {
        return this.resourceSetIdentifier;
    }

    public final boolean hasItems() {
        return this.items != null && !(this.items instanceof SdkAutoConstructList);
    }

    public final List<String> items() {
        return this.items;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceSetIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasItems() ? this.items() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchAssociateResourceRequest)) {
            return false;
        }
        BatchAssociateResourceRequest other = (BatchAssociateResourceRequest)((Object)obj);
        return Objects.equals(this.resourceSetIdentifier(), other.resourceSetIdentifier()) && this.hasItems() == other.hasItems() && Objects.equals(this.items(), other.items());
    }

    public final String toString() {
        return ToString.builder((String)"BatchAssociateResourceRequest").add("ResourceSetIdentifier", (Object)this.resourceSetIdentifier()).add("Items", this.hasItems() ? this.items() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceSetIdentifier": {
                return Optional.ofNullable(clazz.cast(this.resourceSetIdentifier()));
            }
            case "Items": {
                return Optional.ofNullable(clazz.cast(this.items()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ResourceSetIdentifier", RESOURCE_SET_IDENTIFIER_FIELD);
        map.put("Items", ITEMS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchAssociateResourceRequest, T> g) {
        return obj -> g.apply((BatchAssociateResourceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FmsRequest.BuilderImpl
    implements Builder {
        private String resourceSetIdentifier;
        private List<String> items = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchAssociateResourceRequest model) {
            super(model);
            this.resourceSetIdentifier(model.resourceSetIdentifier);
            this.items(model.items);
        }

        public final String getResourceSetIdentifier() {
            return this.resourceSetIdentifier;
        }

        public final void setResourceSetIdentifier(String resourceSetIdentifier) {
            this.resourceSetIdentifier = resourceSetIdentifier;
        }

        @Override
        public final Builder resourceSetIdentifier(String resourceSetIdentifier) {
            this.resourceSetIdentifier = resourceSetIdentifier;
            return this;
        }

        public final Collection<String> getItems() {
            if (this.items instanceof SdkAutoConstructList) {
                return null;
            }
            return this.items;
        }

        public final void setItems(Collection<String> items) {
            this.items = IdentifierListCopier.copy(items);
        }

        @Override
        public final Builder items(Collection<String> items) {
            this.items = IdentifierListCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(String ... items) {
            this.items(Arrays.asList(items));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchAssociateResourceRequest build() {
            return new BatchAssociateResourceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends FmsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchAssociateResourceRequest> {
        public Builder resourceSetIdentifier(String var1);

        public Builder items(Collection<String> var1);

        public Builder items(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

