/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.fms.model.Route;
import software.amazon.awssdk.services.fms.model.RoutesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NetworkFirewallUnexpectedFirewallRoutesViolation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NetworkFirewallUnexpectedFirewallRoutesViolation> {
    private static final SdkField<String> FIREWALL_SUBNET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FirewallSubnetId").getter(NetworkFirewallUnexpectedFirewallRoutesViolation.getter(NetworkFirewallUnexpectedFirewallRoutesViolation::firewallSubnetId)).setter(NetworkFirewallUnexpectedFirewallRoutesViolation.setter(Builder::firewallSubnetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallSubnetId").build()}).build();
    private static final SdkField<List<Route>> VIOLATING_ROUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ViolatingRoutes").getter(NetworkFirewallUnexpectedFirewallRoutesViolation.getter(NetworkFirewallUnexpectedFirewallRoutesViolation::violatingRoutes)).setter(NetworkFirewallUnexpectedFirewallRoutesViolation.setter(Builder::violatingRoutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ViolatingRoutes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Route::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ROUTE_TABLE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RouteTableId").getter(NetworkFirewallUnexpectedFirewallRoutesViolation.getter(NetworkFirewallUnexpectedFirewallRoutesViolation::routeTableId)).setter(NetworkFirewallUnexpectedFirewallRoutesViolation.setter(Builder::routeTableId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteTableId").build()}).build();
    private static final SdkField<String> FIREWALL_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FirewallEndpoint").getter(NetworkFirewallUnexpectedFirewallRoutesViolation.getter(NetworkFirewallUnexpectedFirewallRoutesViolation::firewallEndpoint)).setter(NetworkFirewallUnexpectedFirewallRoutesViolation.setter(Builder::firewallEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallEndpoint").build()}).build();
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcId").getter(NetworkFirewallUnexpectedFirewallRoutesViolation.getter(NetworkFirewallUnexpectedFirewallRoutesViolation::vpcId)).setter(NetworkFirewallUnexpectedFirewallRoutesViolation.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIREWALL_SUBNET_ID_FIELD, VIOLATING_ROUTES_FIELD, ROUTE_TABLE_ID_FIELD, FIREWALL_ENDPOINT_FIELD, VPC_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("FirewallSubnetId", FIREWALL_SUBNET_ID_FIELD);
            this.put("ViolatingRoutes", VIOLATING_ROUTES_FIELD);
            this.put("RouteTableId", ROUTE_TABLE_ID_FIELD);
            this.put("FirewallEndpoint", FIREWALL_ENDPOINT_FIELD);
            this.put("VpcId", VPC_ID_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String firewallSubnetId;
    private final List<Route> violatingRoutes;
    private final String routeTableId;
    private final String firewallEndpoint;
    private final String vpcId;

    private NetworkFirewallUnexpectedFirewallRoutesViolation(BuilderImpl builder) {
        this.firewallSubnetId = builder.firewallSubnetId;
        this.violatingRoutes = builder.violatingRoutes;
        this.routeTableId = builder.routeTableId;
        this.firewallEndpoint = builder.firewallEndpoint;
        this.vpcId = builder.vpcId;
    }

    public final String firewallSubnetId() {
        return this.firewallSubnetId;
    }

    public final boolean hasViolatingRoutes() {
        return this.violatingRoutes != null && !(this.violatingRoutes instanceof SdkAutoConstructList);
    }

    public final List<Route> violatingRoutes() {
        return this.violatingRoutes;
    }

    public final String routeTableId() {
        return this.routeTableId;
    }

    public final String firewallEndpoint() {
        return this.firewallEndpoint;
    }

    public final String vpcId() {
        return this.vpcId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.firewallSubnetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasViolatingRoutes() ? this.violatingRoutes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.routeTableId());
        hashCode = 31 * hashCode + Objects.hashCode(this.firewallEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkFirewallUnexpectedFirewallRoutesViolation)) {
            return false;
        }
        NetworkFirewallUnexpectedFirewallRoutesViolation other = (NetworkFirewallUnexpectedFirewallRoutesViolation)obj;
        return Objects.equals(this.firewallSubnetId(), other.firewallSubnetId()) && this.hasViolatingRoutes() == other.hasViolatingRoutes() && Objects.equals(this.violatingRoutes(), other.violatingRoutes()) && Objects.equals(this.routeTableId(), other.routeTableId()) && Objects.equals(this.firewallEndpoint(), other.firewallEndpoint()) && Objects.equals(this.vpcId(), other.vpcId());
    }

    public final String toString() {
        return ToString.builder((String)"NetworkFirewallUnexpectedFirewallRoutesViolation").add("FirewallSubnetId", (Object)this.firewallSubnetId()).add("ViolatingRoutes", this.hasViolatingRoutes() ? this.violatingRoutes() : null).add("RouteTableId", (Object)this.routeTableId()).add("FirewallEndpoint", (Object)this.firewallEndpoint()).add("VpcId", (Object)this.vpcId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FirewallSubnetId": {
                return Optional.ofNullable(clazz.cast(this.firewallSubnetId()));
            }
            case "ViolatingRoutes": {
                return Optional.ofNullable(clazz.cast(this.violatingRoutes()));
            }
            case "RouteTableId": {
                return Optional.ofNullable(clazz.cast(this.routeTableId()));
            }
            case "FirewallEndpoint": {
                return Optional.ofNullable(clazz.cast(this.firewallEndpoint()));
            }
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<NetworkFirewallUnexpectedFirewallRoutesViolation, T> g) {
        return obj -> g.apply((NetworkFirewallUnexpectedFirewallRoutesViolation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String firewallSubnetId;
        private List<Route> violatingRoutes = DefaultSdkAutoConstructList.getInstance();
        private String routeTableId;
        private String firewallEndpoint;
        private String vpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkFirewallUnexpectedFirewallRoutesViolation model) {
            this.firewallSubnetId(model.firewallSubnetId);
            this.violatingRoutes(model.violatingRoutes);
            this.routeTableId(model.routeTableId);
            this.firewallEndpoint(model.firewallEndpoint);
            this.vpcId(model.vpcId);
        }

        public final String getFirewallSubnetId() {
            return this.firewallSubnetId;
        }

        public final void setFirewallSubnetId(String firewallSubnetId) {
            this.firewallSubnetId = firewallSubnetId;
        }

        @Override
        public final Builder firewallSubnetId(String firewallSubnetId) {
            this.firewallSubnetId = firewallSubnetId;
            return this;
        }

        public final List<Route.Builder> getViolatingRoutes() {
            List<Route.Builder> result = RoutesCopier.copyToBuilder(this.violatingRoutes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setViolatingRoutes(Collection<Route.BuilderImpl> violatingRoutes) {
            this.violatingRoutes = RoutesCopier.copyFromBuilder(violatingRoutes);
        }

        @Override
        public final Builder violatingRoutes(Collection<Route> violatingRoutes) {
            this.violatingRoutes = RoutesCopier.copy(violatingRoutes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder violatingRoutes(Route ... violatingRoutes) {
            this.violatingRoutes(Arrays.asList(violatingRoutes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder violatingRoutes(Consumer<Route.Builder> ... violatingRoutes) {
            this.violatingRoutes(Stream.of(violatingRoutes).map(c -> (Route)((Route.Builder)Route.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getRouteTableId() {
            return this.routeTableId;
        }

        public final void setRouteTableId(String routeTableId) {
            this.routeTableId = routeTableId;
        }

        @Override
        public final Builder routeTableId(String routeTableId) {
            this.routeTableId = routeTableId;
            return this;
        }

        public final String getFirewallEndpoint() {
            return this.firewallEndpoint;
        }

        public final void setFirewallEndpoint(String firewallEndpoint) {
            this.firewallEndpoint = firewallEndpoint;
        }

        @Override
        public final Builder firewallEndpoint(String firewallEndpoint) {
            this.firewallEndpoint = firewallEndpoint;
            return this;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public NetworkFirewallUnexpectedFirewallRoutesViolation build() {
            return new NetworkFirewallUnexpectedFirewallRoutesViolation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NetworkFirewallUnexpectedFirewallRoutesViolation> {
        public Builder firewallSubnetId(String var1);

        public Builder violatingRoutes(Collection<Route> var1);

        public Builder violatingRoutes(Route ... var1);

        public Builder violatingRoutes(Consumer<Route.Builder> ... var1);

        public Builder routeTableId(String var1);

        public Builder firewallEndpoint(String var1);

        public Builder vpcId(String var1);
    }
}

