/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.fms.model.ActionTarget;
import software.amazon.awssdk.services.fms.model.EntriesDescriptionCopier;
import software.amazon.awssdk.services.fms.model.EntryDescription;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteNetworkAclEntriesAction
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DeleteNetworkAclEntriesAction> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(DeleteNetworkAclEntriesAction.getter(DeleteNetworkAclEntriesAction::description)).setter(DeleteNetworkAclEntriesAction.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<ActionTarget> NETWORK_ACL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NetworkAclId").getter(DeleteNetworkAclEntriesAction.getter(DeleteNetworkAclEntriesAction::networkAclId)).setter(DeleteNetworkAclEntriesAction.setter(Builder::networkAclId)).constructor(ActionTarget::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkAclId").build()}).build();
    private static final SdkField<List<EntryDescription>> NETWORK_ACL_ENTRIES_TO_BE_DELETED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NetworkAclEntriesToBeDeleted").getter(DeleteNetworkAclEntriesAction.getter(DeleteNetworkAclEntriesAction::networkAclEntriesToBeDeleted)).setter(DeleteNetworkAclEntriesAction.setter(Builder::networkAclEntriesToBeDeleted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkAclEntriesToBeDeleted").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EntryDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> FMS_CAN_REMEDIATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("FMSCanRemediate").getter(DeleteNetworkAclEntriesAction.getter(DeleteNetworkAclEntriesAction::fmsCanRemediate)).setter(DeleteNetworkAclEntriesAction.setter(Builder::fmsCanRemediate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FMSCanRemediate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, NETWORK_ACL_ID_FIELD, NETWORK_ACL_ENTRIES_TO_BE_DELETED_FIELD, FMS_CAN_REMEDIATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Description", DESCRIPTION_FIELD);
            this.put("NetworkAclId", NETWORK_ACL_ID_FIELD);
            this.put("NetworkAclEntriesToBeDeleted", NETWORK_ACL_ENTRIES_TO_BE_DELETED_FIELD);
            this.put("FMSCanRemediate", FMS_CAN_REMEDIATE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String description;
    private final ActionTarget networkAclId;
    private final List<EntryDescription> networkAclEntriesToBeDeleted;
    private final Boolean fmsCanRemediate;

    private DeleteNetworkAclEntriesAction(BuilderImpl builder) {
        this.description = builder.description;
        this.networkAclId = builder.networkAclId;
        this.networkAclEntriesToBeDeleted = builder.networkAclEntriesToBeDeleted;
        this.fmsCanRemediate = builder.fmsCanRemediate;
    }

    public final String description() {
        return this.description;
    }

    public final ActionTarget networkAclId() {
        return this.networkAclId;
    }

    public final boolean hasNetworkAclEntriesToBeDeleted() {
        return this.networkAclEntriesToBeDeleted != null && !(this.networkAclEntriesToBeDeleted instanceof SdkAutoConstructList);
    }

    public final List<EntryDescription> networkAclEntriesToBeDeleted() {
        return this.networkAclEntriesToBeDeleted;
    }

    public final Boolean fmsCanRemediate() {
        return this.fmsCanRemediate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkAclId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNetworkAclEntriesToBeDeleted() ? this.networkAclEntriesToBeDeleted() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.fmsCanRemediate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteNetworkAclEntriesAction)) {
            return false;
        }
        DeleteNetworkAclEntriesAction other = (DeleteNetworkAclEntriesAction)obj;
        return Objects.equals(this.description(), other.description()) && Objects.equals(this.networkAclId(), other.networkAclId()) && this.hasNetworkAclEntriesToBeDeleted() == other.hasNetworkAclEntriesToBeDeleted() && Objects.equals(this.networkAclEntriesToBeDeleted(), other.networkAclEntriesToBeDeleted()) && Objects.equals(this.fmsCanRemediate(), other.fmsCanRemediate());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteNetworkAclEntriesAction").add("Description", (Object)this.description()).add("NetworkAclId", (Object)this.networkAclId()).add("NetworkAclEntriesToBeDeleted", this.hasNetworkAclEntriesToBeDeleted() ? this.networkAclEntriesToBeDeleted() : null).add("FMSCanRemediate", (Object)this.fmsCanRemediate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "NetworkAclId": {
                return Optional.ofNullable(clazz.cast(this.networkAclId()));
            }
            case "NetworkAclEntriesToBeDeleted": {
                return Optional.ofNullable(clazz.cast(this.networkAclEntriesToBeDeleted()));
            }
            case "FMSCanRemediate": {
                return Optional.ofNullable(clazz.cast(this.fmsCanRemediate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DeleteNetworkAclEntriesAction, T> g) {
        return obj -> g.apply((DeleteNetworkAclEntriesAction)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String description;
        private ActionTarget networkAclId;
        private List<EntryDescription> networkAclEntriesToBeDeleted = DefaultSdkAutoConstructList.getInstance();
        private Boolean fmsCanRemediate;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteNetworkAclEntriesAction model) {
            this.description(model.description);
            this.networkAclId(model.networkAclId);
            this.networkAclEntriesToBeDeleted(model.networkAclEntriesToBeDeleted);
            this.fmsCanRemediate(model.fmsCanRemediate);
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final ActionTarget.Builder getNetworkAclId() {
            return this.networkAclId != null ? this.networkAclId.toBuilder() : null;
        }

        public final void setNetworkAclId(ActionTarget.BuilderImpl networkAclId) {
            this.networkAclId = networkAclId != null ? networkAclId.build() : null;
        }

        @Override
        public final Builder networkAclId(ActionTarget networkAclId) {
            this.networkAclId = networkAclId;
            return this;
        }

        public final List<EntryDescription.Builder> getNetworkAclEntriesToBeDeleted() {
            List<EntryDescription.Builder> result = EntriesDescriptionCopier.copyToBuilder(this.networkAclEntriesToBeDeleted);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNetworkAclEntriesToBeDeleted(Collection<EntryDescription.BuilderImpl> networkAclEntriesToBeDeleted) {
            this.networkAclEntriesToBeDeleted = EntriesDescriptionCopier.copyFromBuilder(networkAclEntriesToBeDeleted);
        }

        @Override
        public final Builder networkAclEntriesToBeDeleted(Collection<EntryDescription> networkAclEntriesToBeDeleted) {
            this.networkAclEntriesToBeDeleted = EntriesDescriptionCopier.copy(networkAclEntriesToBeDeleted);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkAclEntriesToBeDeleted(EntryDescription ... networkAclEntriesToBeDeleted) {
            this.networkAclEntriesToBeDeleted(Arrays.asList(networkAclEntriesToBeDeleted));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkAclEntriesToBeDeleted(Consumer<EntryDescription.Builder> ... networkAclEntriesToBeDeleted) {
            this.networkAclEntriesToBeDeleted(Stream.of(networkAclEntriesToBeDeleted).map(c -> (EntryDescription)((EntryDescription.Builder)EntryDescription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getFmsCanRemediate() {
            return this.fmsCanRemediate;
        }

        public final void setFmsCanRemediate(Boolean fmsCanRemediate) {
            this.fmsCanRemediate = fmsCanRemediate;
        }

        @Override
        public final Builder fmsCanRemediate(Boolean fmsCanRemediate) {
            this.fmsCanRemediate = fmsCanRemediate;
            return this;
        }

        public DeleteNetworkAclEntriesAction build() {
            return new DeleteNetworkAclEntriesAction(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DeleteNetworkAclEntriesAction> {
        public Builder description(String var1);

        public Builder networkAclId(ActionTarget var1);

        default public Builder networkAclId(Consumer<ActionTarget.Builder> networkAclId) {
            return this.networkAclId((ActionTarget)((ActionTarget.Builder)ActionTarget.builder().applyMutation(networkAclId)).build());
        }

        public Builder networkAclEntriesToBeDeleted(Collection<EntryDescription> var1);

        public Builder networkAclEntriesToBeDeleted(EntryDescription ... var1);

        public Builder networkAclEntriesToBeDeleted(Consumer<EntryDescription.Builder> ... var1);

        public Builder fmsCanRemediate(Boolean var1);
    }
}

