/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fms.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.fms.model.AdminScope;
import software.amazon.awssdk.services.fms.model.FmsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutAdminAccountRequest
extends FmsRequest
implements ToCopyableBuilder<Builder, PutAdminAccountRequest> {
    private static final SdkField<String> ADMIN_ACCOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AdminAccount").getter(PutAdminAccountRequest.getter(PutAdminAccountRequest::adminAccount)).setter(PutAdminAccountRequest.setter(Builder::adminAccount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdminAccount").build()}).build();
    private static final SdkField<AdminScope> ADMIN_SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AdminScope").getter(PutAdminAccountRequest.getter(PutAdminAccountRequest::adminScope)).setter(PutAdminAccountRequest.setter(Builder::adminScope)).constructor(AdminScope::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdminScope").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADMIN_ACCOUNT_FIELD, ADMIN_SCOPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("AdminAccount", ADMIN_ACCOUNT_FIELD);
            this.put("AdminScope", ADMIN_SCOPE_FIELD);
        }
    });
    private final String adminAccount;
    private final AdminScope adminScope;

    private PutAdminAccountRequest(BuilderImpl builder) {
        super(builder);
        this.adminAccount = builder.adminAccount;
        this.adminScope = builder.adminScope;
    }

    public final String adminAccount() {
        return this.adminAccount;
    }

    public final AdminScope adminScope() {
        return this.adminScope;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.adminAccount());
        hashCode = 31 * hashCode + Objects.hashCode(this.adminScope());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutAdminAccountRequest)) {
            return false;
        }
        PutAdminAccountRequest other = (PutAdminAccountRequest)((Object)obj);
        return Objects.equals(this.adminAccount(), other.adminAccount()) && Objects.equals(this.adminScope(), other.adminScope());
    }

    public final String toString() {
        return ToString.builder((String)"PutAdminAccountRequest").add("AdminAccount", (Object)this.adminAccount()).add("AdminScope", (Object)this.adminScope()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AdminAccount": {
                return Optional.ofNullable(clazz.cast(this.adminAccount()));
            }
            case "AdminScope": {
                return Optional.ofNullable(clazz.cast(this.adminScope()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PutAdminAccountRequest, T> g) {
        return obj -> g.apply((PutAdminAccountRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FmsRequest.BuilderImpl
    implements Builder {
        private String adminAccount;
        private AdminScope adminScope;

        private BuilderImpl() {
        }

        private BuilderImpl(PutAdminAccountRequest model) {
            super(model);
            this.adminAccount(model.adminAccount);
            this.adminScope(model.adminScope);
        }

        public final String getAdminAccount() {
            return this.adminAccount;
        }

        public final void setAdminAccount(String adminAccount) {
            this.adminAccount = adminAccount;
        }

        @Override
        public final Builder adminAccount(String adminAccount) {
            this.adminAccount = adminAccount;
            return this;
        }

        public final AdminScope.Builder getAdminScope() {
            return this.adminScope != null ? this.adminScope.toBuilder() : null;
        }

        public final void setAdminScope(AdminScope.BuilderImpl adminScope) {
            this.adminScope = adminScope != null ? adminScope.build() : null;
        }

        @Override
        public final Builder adminScope(AdminScope adminScope) {
            this.adminScope = adminScope;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutAdminAccountRequest build() {
            return new PutAdminAccountRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends FmsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutAdminAccountRequest> {
        public Builder adminAccount(String var1);

        public Builder adminScope(AdminScope var1);

        default public Builder adminScope(Consumer<AdminScope.Builder> adminScope) {
            return this.adminScope((AdminScope)((AdminScope.Builder)AdminScope.builder().applyMutation(adminScope)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

