/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fms.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.fms.FmsClient;
import software.amazon.awssdk.services.fms.internal.UserAgentUtils;
import software.amazon.awssdk.services.fms.model.AdminAccountSummary;
import software.amazon.awssdk.services.fms.model.ListAdminAccountsForOrganizationRequest;
import software.amazon.awssdk.services.fms.model.ListAdminAccountsForOrganizationResponse;

public class ListAdminAccountsForOrganizationIterable
implements SdkIterable<ListAdminAccountsForOrganizationResponse> {
    private final FmsClient client;
    private final ListAdminAccountsForOrganizationRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAdminAccountsForOrganizationIterable(FmsClient client, ListAdminAccountsForOrganizationRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAdminAccountsForOrganizationResponseFetcher();
    }

    public Iterator<ListAdminAccountsForOrganizationResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AdminAccountSummary> adminAccounts() {
        Function<ListAdminAccountsForOrganizationResponse, Iterator> getIterator = response -> {
            if (response != null && response.adminAccounts() != null) {
                return response.adminAccounts().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAdminAccountsForOrganizationResponseFetcher
    implements SyncPageFetcher<ListAdminAccountsForOrganizationResponse> {
        private ListAdminAccountsForOrganizationResponseFetcher() {
        }

        public boolean hasNextPage(ListAdminAccountsForOrganizationResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAdminAccountsForOrganizationResponse nextPage(ListAdminAccountsForOrganizationResponse previousPage) {
            if (previousPage == null) {
                return ListAdminAccountsForOrganizationIterable.this.client.listAdminAccountsForOrganization(ListAdminAccountsForOrganizationIterable.this.firstRequest);
            }
            return ListAdminAccountsForOrganizationIterable.this.client.listAdminAccountsForOrganization((ListAdminAccountsForOrganizationRequest)((Object)ListAdminAccountsForOrganizationIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

