/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fms.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.fms.FmsClient;
import software.amazon.awssdk.services.fms.model.ListAdminsManagingAccountRequest;
import software.amazon.awssdk.services.fms.model.ListAdminsManagingAccountResponse;

public class ListAdminsManagingAccountIterable
implements SdkIterable<ListAdminsManagingAccountResponse> {
    private final FmsClient client;
    private final ListAdminsManagingAccountRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAdminsManagingAccountIterable(FmsClient client, ListAdminsManagingAccountRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListAdminsManagingAccountResponseFetcher();
    }

    public Iterator<ListAdminsManagingAccountResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<String> adminAccounts() {
        Function<ListAdminsManagingAccountResponse, Iterator> getIterator = response -> {
            if (response != null && response.adminAccounts() != null) {
                return response.adminAccounts().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAdminsManagingAccountResponseFetcher
    implements SyncPageFetcher<ListAdminsManagingAccountResponse> {
        private ListAdminsManagingAccountResponseFetcher() {
        }

        public boolean hasNextPage(ListAdminsManagingAccountResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAdminsManagingAccountResponse nextPage(ListAdminsManagingAccountResponse previousPage) {
            if (previousPage == null) {
                return ListAdminsManagingAccountIterable.this.client.listAdminsManagingAccount(ListAdminsManagingAccountIterable.this.firstRequest);
            }
            return ListAdminsManagingAccountIterable.this.client.listAdminsManagingAccount((ListAdminsManagingAccountRequest)((Object)ListAdminsManagingAccountIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

