/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SecurityGroupRuleDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SecurityGroupRuleDescription> {
    private static final SdkField<String> IPV4_RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IPV4Range").getter(SecurityGroupRuleDescription.getter(SecurityGroupRuleDescription::ipv4Range)).setter(SecurityGroupRuleDescription.setter(Builder::ipv4Range)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IPV4Range").build()}).build();
    private static final SdkField<String> IPV6_RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IPV6Range").getter(SecurityGroupRuleDescription.getter(SecurityGroupRuleDescription::ipv6Range)).setter(SecurityGroupRuleDescription.setter(Builder::ipv6Range)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IPV6Range").build()}).build();
    private static final SdkField<String> PREFIX_LIST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrefixListId").getter(SecurityGroupRuleDescription.getter(SecurityGroupRuleDescription::prefixListId)).setter(SecurityGroupRuleDescription.setter(Builder::prefixListId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrefixListId").build()}).build();
    private static final SdkField<String> PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Protocol").getter(SecurityGroupRuleDescription.getter(SecurityGroupRuleDescription::protocol)).setter(SecurityGroupRuleDescription.setter(Builder::protocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocol").build()}).build();
    private static final SdkField<Long> FROM_PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("FromPort").getter(SecurityGroupRuleDescription.getter(SecurityGroupRuleDescription::fromPort)).setter(SecurityGroupRuleDescription.setter(Builder::fromPort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FromPort").build()}).build();
    private static final SdkField<Long> TO_PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ToPort").getter(SecurityGroupRuleDescription.getter(SecurityGroupRuleDescription::toPort)).setter(SecurityGroupRuleDescription.setter(Builder::toPort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ToPort").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IPV4_RANGE_FIELD, IPV6_RANGE_FIELD, PREFIX_LIST_ID_FIELD, PROTOCOL_FIELD, FROM_PORT_FIELD, TO_PORT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String ipv4Range;
    private final String ipv6Range;
    private final String prefixListId;
    private final String protocol;
    private final Long fromPort;
    private final Long toPort;

    private SecurityGroupRuleDescription(BuilderImpl builder) {
        this.ipv4Range = builder.ipv4Range;
        this.ipv6Range = builder.ipv6Range;
        this.prefixListId = builder.prefixListId;
        this.protocol = builder.protocol;
        this.fromPort = builder.fromPort;
        this.toPort = builder.toPort;
    }

    public final String ipv4Range() {
        return this.ipv4Range;
    }

    public final String ipv6Range() {
        return this.ipv6Range;
    }

    public final String prefixListId() {
        return this.prefixListId;
    }

    public final String protocol() {
        return this.protocol;
    }

    public final Long fromPort() {
        return this.fromPort;
    }

    public final Long toPort() {
        return this.toPort;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ipv4Range());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipv6Range());
        hashCode = 31 * hashCode + Objects.hashCode(this.prefixListId());
        hashCode = 31 * hashCode + Objects.hashCode(this.protocol());
        hashCode = 31 * hashCode + Objects.hashCode(this.fromPort());
        hashCode = 31 * hashCode + Objects.hashCode(this.toPort());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SecurityGroupRuleDescription)) {
            return false;
        }
        SecurityGroupRuleDescription other = (SecurityGroupRuleDescription)obj;
        return Objects.equals(this.ipv4Range(), other.ipv4Range()) && Objects.equals(this.ipv6Range(), other.ipv6Range()) && Objects.equals(this.prefixListId(), other.prefixListId()) && Objects.equals(this.protocol(), other.protocol()) && Objects.equals(this.fromPort(), other.fromPort()) && Objects.equals(this.toPort(), other.toPort());
    }

    public final String toString() {
        return ToString.builder((String)"SecurityGroupRuleDescription").add("IPV4Range", (Object)this.ipv4Range()).add("IPV6Range", (Object)this.ipv6Range()).add("PrefixListId", (Object)this.prefixListId()).add("Protocol", (Object)this.protocol()).add("FromPort", (Object)this.fromPort()).add("ToPort", (Object)this.toPort()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IPV4Range": {
                return Optional.ofNullable(clazz.cast(this.ipv4Range()));
            }
            case "IPV6Range": {
                return Optional.ofNullable(clazz.cast(this.ipv6Range()));
            }
            case "PrefixListId": {
                return Optional.ofNullable(clazz.cast(this.prefixListId()));
            }
            case "Protocol": {
                return Optional.ofNullable(clazz.cast(this.protocol()));
            }
            case "FromPort": {
                return Optional.ofNullable(clazz.cast(this.fromPort()));
            }
            case "ToPort": {
                return Optional.ofNullable(clazz.cast(this.toPort()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SecurityGroupRuleDescription, T> g) {
        return obj -> g.apply((SecurityGroupRuleDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String ipv4Range;
        private String ipv6Range;
        private String prefixListId;
        private String protocol;
        private Long fromPort;
        private Long toPort;

        private BuilderImpl() {
        }

        private BuilderImpl(SecurityGroupRuleDescription model) {
            this.ipv4Range(model.ipv4Range);
            this.ipv6Range(model.ipv6Range);
            this.prefixListId(model.prefixListId);
            this.protocol(model.protocol);
            this.fromPort(model.fromPort);
            this.toPort(model.toPort);
        }

        public final String getIpv4Range() {
            return this.ipv4Range;
        }

        public final void setIpv4Range(String ipv4Range) {
            this.ipv4Range = ipv4Range;
        }

        @Override
        public final Builder ipv4Range(String ipv4Range) {
            this.ipv4Range = ipv4Range;
            return this;
        }

        public final String getIpv6Range() {
            return this.ipv6Range;
        }

        public final void setIpv6Range(String ipv6Range) {
            this.ipv6Range = ipv6Range;
        }

        @Override
        public final Builder ipv6Range(String ipv6Range) {
            this.ipv6Range = ipv6Range;
            return this;
        }

        public final String getPrefixListId() {
            return this.prefixListId;
        }

        public final void setPrefixListId(String prefixListId) {
            this.prefixListId = prefixListId;
        }

        @Override
        public final Builder prefixListId(String prefixListId) {
            this.prefixListId = prefixListId;
            return this;
        }

        public final String getProtocol() {
            return this.protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public final Long getFromPort() {
            return this.fromPort;
        }

        public final void setFromPort(Long fromPort) {
            this.fromPort = fromPort;
        }

        @Override
        public final Builder fromPort(Long fromPort) {
            this.fromPort = fromPort;
            return this;
        }

        public final Long getToPort() {
            return this.toPort;
        }

        public final void setToPort(Long toPort) {
            this.toPort = toPort;
        }

        @Override
        public final Builder toPort(Long toPort) {
            this.toPort = toPort;
            return this;
        }

        public SecurityGroupRuleDescription build() {
            return new SecurityGroupRuleDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SecurityGroupRuleDescription> {
        public Builder ipv4Range(String var1);

        public Builder ipv6Range(String var1);

        public Builder prefixListId(String var1);

        public Builder protocol(String var1);

        public Builder fromPort(Long var1);

        public Builder toPort(Long var1);
    }
}

