/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fms.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.fms.FmsAsyncClient;
import software.amazon.awssdk.services.fms.model.ListProtocolsListsRequest;
import software.amazon.awssdk.services.fms.model.ListProtocolsListsResponse;
import software.amazon.awssdk.services.fms.model.ProtocolsListDataSummary;

public class ListProtocolsListsPublisher
implements SdkPublisher<ListProtocolsListsResponse> {
    private final FmsAsyncClient client;
    private final ListProtocolsListsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListProtocolsListsPublisher(FmsAsyncClient client, ListProtocolsListsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListProtocolsListsPublisher(FmsAsyncClient client, ListProtocolsListsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListProtocolsListsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListProtocolsListsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ProtocolsListDataSummary> protocolsLists() {
        Function<ListProtocolsListsResponse, Iterator> getIterator = response -> {
            if (response != null && response.protocolsLists() != null) {
                return response.protocolsLists().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListProtocolsListsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListProtocolsListsResponseFetcher
    implements AsyncPageFetcher<ListProtocolsListsResponse> {
        private ListProtocolsListsResponseFetcher() {
        }

        public boolean hasNextPage(ListProtocolsListsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListProtocolsListsResponse> nextPage(ListProtocolsListsResponse previousPage) {
            if (previousPage == null) {
                return ListProtocolsListsPublisher.this.client.listProtocolsLists(ListProtocolsListsPublisher.this.firstRequest);
            }
            return ListProtocolsListsPublisher.this.client.listProtocolsLists((ListProtocolsListsRequest)((Object)ListProtocolsListsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

