/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fms.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum TargetType {
    GATEWAY("GATEWAY"),
    CARRIER_GATEWAY("CARRIER_GATEWAY"),
    INSTANCE("INSTANCE"),
    LOCAL_GATEWAY("LOCAL_GATEWAY"),
    NAT_GATEWAY("NAT_GATEWAY"),
    NETWORK_INTERFACE("NETWORK_INTERFACE"),
    VPC_ENDPOINT("VPC_ENDPOINT"),
    VPC_PEERING_CONNECTION("VPC_PEERING_CONNECTION"),
    EGRESS_ONLY_INTERNET_GATEWAY("EGRESS_ONLY_INTERNET_GATEWAY"),
    TRANSIT_GATEWAY("TRANSIT_GATEWAY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private TargetType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TargetType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(TargetType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TargetType> knownValues() {
        return Stream.of(TargetType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

