/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.fms.model.ResourceIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsEc2NetworkInterfaceViolation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsEc2NetworkInterfaceViolation> {
    private static final SdkField<String> VIOLATION_TARGET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ViolationTarget").getter(AwsEc2NetworkInterfaceViolation.getter(AwsEc2NetworkInterfaceViolation::violationTarget)).setter(AwsEc2NetworkInterfaceViolation.setter(Builder::violationTarget)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ViolationTarget").build()}).build();
    private static final SdkField<List<String>> VIOLATING_SECURITY_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ViolatingSecurityGroups").getter(AwsEc2NetworkInterfaceViolation.getter(AwsEc2NetworkInterfaceViolation::violatingSecurityGroups)).setter(AwsEc2NetworkInterfaceViolation.setter(Builder::violatingSecurityGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ViolatingSecurityGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VIOLATION_TARGET_FIELD, VIOLATING_SECURITY_GROUPS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String violationTarget;
    private final List<String> violatingSecurityGroups;

    private AwsEc2NetworkInterfaceViolation(BuilderImpl builder) {
        this.violationTarget = builder.violationTarget;
        this.violatingSecurityGroups = builder.violatingSecurityGroups;
    }

    public final String violationTarget() {
        return this.violationTarget;
    }

    public final boolean hasViolatingSecurityGroups() {
        return this.violatingSecurityGroups != null && !(this.violatingSecurityGroups instanceof SdkAutoConstructList);
    }

    public final List<String> violatingSecurityGroups() {
        return this.violatingSecurityGroups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.violationTarget());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasViolatingSecurityGroups() ? this.violatingSecurityGroups() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEc2NetworkInterfaceViolation)) {
            return false;
        }
        AwsEc2NetworkInterfaceViolation other = (AwsEc2NetworkInterfaceViolation)obj;
        return Objects.equals(this.violationTarget(), other.violationTarget()) && this.hasViolatingSecurityGroups() == other.hasViolatingSecurityGroups() && Objects.equals(this.violatingSecurityGroups(), other.violatingSecurityGroups());
    }

    public final String toString() {
        return ToString.builder((String)"AwsEc2NetworkInterfaceViolation").add("ViolationTarget", (Object)this.violationTarget()).add("ViolatingSecurityGroups", this.hasViolatingSecurityGroups() ? this.violatingSecurityGroups() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ViolationTarget": {
                return Optional.ofNullable(clazz.cast(this.violationTarget()));
            }
            case "ViolatingSecurityGroups": {
                return Optional.ofNullable(clazz.cast(this.violatingSecurityGroups()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsEc2NetworkInterfaceViolation, T> g) {
        return obj -> g.apply((AwsEc2NetworkInterfaceViolation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String violationTarget;
        private List<String> violatingSecurityGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEc2NetworkInterfaceViolation model) {
            this.violationTarget(model.violationTarget);
            this.violatingSecurityGroups(model.violatingSecurityGroups);
        }

        public final String getViolationTarget() {
            return this.violationTarget;
        }

        @Override
        public final Builder violationTarget(String violationTarget) {
            this.violationTarget = violationTarget;
            return this;
        }

        public final void setViolationTarget(String violationTarget) {
            this.violationTarget = violationTarget;
        }

        public final Collection<String> getViolatingSecurityGroups() {
            if (this.violatingSecurityGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return this.violatingSecurityGroups;
        }

        @Override
        public final Builder violatingSecurityGroups(Collection<String> violatingSecurityGroups) {
            this.violatingSecurityGroups = ResourceIdListCopier.copy(violatingSecurityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder violatingSecurityGroups(String ... violatingSecurityGroups) {
            this.violatingSecurityGroups(Arrays.asList(violatingSecurityGroups));
            return this;
        }

        public final void setViolatingSecurityGroups(Collection<String> violatingSecurityGroups) {
            this.violatingSecurityGroups = ResourceIdListCopier.copy(violatingSecurityGroups);
        }

        public AwsEc2NetworkInterfaceViolation build() {
            return new AwsEc2NetworkInterfaceViolation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsEc2NetworkInterfaceViolation> {
        public Builder violationTarget(String var1);

        public Builder violatingSecurityGroups(Collection<String> var1);

        public Builder violatingSecurityGroups(String ... var1);
    }
}

