/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fms.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListMemberAccountsRequest extends FmsRequest implements
        ToCopyableBuilder<ListMemberAccountsRequest.Builder, ListMemberAccountsRequest> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListMemberAccountsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListMemberAccountsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            MAX_RESULTS_FIELD));

    private final String nextToken;

    private final Integer maxResults;

    private ListMemberAccountsRequest(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * If you specify a value for <code>MaxResults</code> and you have more account IDs than the number that you specify
     * for <code>MaxResults</code>, AWS Firewall Manager returns a <code>NextToken</code> value in the response that
     * allows you to list another group of IDs. For the second and subsequent <code>ListMemberAccountsRequest</code>
     * requests, specify the value of <code>NextToken</code> from the previous response to get information about another
     * batch of member account IDs.
     * </p>
     * 
     * @return If you specify a value for <code>MaxResults</code> and you have more account IDs than the number that you
     *         specify for <code>MaxResults</code>, AWS Firewall Manager returns a <code>NextToken</code> value in the
     *         response that allows you to list another group of IDs. For the second and subsequent
     *         <code>ListMemberAccountsRequest</code> requests, specify the value of <code>NextToken</code> from the
     *         previous response to get information about another batch of member account IDs.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Specifies the number of member account IDs that you want AWS Firewall Manager to return for this request. If you
     * have more IDs than the number that you specify for <code>MaxResults</code>, the response includes a
     * <code>NextToken</code> value that you can use to get another batch of member account IDs.
     * </p>
     * 
     * @return Specifies the number of member account IDs that you want AWS Firewall Manager to return for this request.
     *         If you have more IDs than the number that you specify for <code>MaxResults</code>, the response includes
     *         a <code>NextToken</code> value that you can use to get another batch of member account IDs.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMemberAccountsRequest)) {
            return false;
        }
        ListMemberAccountsRequest other = (ListMemberAccountsRequest) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListMemberAccountsRequest").add("NextToken", nextToken()).add("MaxResults", maxResults())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListMemberAccountsRequest, T> g) {
        return obj -> g.apply((ListMemberAccountsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FmsRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListMemberAccountsRequest> {
        /**
         * <p>
         * If you specify a value for <code>MaxResults</code> and you have more account IDs than the number that you
         * specify for <code>MaxResults</code>, AWS Firewall Manager returns a <code>NextToken</code> value in the
         * response that allows you to list another group of IDs. For the second and subsequent
         * <code>ListMemberAccountsRequest</code> requests, specify the value of <code>NextToken</code> from the
         * previous response to get information about another batch of member account IDs.
         * </p>
         * 
         * @param nextToken
         *        If you specify a value for <code>MaxResults</code> and you have more account IDs than the number that
         *        you specify for <code>MaxResults</code>, AWS Firewall Manager returns a <code>NextToken</code> value
         *        in the response that allows you to list another group of IDs. For the second and subsequent
         *        <code>ListMemberAccountsRequest</code> requests, specify the value of <code>NextToken</code> from the
         *        previous response to get information about another batch of member account IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Specifies the number of member account IDs that you want AWS Firewall Manager to return for this request. If
         * you have more IDs than the number that you specify for <code>MaxResults</code>, the response includes a
         * <code>NextToken</code> value that you can use to get another batch of member account IDs.
         * </p>
         * 
         * @param maxResults
         *        Specifies the number of member account IDs that you want AWS Firewall Manager to return for this
         *        request. If you have more IDs than the number that you specify for <code>MaxResults</code>, the
         *        response includes a <code>NextToken</code> value that you can use to get another batch of member
         *        account IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends FmsRequest.BuilderImpl implements Builder {
        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListMemberAccountsRequest model) {
            super(model);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListMemberAccountsRequest build() {
            return new ListMemberAccountsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
