/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.fms.model.ProtocolsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProtocolsListDataSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProtocolsListDataSummary> {
    private static final SdkField<String> LIST_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ListArn").getter(ProtocolsListDataSummary.getter(ProtocolsListDataSummary::listArn)).setter(ProtocolsListDataSummary.setter(Builder::listArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ListArn").build()}).build();
    private static final SdkField<String> LIST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ListId").getter(ProtocolsListDataSummary.getter(ProtocolsListDataSummary::listId)).setter(ProtocolsListDataSummary.setter(Builder::listId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ListId").build()}).build();
    private static final SdkField<String> LIST_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ListName").getter(ProtocolsListDataSummary.getter(ProtocolsListDataSummary::listName)).setter(ProtocolsListDataSummary.setter(Builder::listName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ListName").build()}).build();
    private static final SdkField<List<String>> PROTOCOLS_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ProtocolsList").getter(ProtocolsListDataSummary.getter(ProtocolsListDataSummary::protocolsList)).setter(ProtocolsListDataSummary.setter(Builder::protocolsList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProtocolsList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LIST_ARN_FIELD, LIST_ID_FIELD, LIST_NAME_FIELD, PROTOCOLS_LIST_FIELD));
    private static final long serialVersionUID = 1L;
    private final String listArn;
    private final String listId;
    private final String listName;
    private final List<String> protocolsList;

    private ProtocolsListDataSummary(BuilderImpl builder) {
        this.listArn = builder.listArn;
        this.listId = builder.listId;
        this.listName = builder.listName;
        this.protocolsList = builder.protocolsList;
    }

    public final String listArn() {
        return this.listArn;
    }

    public final String listId() {
        return this.listId;
    }

    public final String listName() {
        return this.listName;
    }

    public final boolean hasProtocolsList() {
        return this.protocolsList != null && !(this.protocolsList instanceof SdkAutoConstructList);
    }

    public final List<String> protocolsList() {
        return this.protocolsList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.listArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.listId());
        hashCode = 31 * hashCode + Objects.hashCode(this.listName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProtocolsList() ? this.protocolsList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProtocolsListDataSummary)) {
            return false;
        }
        ProtocolsListDataSummary other = (ProtocolsListDataSummary)obj;
        return Objects.equals(this.listArn(), other.listArn()) && Objects.equals(this.listId(), other.listId()) && Objects.equals(this.listName(), other.listName()) && this.hasProtocolsList() == other.hasProtocolsList() && Objects.equals(this.protocolsList(), other.protocolsList());
    }

    public final String toString() {
        return ToString.builder((String)"ProtocolsListDataSummary").add("ListArn", (Object)this.listArn()).add("ListId", (Object)this.listId()).add("ListName", (Object)this.listName()).add("ProtocolsList", this.hasProtocolsList() ? this.protocolsList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ListArn": {
                return Optional.ofNullable(clazz.cast(this.listArn()));
            }
            case "ListId": {
                return Optional.ofNullable(clazz.cast(this.listId()));
            }
            case "ListName": {
                return Optional.ofNullable(clazz.cast(this.listName()));
            }
            case "ProtocolsList": {
                return Optional.ofNullable(clazz.cast(this.protocolsList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProtocolsListDataSummary, T> g) {
        return obj -> g.apply((ProtocolsListDataSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String listArn;
        private String listId;
        private String listName;
        private List<String> protocolsList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ProtocolsListDataSummary model) {
            this.listArn(model.listArn);
            this.listId(model.listId);
            this.listName(model.listName);
            this.protocolsList(model.protocolsList);
        }

        public final String getListArn() {
            return this.listArn;
        }

        @Override
        public final Builder listArn(String listArn) {
            this.listArn = listArn;
            return this;
        }

        public final void setListArn(String listArn) {
            this.listArn = listArn;
        }

        public final String getListId() {
            return this.listId;
        }

        @Override
        public final Builder listId(String listId) {
            this.listId = listId;
            return this;
        }

        public final void setListId(String listId) {
            this.listId = listId;
        }

        public final String getListName() {
            return this.listName;
        }

        @Override
        public final Builder listName(String listName) {
            this.listName = listName;
            return this;
        }

        public final void setListName(String listName) {
            this.listName = listName;
        }

        public final Collection<String> getProtocolsList() {
            if (this.protocolsList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.protocolsList;
        }

        @Override
        public final Builder protocolsList(Collection<String> protocolsList) {
            this.protocolsList = ProtocolsListCopier.copy(protocolsList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder protocolsList(String ... protocolsList) {
            this.protocolsList(Arrays.asList(protocolsList));
            return this;
        }

        public final void setProtocolsList(Collection<String> protocolsList) {
            this.protocolsList = ProtocolsListCopier.copy(protocolsList);
        }

        public ProtocolsListDataSummary build() {
            return new ProtocolsListDataSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProtocolsListDataSummary> {
        public Builder listArn(String var1);

        public Builder listId(String var1);

        public Builder listName(String var1);

        public Builder protocolsList(Collection<String> var1);

        public Builder protocolsList(String ... var1);
    }
}

