/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.fms.model.App;
import software.amazon.awssdk.services.fms.model.AppsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AppsListDataSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AppsListDataSummary> {
    private static final SdkField<String> LIST_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ListArn").getter(AppsListDataSummary.getter(AppsListDataSummary::listArn)).setter(AppsListDataSummary.setter(Builder::listArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ListArn").build()}).build();
    private static final SdkField<String> LIST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ListId").getter(AppsListDataSummary.getter(AppsListDataSummary::listId)).setter(AppsListDataSummary.setter(Builder::listId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ListId").build()}).build();
    private static final SdkField<String> LIST_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ListName").getter(AppsListDataSummary.getter(AppsListDataSummary::listName)).setter(AppsListDataSummary.setter(Builder::listName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ListName").build()}).build();
    private static final SdkField<List<App>> APPS_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AppsList").getter(AppsListDataSummary.getter(AppsListDataSummary::appsList)).setter(AppsListDataSummary.setter(Builder::appsList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppsList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(App::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LIST_ARN_FIELD, LIST_ID_FIELD, LIST_NAME_FIELD, APPS_LIST_FIELD));
    private static final long serialVersionUID = 1L;
    private final String listArn;
    private final String listId;
    private final String listName;
    private final List<App> appsList;

    private AppsListDataSummary(BuilderImpl builder) {
        this.listArn = builder.listArn;
        this.listId = builder.listId;
        this.listName = builder.listName;
        this.appsList = builder.appsList;
    }

    public final String listArn() {
        return this.listArn;
    }

    public final String listId() {
        return this.listId;
    }

    public final String listName() {
        return this.listName;
    }

    public final boolean hasAppsList() {
        return this.appsList != null && !(this.appsList instanceof SdkAutoConstructList);
    }

    public final List<App> appsList() {
        return this.appsList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.listArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.listId());
        hashCode = 31 * hashCode + Objects.hashCode(this.listName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAppsList() ? this.appsList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AppsListDataSummary)) {
            return false;
        }
        AppsListDataSummary other = (AppsListDataSummary)obj;
        return Objects.equals(this.listArn(), other.listArn()) && Objects.equals(this.listId(), other.listId()) && Objects.equals(this.listName(), other.listName()) && this.hasAppsList() == other.hasAppsList() && Objects.equals(this.appsList(), other.appsList());
    }

    public final String toString() {
        return ToString.builder((String)"AppsListDataSummary").add("ListArn", (Object)this.listArn()).add("ListId", (Object)this.listId()).add("ListName", (Object)this.listName()).add("AppsList", this.hasAppsList() ? this.appsList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ListArn": {
                return Optional.ofNullable(clazz.cast(this.listArn()));
            }
            case "ListId": {
                return Optional.ofNullable(clazz.cast(this.listId()));
            }
            case "ListName": {
                return Optional.ofNullable(clazz.cast(this.listName()));
            }
            case "AppsList": {
                return Optional.ofNullable(clazz.cast(this.appsList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AppsListDataSummary, T> g) {
        return obj -> g.apply((AppsListDataSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String listArn;
        private String listId;
        private String listName;
        private List<App> appsList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AppsListDataSummary model) {
            this.listArn(model.listArn);
            this.listId(model.listId);
            this.listName(model.listName);
            this.appsList(model.appsList);
        }

        public final String getListArn() {
            return this.listArn;
        }

        @Override
        public final Builder listArn(String listArn) {
            this.listArn = listArn;
            return this;
        }

        public final void setListArn(String listArn) {
            this.listArn = listArn;
        }

        public final String getListId() {
            return this.listId;
        }

        @Override
        public final Builder listId(String listId) {
            this.listId = listId;
            return this;
        }

        public final void setListId(String listId) {
            this.listId = listId;
        }

        public final String getListName() {
            return this.listName;
        }

        @Override
        public final Builder listName(String listName) {
            this.listName = listName;
            return this;
        }

        public final void setListName(String listName) {
            this.listName = listName;
        }

        public final Collection<App.Builder> getAppsList() {
            if (this.appsList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.appsList != null ? (Collection)this.appsList.stream().map(App::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder appsList(Collection<App> appsList) {
            this.appsList = AppsListCopier.copy(appsList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder appsList(App ... appsList) {
            this.appsList(Arrays.asList(appsList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder appsList(Consumer<App.Builder> ... appsList) {
            this.appsList(Stream.of(appsList).map(c -> (App)((App.Builder)App.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAppsList(Collection<App.BuilderImpl> appsList) {
            this.appsList = AppsListCopier.copyFromBuilder(appsList);
        }

        public AppsListDataSummary build() {
            return new AppsListDataSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AppsListDataSummary> {
        public Builder listArn(String var1);

        public Builder listId(String var1);

        public Builder listName(String var1);

        public Builder appsList(Collection<App> var1);

        public Builder appsList(App ... var1);

        public Builder appsList(Consumer<App.Builder> ... var1);
    }
}

